/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conf;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.conf.ServletUtil;

public class WebApplicationContextFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
        ServletUtil.initializeSharedConfiguration(filterConfig.getServletContext());
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean reset = false;
        if (request instanceof HttpServletRequest) {
            reset = true;
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            DataContext context = ServletUtil.getSessionContext(session);
            DataContext.bindThreadDataContext(context);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (reset) {
                DataContext.bindThreadDataContext(null);
            }
        }
    }
}

