/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.conn;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.cayenne.conn.PoolManager;
import org.apache.log4j.Logger;

public class ContainerPoolFactory
implements ObjectFactory {
    private static Logger logObj = Logger.getLogger(ContainerPoolFactory.class);

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            logObj.info("unsupported or null reference: " + obj);
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            logObj.info("unsupported type: " + ref.getClassName());
            return null;
        }
        RefAddr ra = null;
        String driver = null;
        String url = null;
        int min = 1;
        int max = 1;
        String username = null;
        String password = null;
        ra = ref.get("min");
        if (ra != null) {
            min = Integer.parseInt(ra.getContent().toString());
        }
        if ((ra = ref.get("max")) != null) {
            max = Integer.parseInt(ra.getContent().toString());
        }
        if ((ra = ref.get("driver")) != null) {
            driver = ra.getContent().toString();
        }
        if ((ra = ref.get("password")) != null) {
            password = ra.getContent().toString();
        }
        if ((ra = ref.get("url")) != null) {
            url = ra.getContent().toString();
        }
        if ((ra = ref.get("username")) != null) {
            username = ra.getContent().toString();
        }
        logObj.info("Loading datasource driver: " + driver);
        logObj.info("Connecting to URL: " + url);
        return new PoolManager(driver, url, min, max, username, password);
    }
}

