/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.frontbase;

import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.frontbase.FrontBaseActionBuilder;
import org.apache.cayenne.dba.frontbase.FrontBaseBooleanType;
import org.apache.cayenne.dba.frontbase.FrontBaseByteArrayType;
import org.apache.cayenne.dba.frontbase.FrontBaseCharType;
import org.apache.cayenne.dba.frontbase.FrontBasePkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DerivedDbEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

public class FrontBaseAdapter
extends JdbcAdapter {
    public FrontBaseAdapter() {
        this.setSupportsBatchUpdates(true);
    }

    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new FrontBaseActionBuilder(this, node.getEntityResolver()));
    }

    public String tableTypeForTable() {
        return "BASE TABLE";
    }

    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new FrontBaseByteArrayType());
        map.registerType(new FrontBaseBooleanType());
        map.registerType(new FrontBaseCharType());
    }

    public String createTable(DbEntity ent) {
        if (ent instanceof DerivedDbEntity) {
            throw new CayenneRuntimeException("Can't create table for derived DbEntity '" + ent.getName() + "'.");
        }
        StringBuffer buf = new StringBuffer();
        buf.append("CREATE TABLE ").append(ent.getFullyQualifiedName()).append(" (");
        Iterator it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            int len;
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            DbAttribute at = (DbAttribute)it.next();
            if (at.getType() == Integer.MAX_VALUE) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.");
            }
            String[] types = this.externalTypesForJdbcType(at.getType());
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType());
            }
            String type = types[0];
            buf.append(at.getName()).append(' ').append(type);
            if (at.getType() == -1) {
                len = at.getMaxLength() > 0 ? at.getMaxLength() : 0x40000000;
                buf.append("(" + len + ")");
            } else if (at.getType() == -3 || at.getType() == -2) {
                len = at.getMaxLength() > 0 ? at.getMaxLength() : 0x40000000;
                buf.append("(" + (len *= 8) + ")");
            } else if (TypesMapping.supportsLength(at.getType())) {
                int prec;
                len = at.getMaxLength();
                int n = prec = TypesMapping.isDecimal(at.getType()) ? at.getPrecision() : -1;
                if (prec > len) {
                    prec = -1;
                }
                if (len > 0) {
                    buf.append('(').append(len);
                    if (prec >= 0) {
                        buf.append(", ").append(prec);
                    }
                    buf.append(')');
                }
            }
            if (!at.isMandatory()) continue;
            buf.append(" NOT NULL");
        }
        Iterator pkit = ent.getPrimaryKey().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = (DbAttribute)pkit.next();
                buf.append(at.getName());
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    public String dropTable(DbEntity ent) {
        return super.dropTable(ent) + " CASCADE";
    }

    protected PkGenerator createPkGenerator() {
        return new FrontBasePkGenerator();
    }
}

