/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.event;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.event.CayenneEvent;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventBridgeFactory;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.EventSubject;
import org.apache.cayenne.property.PropertyUtils;

public class JavaGroupsBridgeFactory
implements EventBridgeFactory {
    public static final String MCAST_ADDRESS_DEFAULT = "228.0.0.5";
    public static final String MCAST_PORT_DEFAULT = "22222";
    public static final String MCAST_ADDRESS_PROPERTY = "cayenne.JavaGroupsBridge.mcast.address";
    public static final String MCAST_PORT_PROPERTY = "cayenne.JavaGroupsBridge.mcast.port";
    public static final String JGROUPS_CONFIG_URL_PROPERTY = "javagroupsbridge.config.url";

    public EventBridge createEventBridge(EventSubject localSubject, Map properties) {
        return this.createEventBridge(Collections.singleton(localSubject), EventBridge.convertToExternalSubject(localSubject), properties);
    }

    public EventBridge createEventBridge(Collection localSubjects, String externalSubject, Map properties) {
        try {
            Class.forName("org.jgroups.Channel");
            return this.createJavaGroupsBridge(localSubjects, externalSubject, properties);
        }
        catch (Exception ex) {
            return this.createNoopBridge();
        }
    }

    private EventBridge createNoopBridge() {
        return new NoopEventBridge();
    }

    private EventBridge createJavaGroupsBridge(Collection localSubjects, String externalSubject, Map properties) {
        try {
            Constructor<?> c = Class.forName("org.apache.cayenne.event.JavaGroupsBridge").getConstructor(Collection.class, String.class);
            Object bridge = c.newInstance(localSubjects, externalSubject);
            String multicastAddress = (String)properties.get(MCAST_ADDRESS_PROPERTY);
            String multicastPort = (String)properties.get(MCAST_PORT_PROPERTY);
            String configURL = (String)properties.get(JGROUPS_CONFIG_URL_PROPERTY);
            PropertyUtils.setProperty(bridge, "configURL", configURL);
            PropertyUtils.setProperty(bridge, "multicastAddress", multicastAddress != null ? multicastAddress : MCAST_ADDRESS_DEFAULT);
            PropertyUtils.setProperty(bridge, "multicastPort", multicastPort != null ? multicastPort : MCAST_PORT_DEFAULT);
            return (EventBridge)bridge;
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error creating JavaGroupsBridge", ex);
        }
    }

    class NoopEventBridge
    extends EventBridge {
        public NoopEventBridge() {
            super(Collections.EMPTY_SET, null);
        }

        public boolean receivesExternalEvents() {
            return false;
        }

        public boolean receivesLocalEvents() {
            return false;
        }

        protected void startupExternal() {
        }

        protected void shutdownExternal() {
        }

        protected void sendExternalEvent(CayenneEvent localEvent) {
        }

        public void startup(EventManager eventManager, int mode, Object eventsSource) {
            this.eventManager = eventManager;
        }

        public void shutdown() {
        }
    }
}

