/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.io.PrintWriter;
import org.apache.cayenne.exp.ASTCompiler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;

public class TernaryExpression
extends Expression {
    protected Object operand0;
    protected Object operand1;
    protected Object operand2;

    public TernaryExpression() {
    }

    public TernaryExpression(int type) {
        this.type = type;
    }

    public Expression notExp() {
        Expression exp = ExpressionFactory.expressionOfType(2);
        exp.setOperand(0, this);
        return exp;
    }

    public Object evaluate(Object o) {
        return ASTCompiler.compile(this).evaluateASTChain(o);
    }

    protected void flattenTree() {
    }

    protected boolean pruneNodeForPrunedChild(Object prunedChild) {
        return true;
    }

    public final int getOperandCount() {
        return 3;
    }

    public Expression shallowCopy() {
        return new TernaryExpression(this.type);
    }

    public Object getOperand(int index) {
        if (index == 0) {
            return this.operand0;
        }
        if (index == 1) {
            return this.operand1;
        }
        if (index == 2) {
            return this.operand2;
        }
        throw new IllegalArgumentException("Invalid operand index for TernaryExpression: " + index);
    }

    public void setOperand(int index, Object value) {
        if (index == 0) {
            this.operand0 = value;
            return;
        }
        if (index == 1) {
            this.operand1 = value;
            return;
        }
        if (index == 2) {
            this.operand2 = value;
            return;
        }
        throw new IllegalArgumentException("Invalid operand index for TernaryExpression: " + index);
    }

    public void encodeAsString(PrintWriter pw) {
        for (int i = 0; i < this.getOperandCount(); ++i) {
            Object op;
            if (i > 0 || this.getOperandCount() == 1) {
                pw.print(" ");
                pw.print(this.expName());
                pw.print(" ");
            }
            if ((op = this.getOperand(i)) == null) {
                pw.print("<null>");
                continue;
            }
            if (op instanceof String) {
                pw.print("'" + op + "'");
                continue;
            }
            if (op instanceof Expression) {
                pw.print('(');
                ((Expression)op).encodeAsString(pw);
                pw.print(')');
                continue;
            }
            pw.print(String.valueOf(op));
        }
    }
}

