/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.DefaultQueryMetadata;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.commons.lang.StringUtils;

public class RelationshipQuery
extends IndirectQuery {
    protected ObjectId objectId;
    protected String relationshipName;
    protected boolean refreshing;
    protected transient EntityResolver metadataResolver;
    protected transient QueryMetadata metadata;
    protected transient ObjRelationship relationship;

    private RelationshipQuery() {
    }

    public RelationshipQuery(ObjectId objectID, String relationshipName) {
        this(objectID, relationshipName, true);
    }

    public RelationshipQuery(ObjectId objectID, String relationshipName, boolean refreshing) {
        if (objectID == null) {
            throw new CayenneRuntimeException("Null objectID");
        }
        this.objectId = objectID;
        this.relationshipName = relationshipName;
        this.refreshing = refreshing;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.updateMetadata(resolver);
        return this.metadata;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    protected Query createReplacementQuery(EntityResolver resolver) {
        if (this.objectId.isTemporary() && !this.objectId.isReplacementIdAttached()) {
            throw new CayenneRuntimeException("Can't build a query for relationship '" + this.relationshipName + "' for temporary id: " + this.objectId);
        }
        ObjRelationship relationship = this.getRelationship(resolver);
        Expression qualifier = ExpressionFactory.matchDbExp(relationship.getReverseDbRelationshipPath(), this.objectId);
        SelectQuery query = new SelectQuery((ObjEntity)relationship.getTargetEntity(), qualifier);
        query.setRefreshingObjects(this.refreshing);
        return query;
    }

    public ObjRelationship getRelationship(EntityResolver resolver) {
        this.updateMetadata(resolver);
        return this.relationship;
    }

    void updateMetadata(EntityResolver resolver) {
        if (this.metadataResolver != resolver) {
            if (this.objectId == null) {
                throw new CayenneRuntimeException("Can't resolve query - objectID is null.");
            }
            ObjEntity entity = resolver.lookupObjEntity(this.objectId.getEntityName());
            this.relationship = (ObjRelationship)entity.getRelationship(this.relationshipName);
            if (this.relationship == null) {
                throw new CayenneRuntimeException("No relationship named " + this.relationshipName + " found in entity " + entity.getName() + "; object id: " + this.objectId);
            }
            this.metadata = new DefaultQueryMetadata(){

                public boolean isRefreshingObjects() {
                    return RelationshipQuery.this.refreshing;
                }

                public ObjEntity getObjEntity() {
                    return (ObjEntity)RelationshipQuery.this.relationship.getTargetEntity();
                }
            };
            this.metadataResolver = resolver;
        }
    }

    public String toString() {
        return StringUtils.substringAfterLast(this.getClass().getName(), ".") + ":" + this.getRelationshipName();
    }
}

