/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.CollectionProperty;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyVisitor;
import org.apache.cayenne.property.SingleObjectArcProperty;
import org.apache.cayenne.query.PrefetchTreeNode;

public class ObjectDetachOperation {
    protected EntityResolver targetResolver;
    protected Map seen;

    public ObjectDetachOperation(EntityResolver targetResolver) {
        this.targetResolver = targetResolver;
        this.seen = new HashMap();
    }

    public void reset() {
        this.seen.clear();
    }

    public Object detach(Object object, ClassDescriptor descriptor, final PrefetchTreeNode prefetchTree) {
        if (!(object instanceof Persistent)) {
            throw new CayenneRuntimeException("Expected Persistent, got: " + object);
        }
        final Persistent source = (Persistent)object;
        ObjectId id = source.getObjectId();
        if (id == null) {
            throw new CayenneRuntimeException("Server returned an object without an id: " + source);
        }
        Object seenTarget = this.seen.get(id);
        if (seenTarget != null) {
            return seenTarget;
        }
        descriptor = descriptor.getSubclassDescriptor(source.getClass());
        final ClassDescriptor targetDescriptor = this.targetResolver.getClassDescriptor(id.getEntityName());
        final Persistent target = (Persistent)targetDescriptor.createObject();
        target.setObjectId(id);
        this.seen.put(id, target);
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                PrefetchTreeNode child;
                if (prefetchTree != null && (child = prefetchTree.getNode(property.getName())) != null) {
                    Object destinationSource = property.readProperty(source);
                    Object destinationTarget = destinationSource != null ? ObjectDetachOperation.this.detach(destinationSource, property.getTargetDescriptor(), child) : null;
                    SingleObjectArcProperty targetProperty = (SingleObjectArcProperty)targetDescriptor.getProperty(property.getName());
                    Object oldTarget = targetProperty.isFault(target) ? null : targetProperty.readProperty(target);
                    targetProperty.writeProperty(target, oldTarget, destinationTarget);
                }
                return true;
            }

            public boolean visitCollectionArc(CollectionProperty property) {
                PrefetchTreeNode child;
                if (prefetchTree != null && (child = prefetchTree.getNode(property.getName())) != null) {
                    Collection collection = (Collection)property.readProperty(source);
                    ArrayList<Object> targetCollection = new ArrayList<Object>(collection.size());
                    Iterator it = collection.iterator();
                    while (it.hasNext()) {
                        Object destinationSource = it.next();
                        Object destinationTarget = destinationSource != null ? ObjectDetachOperation.this.detach(destinationSource, property.getTargetDescriptor(), child) : null;
                        targetCollection.add(destinationTarget);
                    }
                    CollectionProperty targetProperty = (CollectionProperty)targetDescriptor.getProperty(property.getName());
                    targetProperty.writeProperty(target, null, targetCollection);
                }
                return true;
            }

            public boolean visitProperty(Property property) {
                Property targetProperty = targetDescriptor.getProperty(property.getName());
                targetProperty.writeProperty(target, null, property.readProperty(source));
                return true;
            }
        });
        return target;
    }
}

