/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NumberUtils;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.Digraph;
import org.objectstyle.ashwood.graph.GraphUtils;
import org.objectstyle.ashwood.graph.MapDigraph;
import org.objectstyle.ashwood.graph.layout.DigraphLayout;
import org.objectstyle.ashwood.util.Attribute;
import org.objectstyle.ashwood.util.MapAttribute;
import org.objectstyle.ashwood.util.MutableInteger;
import org.objectstyle.ashwood.util.Pair;

public class SugiyamaLayout
extends DigraphLayout {
    private double movePrecision = 1.0;
    private double stepSize = 1.0;
    private int adjustingPassCount = 2;
    private boolean rootsUpwards = true;
    private Map wrapperLevelMap;
    private Map vertexWrapperMap;
    private Map replacementMap = new HashMap();
    private VertexWrapper[][] levels = null;
    private Digraph wrapperDigraph;

    public void doLayout() {
        this.createWrapperDigraph();
        this.wrapperLevelMap = GraphUtils.computeLevels(new HashMap(this.wrapperDigraph.order()), this.wrapperDigraph, true);
        this.splitLongArcs();
        this.createLevels();
        this.minimizeArcIntersections();
        this.minimizeDistancesToBarycentres();
        this.computeGeometry();
    }

    private void createWrapperDigraph() {
        VertexWrapper vertexWrapper;
        Object object;
        this.wrapperDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        this.vertexWrapperMap = new HashMap(this.digraph.order());
        Iterator iterator = this.digraph.vertexIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            vertexWrapper = new VertexWrapper(object);
            this.vertexWrapperMap.put(object, vertexWrapper);
            this.wrapperDigraph.addVertex(vertexWrapper);
        }
        object = this.digraph.arcIterator();
        while (object.hasNext()) {
            object.next();
            vertexWrapper = this.vertexWrapperMap.get(object.getOrigin());
            Object v = this.vertexWrapperMap.get(object.getDestination());
            if (this.rootsUpwards) {
                this.wrapperDigraph.putArc(vertexWrapper, v, Boolean.TRUE);
                continue;
            }
            this.wrapperDigraph.putArc(v, vertexWrapper, Boolean.TRUE);
        }
    }

    private void splitLongArcs() {
        ArrayList<DummyWrapper> arrayList;
        Object object;
        Object object2;
        Object object3;
        ArcIterator arcIterator = this.wrapperDigraph.arcIterator();
        while (arcIterator.hasNext()) {
            arcIterator.next();
            object3 = arcIterator.getOrigin();
            object2 = arcIterator.getDestination();
            int n = this.wrapperLevelMap.get(object3).hashCode();
            int n2 = this.wrapperLevelMap.get(object2).hashCode();
            int n3 = n2 - n;
            if (n3 == 1) continue;
            object = new Pair(object3, object2);
            arrayList = new ArrayList(n3 - 1);
            int n4 = 1;
            while (n4 < n3) {
                DummyWrapper dummyWrapper = new DummyWrapper((Pair)object, n4);
                arrayList.add(dummyWrapper);
                this.wrapperLevelMap.put(dummyWrapper, new MutableInteger(n + n4));
                ++n4;
            }
            this.replacementMap.put(object, arrayList);
        }
        object3 = this.replacementMap.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            Pair pair = (Pair)object2.getKey();
            List list = (List)object2.getValue();
            this.wrapperDigraph.removeArc(pair.first, pair.second);
            ArrayList<DummyWrapper> arrayList2 = pair.first;
            object = list.iterator();
            while (object.hasNext()) {
                arrayList = object.next();
                this.wrapperDigraph.putArc(arrayList2, arrayList, Boolean.TRUE);
                arrayList2 = arrayList;
            }
            this.wrapperDigraph.putArc(arrayList2, pair.second, Boolean.TRUE);
        }
    }

    private void createLevels() {
        Object object;
        int n = 0;
        HashMap<Number, int[]> hashMap = new HashMap<Number, int[]>();
        Iterator iterator = this.wrapperLevelMap.values().iterator();
        while (iterator.hasNext()) {
            Number number = (Number)iterator.next();
            n = n >= number.intValue() ? n : number.intValue();
            object = (int[])hashMap.get(number);
            if (object == null) {
                hashMap.put(number, new int[]{1});
                continue;
            }
            object[0] = object[0] + 1;
        }
        this.levels = new VertexWrapper[n + 1][];
        int n2 = 0;
        while (n2 < this.levels.length) {
            int n3 = ((int[])hashMap.get(new MutableInteger(n2)))[0];
            this.levels[n2] = new VertexWrapper[n3];
            ++n2;
        }
        object = new int[this.levels.length][1];
        Iterator iterator2 = this.wrapperLevelMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            VertexWrapper vertexWrapper;
            Map.Entry entry = iterator2.next();
            int n4 = entry.getValue().hashCode();
            int n5 = object[n4];
            n5[0] = n5[0] + true;
            this.levels[n4][var9_11] = vertexWrapper = (VertexWrapper)entry.getKey();
        }
    }

    private void minimizeArcIntersections() {
        int n;
        int n2 = 0;
        while (n2 < this.levels.length - 1) {
            n = 0;
            while (n < this.levels[n2 + 1].length) {
                VertexWrapper vertexWrapper = this.levels[n2 + 1][n];
                double d = 0.0;
                double d2 = 0.0;
                int n3 = 0;
                while (n3 < this.levels[n2].length) {
                    VertexWrapper vertexWrapper2 = this.levels[n2][n3];
                    double d3 = this.wrapperDigraph.hasArc(vertexWrapper2, vertexWrapper) ? 1 : 0;
                    d += (double)n3 * d3;
                    d2 += d3;
                    ++n3;
                }
                vertexWrapper.setBarycenter(d / d2);
                ++n;
            }
            Arrays.sort(this.levels[n2 + 1]);
            ++n2;
        }
        n = this.levels.length - 1;
        while (n > 0) {
            int n4 = 0;
            while (n4 < this.levels[n - 1].length) {
                VertexWrapper vertexWrapper = this.levels[n - 1][n4];
                double d = 0.0;
                double d4 = 0.0;
                int n5 = 0;
                while (n5 < this.levels[n].length) {
                    VertexWrapper vertexWrapper3 = this.levels[n][n5];
                    double d5 = this.wrapperDigraph.hasArc(vertexWrapper, vertexWrapper3) ? 1 : 0;
                    d += (double)n5 * d5;
                    d4 += d5;
                    ++n5;
                }
                vertexWrapper.setBarycenter(d / d4);
                ++n4;
            }
            Arrays.sort(this.levels[n - 1]);
            --n;
        }
    }

    private void minimizeDistancesToBarycentres() {
        int n = 0;
        while (n < this.levels.length) {
            double d = this.areaBounds.getMinX() - this.horizontalSpacing;
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.levels[n].length) {
                VertexWrapper vertexWrapper = this.levels[n][n2];
                vertexWrapper.setCenterX(d + this.horizontalSpacing + (d2 + vertexWrapper.getWidth()) / 2.0);
                d = vertexWrapper.getCenterX();
                d2 = vertexWrapper.getWidth();
                vertexWrapper.setUpperConnectivity(this.wrapperDigraph.incomingSize(vertexWrapper));
                vertexWrapper.setLowerConnectivity(this.wrapperDigraph.outgoingSize(vertexWrapper));
                ++n2;
            }
            ++n;
        }
        int n3 = Math.min(this.adjustingPassCount, this.levels.length - 1);
        int n4 = 0;
        while (n4 < this.adjustingPassCount) {
            this.adjustMovingDown(n4 + 1);
            this.adjustMovingUp(this.levels.length - 2);
            ++n4;
        }
    }

    private void adjustMovingDown(int n) {
        int n2 = n;
        while (n2 < this.levels.length) {
            int n3 = 0;
            while (n3 < this.levels[n2].length) {
                double d;
                VertexWrapper vertexWrapper = this.levels[n2][n3];
                double d2 = 0.0;
                int n4 = 0;
                while (n4 < this.levels[n2 - 1].length) {
                    VertexWrapper vertexWrapper2 = this.levels[n2 - 1][n4];
                    if (this.wrapperDigraph.hasArc(vertexWrapper2, vertexWrapper)) {
                        d2 += vertexWrapper2.getCenterX();
                    }
                    ++n4;
                }
                vertexWrapper.setUpperBarycenter(d2 / (double)vertexWrapper.getUpperConnectivity());
                int n5 = vertexWrapper.getUpperConnectivity();
                if (vertexWrapper.isDummy()) {
                    n5 = 0;
                }
                double d3 = 0.0;
                while ((d3 = (d = vertexWrapper.getUpperBarycenter() - vertexWrapper.getCenterX()) > this.movePrecision ? this.adjustVertexWithinLevel(true, false, this.levels[n2], n3, n5, this.stepSize) : (d < -this.movePrecision ? this.adjustVertexWithinLevel(true, true, this.levels[n2], n3, n5, this.stepSize) : 0.0)) > this.movePrecision) {
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void adjustMovingUp(int n) {
        int n2 = n;
        while (n2 >= 0) {
            int n3 = 0;
            while (n3 < this.levels[n2].length) {
                double d;
                VertexWrapper vertexWrapper = this.levels[n2][n3];
                double d2 = 0.0;
                int n4 = 0;
                while (n4 < this.levels[n2 + 1].length) {
                    VertexWrapper vertexWrapper2 = this.levels[n2 + 1][n4];
                    if (this.wrapperDigraph.hasArc(vertexWrapper, vertexWrapper2)) {
                        d2 += vertexWrapper2.getCenterX();
                    }
                    ++n4;
                }
                vertexWrapper.setLowerBarycenter(d2 / (double)vertexWrapper.getLowerConnectivity());
                int n5 = vertexWrapper.getLowerConnectivity();
                if (vertexWrapper.isDummy()) {
                    n5 = 0;
                }
                double d3 = 0.0;
                while ((d3 = (d = vertexWrapper.getLowerBarycenter() - vertexWrapper.getCenterX()) > this.movePrecision ? this.adjustVertexWithinLevel(false, false, this.levels[n2], n3, n5, this.stepSize) : (d < -this.movePrecision ? this.adjustVertexWithinLevel(false, true, this.levels[n2], n3, n5, this.stepSize) : 0.0)) > this.movePrecision) {
                }
                ++n3;
            }
            --n2;
        }
    }

    private double adjustVertexWithinLevel(boolean bl, boolean bl2, VertexWrapper[] vertexWrapperArray, int n, int n2, double d) {
        int n3 = bl2 ? -1 : 1;
        VertexWrapper vertexWrapper = vertexWrapperArray[n];
        double d2 = vertexWrapper.getCenterX();
        double d3 = vertexWrapper.getWidth();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.areaBounds.getWidth();
        double d7 = this.areaBounds.getMinX();
        if (bl2 && n == 0) {
            d4 = d2 - (d7 + d3 / 2.0);
            d5 = Math.min(d, d4);
        } else if (!bl2 && n == vertexWrapperArray.length - 1) {
            d4 = d7 + d6 - (d2 + d3 / 2.0);
            d5 = Math.min(d, d4);
        } else {
            int n4;
            int n5 = n + n3;
            VertexWrapper vertexWrapper2 = vertexWrapperArray[n5];
            int n6 = n4 = bl ? vertexWrapper2.getUpperConnectivity() : vertexWrapper2.getLowerConnectivity();
            if (vertexWrapper2.isDummy()) {
                n2 = 0;
            }
            if (d <= (d4 = bl2 ? d2 - (vertexWrapper2.getCenterX() + this.horizontalSpacing + (vertexWrapper2.getWidth() + d3) / 2.0) : vertexWrapper2.getCenterX() - (d2 + this.horizontalSpacing + (vertexWrapper2.getWidth() + d3) / 2.0))) {
                d5 = d;
            } else if (n2 <= n4) {
                d5 = d4;
            } else {
                double d8 = d - d4;
                double d9 = this.adjustVertexWithinLevel(bl, bl2, vertexWrapperArray, n5, n2, d8);
                d5 = d4 + d9;
            }
        }
        vertexWrapper.setCenterX(d2 + (double)n3 * d5);
        return d5;
    }

    private void computeGeometry() {
        double d = this.areaBounds.getMinY();
        double d2 = this.areaBounds.getMinX();
        int n = 0;
        while (n < this.levels.length) {
            double d3 = d;
            VertexWrapper[] vertexWrapperArray = this.levels[n];
            int n2 = 0;
            while (n2 < vertexWrapperArray.length) {
                d3 = Math.max(d3, vertexWrapperArray[n2].setupVertexShape(d));
                ++n2;
            }
            double d4 = vertexWrapperArray[vertexWrapperArray.length - 1].getCenterX() + vertexWrapperArray[vertexWrapperArray.length - 1].getWidth() / 2.0;
            d = d3 + this.verticalSpacing;
            d2 = Math.max(d2, d4);
            ++n;
        }
        this.areaBounds.setFrame(this.areaBounds.getMinX(), this.areaBounds.getMinY(), d2 - this.areaBounds.getMinX(), d - this.verticalSpacing - this.areaBounds.getMinY());
    }

    private RectangularShape getVertexShape(Object object) {
        return (RectangularShape)this.vertexShape.get(object);
    }

    public List computeBentArcs() {
        ArrayList<Pair> arrayList = new ArrayList<Pair>(this.replacementMap.size());
        Iterator iterator = this.replacementMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Pair pair = (Pair)entry.getKey();
            Object object = ((VertexWrapper)pair.first).getVertex();
            Object object2 = ((VertexWrapper)pair.second).getVertex();
            Pair pair2 = this.rootsUpwards ? new Pair(object, object2) : new Pair(object2, object);
            List list = (List)entry.getValue();
            ArrayList<Point> arrayList2 = new ArrayList<Point>(list.size());
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                DummyWrapper dummyWrapper = (DummyWrapper)iterator2.next();
                arrayList2.add(dummyWrapper.getBendingPoint());
            }
            arrayList.add(new Pair(pair2, arrayList2));
        }
        return arrayList;
    }

    public void setMovePrecision(double d) {
        this.movePrecision = d;
    }

    public double getMovePrecision() {
        return this.movePrecision;
    }

    public void setStepSize(double d) {
        this.stepSize = d;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setAdjustingPassCount(int n) {
        this.adjustingPassCount = n;
    }

    public int getAdjustingPassCount() {
        return this.adjustingPassCount;
    }

    public void setRootsUpwards(boolean bl) {
        this.rootsUpwards = bl;
    }

    public boolean isRootsUpwards() {
        return this.rootsUpwards;
    }

    public static void main(String[] stringArray) {
        Object object;
        Digraph digraph = SugiyamaLayout.createDigraph4();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 20.0, 15.0);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, 500.0, 500.0);
        HashMap hashMap = new HashMap();
        Iterator iterator = digraph.vertexIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            hashMap.put(object, double_.clone());
        }
        object = new MapAttribute(hashMap);
        double d = 5.0;
        double d2 = 5.0;
        int n = 100;
        double d3 = 1.0;
        double d4 = 1.0;
        boolean bl = true;
        SugiyamaLayout sugiyamaLayout = new SugiyamaLayout();
        sugiyamaLayout.setDigraph(digraph);
        sugiyamaLayout.setVertexShape((Attribute)object);
        sugiyamaLayout.setAreaBounds(double_2);
        sugiyamaLayout.setAdjustingPassCount(n);
        sugiyamaLayout.setHorizontalSpacing(d);
        sugiyamaLayout.setVerticalSpacing(d2);
        sugiyamaLayout.setMovePrecision(d3);
        sugiyamaLayout.setStepSize(d4);
        sugiyamaLayout.setRootsUpwards(bl);
        sugiyamaLayout.doLayout();
        System.out.println("Results:");
        System.out.println("Area: " + sugiyamaLayout.getAreaBounds());
        System.out.println("Vertices:");
        Attribute attribute = sugiyamaLayout.getVertexShape();
        Iterator iterator2 = digraph.vertexIterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            System.out.println(e + ": " + attribute.get(e));
        }
        System.out.println("Bye-bye.");
    }

    private static Digraph createDigraph1() {
        MapDigraph mapDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        String[] stringArray = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J"};
        mapDigraph.addAllVertices(Arrays.asList(stringArray));
        mapDigraph.putArc("D", "A", Boolean.TRUE);
        mapDigraph.putArc("D", "B", Boolean.TRUE);
        mapDigraph.putArc("F", "B", Boolean.TRUE);
        mapDigraph.putArc("G", "C", Boolean.TRUE);
        mapDigraph.putArc("E", "D", Boolean.TRUE);
        mapDigraph.putArc("H", "F", Boolean.TRUE);
        mapDigraph.putArc("F", "G", Boolean.TRUE);
        mapDigraph.putArc("E", "H", Boolean.TRUE);
        mapDigraph.putArc("J", "E", Boolean.TRUE);
        mapDigraph.putArc("J", "H", Boolean.TRUE);
        mapDigraph.putArc("J", "G", Boolean.TRUE);
        return mapDigraph;
    }

    private static Digraph createDigraph2() {
        MapDigraph mapDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        String[] stringArray = new String[]{"A", "B", "C", "D", "E", "F"};
        mapDigraph.addAllVertices(Arrays.asList(stringArray));
        mapDigraph.putArc("A", "B", Boolean.TRUE);
        mapDigraph.putArc("A", "F", Boolean.TRUE);
        mapDigraph.putArc("B", "C", Boolean.TRUE);
        mapDigraph.putArc("F", "D", Boolean.TRUE);
        mapDigraph.putArc("C", "D", Boolean.TRUE);
        mapDigraph.putArc("E", "D", Boolean.TRUE);
        return mapDigraph;
    }

    private static Digraph createDigraph3() {
        MapDigraph mapDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        String[] stringArray = new String[]{"A", "B", "C", "D", "E", "F"};
        mapDigraph.addAllVertices(Arrays.asList(stringArray));
        mapDigraph.putArc("A", "B", Boolean.TRUE);
        mapDigraph.putArc("A", "E", Boolean.TRUE);
        mapDigraph.putArc("B", "F", Boolean.TRUE);
        mapDigraph.putArc("C", "E", Boolean.TRUE);
        mapDigraph.putArc("C", "D", Boolean.TRUE);
        mapDigraph.putArc("E", "D", Boolean.TRUE);
        mapDigraph.putArc("E", "B", Boolean.TRUE);
        mapDigraph.putArc("D", "F", Boolean.TRUE);
        return mapDigraph;
    }

    private static Digraph createDigraph4() {
        MapDigraph mapDigraph = new MapDigraph(MapDigraph.HASHMAP_FACTORY);
        String[] stringArray = new String[]{"A", "B", "C", "D", "E"};
        mapDigraph.addAllVertices(Arrays.asList(stringArray));
        mapDigraph.putArc("A", "B", Boolean.TRUE);
        mapDigraph.putArc("A", "C", Boolean.TRUE);
        mapDigraph.putArc("B", "D", Boolean.TRUE);
        mapDigraph.putArc("C", "E", Boolean.TRUE);
        return mapDigraph;
    }

    private class DummyWrapper
    extends VertexWrapper {
        private Pair splitArc;
        private int index;
        private Point bendingPoint;

        private DummyWrapper(Pair pair, int n) {
            super(null);
            this.splitArc = pair;
            this.index = n;
        }

        boolean isDummy() {
            return true;
        }

        double setupVertexShape(double d) {
            this.bendingPoint = new Point((int)this.getCenterX(), (int)d);
            return d;
        }

        Point getBendingPoint() {
            return this.bendingPoint;
        }
    }

    private class VertexWrapper
    implements Comparable {
        private Object vertex;
        private double barycenter;
        private double upperBarycenter;
        private double lowerBarycenter;
        private int upperConnectivity;
        private int lowerConnectivity;
        private double centerX;
        private double width = 0.0;

        private VertexWrapper(Object object) {
            this.vertex = object;
            if (object != null) {
                RectangularShape rectangularShape = SugiyamaLayout.this.getVertexShape(object);
                this.width = rectangularShape != null ? rectangularShape.getWidth() : 0.0;
            }
        }

        void setBarycenter(double d) {
            this.barycenter = d;
        }

        void setUpperConnectivity(int n) {
            this.upperConnectivity = n;
        }

        int getUpperConnectivity() {
            return this.upperConnectivity;
        }

        void setLowerConnectivity(int n) {
            this.lowerConnectivity = n;
        }

        int getLowerConnectivity() {
            return this.lowerConnectivity;
        }

        void setUpperBarycenter(double d) {
            this.upperBarycenter = d;
        }

        double getUpperBarycenter() {
            return this.upperBarycenter;
        }

        void setLowerBarycenter(double d) {
            this.lowerBarycenter = d;
        }

        double getLowerBarycenter() {
            return this.lowerBarycenter;
        }

        void setCenterX(double d) {
            this.centerX = d;
        }

        double getCenterX() {
            return this.centerX;
        }

        void setWidth(double d) {
            this.width = d;
        }

        double getWidth() {
            return this.width;
        }

        Object getVertex() {
            return this.vertex;
        }

        boolean isDummy() {
            return false;
        }

        public int compareTo(Object object) {
            return NumberUtils.compare(this.barycenter, ((VertexWrapper)object).barycenter);
        }

        double setupVertexShape(double d) {
            if (this.vertex == null) {
                return d;
            }
            RectangularShape rectangularShape = SugiyamaLayout.this.getVertexShape(this.vertex);
            double d2 = rectangularShape.getHeight();
            rectangularShape.setFrame(this.centerX - this.width / 2.0, d, this.width, d2);
            return d + d2;
        }
    }
}

