/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALIllegalDateException;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTProject;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTask;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskFile;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskMember;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.project.ProjectResultData;
import com.aimluck.eip.project.ProjectTaskMemberResultData;
import com.aimluck.eip.project.util.ProjectFile;
import com.aimluck.eip.project.util.ProjectFormUtils;
import com.aimluck.eip.project.util.ProjectUtils;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ProjectTaskFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectTaskFormData.class.getName());
    private ALStringField tracker;
    private ALStringField task_name;
    private ALStringField explanation;
    private ALStringField status;
    private ALStringField priority;
    private ALDateField start_plan_date;
    private ALDateField end_plan_date;
    private ALDateField start_date;
    private ALDateField end_date;
    private ALStringField start_plan_date_check;
    private ALStringField end_plan_date_check;
    private ALStringField start_date_check;
    private ALStringField end_date_check;
    private BigDecimal plan_workload;
    private String planWorkloadString;
    private final DecimalFormat df = new DecimalFormat("#.0##");
    private ALNumberField progress_rate;
    private Integer projectId;
    private Integer taskId;
    private EipTProject project;
    private ALEipUser loginUser;
    private Integer parentTaskId;
    private boolean hasChildren;
    private List<ProjectTaskMemberResultData> taskMembers;
    private List<ALEipUser> projectMembers;
    private List<FileuploadBean> fileuploadList;
    private String folderName;
    private List<ProjectResultData> allProject;
    private int uid;
    private final ProjectFile<EipTProjectTaskFile, EipTProjectTask> pfile = new ProjectFile(EipTProjectTaskFile.class);

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        rundata.getUser().setTemp("mygroup", null);
        try {
            this.parentTaskId = Integer.valueOf(rundata.getParameters().getString("parent_task_id"));
        }
        catch (NumberFormatException e) {
            this.parentTaskId = null;
        }
        String _projectId = ALEipUtils.getParameter((RunData)rundata, (Context)context, (String)"projectid");
        this.projectId = StringUtils.isNotEmpty((String)_projectId) && StringUtils.isNumeric((String)_projectId) ? Integer.valueOf(_projectId) : Integer.valueOf(0);
        this.project = ProjectUtils.getEipTProject(this.projectId);
        this.loginUser = ALEipUtils.getALEipUser((RunData)rundata);
        this.folderName = rundata.getParameters().getString("folderName");
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.projectMembers = ProjectUtils.getProjectMembers(this.projectId);
        this.allProject = ProjectUtils.getAllProject();
        try {
            this.taskId = Integer.valueOf(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
        }
        catch (NumberFormatException e) {
            this.taskId = null;
        }
        this.hasChildren = ProjectUtils.getCountChildrenTask(this.taskId) > 0;
    }

    public void initField() {
        this.tracker = new ALStringField();
        this.tracker.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_CATEGORY"));
        this.tracker.setNotNull(true);
        this.task_name = new ALStringField();
        this.task_name.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_TASK_NAME"));
        this.task_name.setTrim(true);
        this.task_name.setNotNull(true);
        this.explanation = new ALStringField();
        this.explanation.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_EXPLANATION"));
        this.explanation.setTrim(true);
        this.status = new ALStringField();
        this.status.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_STATUS"));
        this.status.setNotNull(true);
        this.priority = new ALStringField();
        this.priority.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_PRIORITY"));
        this.priority.setNotNull(true);
        this.start_plan_date = new ALDateField();
        this.start_plan_date.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_START_PLAN_DATE"));
        this.start_plan_date.setValue(new Date());
        this.end_plan_date = new ALDateField();
        this.end_plan_date.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_END_PLAN_DATE"));
        this.end_plan_date.setValue(new Date());
        this.start_date = new ALDateField();
        this.start_date.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_START_DATE"));
        this.start_date.setValue(new Date());
        this.end_date = new ALDateField();
        this.end_date.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_END_DATE"));
        this.end_date.setValue(new Date());
        this.start_plan_date_check = new ALStringField();
        this.start_plan_date_check.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_NOT_SPECIFIED"));
        this.end_plan_date_check = new ALStringField();
        this.end_plan_date_check.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_NOT_SPECIFIED"));
        this.start_date_check = new ALStringField();
        this.start_date_check.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_NOT_SPECIFIED"));
        this.end_date_check = new ALStringField();
        this.end_date_check.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_NOT_SPECIFIED"));
        this.plan_workload = null;
        this.planWorkloadString = null;
        this.progress_rate = new ALNumberField();
        this.progress_rate.setFieldName(ALLocalizationUtils.getl10n((String)"PROJECT_PROGRESS_RATE"));
        this.progress_rate.setValue(0L);
        this.progress_rate.limitMinValue(0L);
        this.progress_rate.limitMaxValue(100L);
        this.hasChildren = false;
        this.taskMembers = new ArrayList<ProjectTaskMemberResultData>();
        this.projectMembers = new ArrayList<ALEipUser>();
        this.allProject = new ArrayList<ProjectResultData>();
        this.fileuploadList = new ArrayList<FileuploadBean>();
    }

    protected void setValidator() {
        this.task_name.setNotNull(true);
        this.task_name.limitMaxLength(50);
        this.progress_rate.limitMaxValue(100L);
        this.progress_rate.limitMinValue(0L);
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res;
        block14: {
            res = super.setFormData(rundata, context, msgList);
            try {
                if (!res) break block14;
                String[] members = rundata.getParameters().getStrings("task_member");
                String[] workload = rundata.getParameters().getStrings("workload");
                if (members != null) {
                    for (int i = 0; i < members.length; ++i) {
                        if (members[i] == null || members[i].length() == 0) continue;
                        ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(members[i]));
                        BigDecimal w = BigDecimal.valueOf(0L);
                        try {
                            if (workload[i] != null && workload[i].length() > 0) {
                                w = new BigDecimal(workload[i]);
                            }
                            if (w.compareTo(BigDecimal.valueOf(0L)) < 0) {
                                msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_WORKLOAD"));
                            } else if (w.precision() - w.scale() > 5) {
                                msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_WORKLOAD_RATIONAL_INTEGER"));
                            } else if (w.scale() > 3) {
                                msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_WORKLOAD_DECIMAL"));
                            }
                        }
                        catch (Exception e) {
                            msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_WORKLOAD_INTEGER"));
                        }
                        ProjectTaskMemberResultData member = new ProjectTaskMemberResultData();
                        member.initField();
                        member.setUserId(user.getUserId().getValue());
                        member.setUserName(user.getAliasName().getValue());
                        member.setWorkload(w);
                        this.taskMembers.add(member);
                    }
                }
                this.planWorkloadString = rundata.getParameters().getString("plan_workload");
                this.fileuploadList = this.pfile.getFileuploadList(rundata);
                if ("new_form".equals(this.getMode())) {
                    String nullStr = null;
                    this.start_date_check.setValue("TRUE");
                    this.start_date.setValue(nullStr);
                    this.end_date_check.setValue("TRUE");
                    this.end_date.setValue(nullStr);
                }
            }
            catch (RuntimeException ex) {
                logger.error((Object)"RuntimeException", (Throwable)ex);
                res = false;
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
                res = false;
            }
        }
        return res;
    }

    protected boolean validate(List<String> msgList) {
        this.tracker.validate(msgList);
        this.task_name.validate(msgList);
        this.status.validate(msgList);
        this.priority.validate(msgList);
        this.progress_rate.validate(msgList);
        if (!this.hasChildren) {
            Calendar end;
            Calendar start;
            if (!this.taskMembers.isEmpty()) {
                ArrayList<Long> checkMemberId = new ArrayList<Long>();
                for (ProjectTaskMemberResultData data : this.taskMembers) {
                    long id = data.getUserId().getValue();
                    if (checkMemberId.contains(id)) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_TASKMEMBER_DUPLICATE"));
                        break;
                    }
                    checkMemberId.add(id);
                }
            }
            try {
                if (this.start_plan_date.getYear().length() > 0 && this.end_plan_date.getYear().length() > 0 && !ProjectUtils.isEmptyDate(this.start_plan_date.getValue().getDate()) && !ProjectUtils.isEmptyDate(this.end_plan_date.getValue().getDate())) {
                    start = Calendar.getInstance();
                    end = Calendar.getInstance();
                    start.setTime(this.start_plan_date.getValue().getDate());
                    end.setTime(this.end_plan_date.getValue().getDate());
                    if (start.compareTo(end) > 0) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_PLAN_START_DATE"));
                    }
                }
            }
            catch (NumberFormatException e1) {
                logger.error((Object)"ProjectTaskFormData.validate", (Throwable)e1);
            }
            catch (ALIllegalDateException e1) {
                logger.error((Object)"ProjectTaskFormData.validate", (Throwable)e1);
            }
            try {
                if (this.start_date.getYear().length() > 0 && this.end_date.getYear().length() > 0 && !ProjectUtils.isEmptyDate(this.start_date.getValue().getDate()) && !ProjectUtils.isEmptyDate(this.end_date.getValue().getDate())) {
                    start = Calendar.getInstance();
                    end = Calendar.getInstance();
                    start.setTime(this.start_date.getValue().getDate());
                    end.setTime(this.end_date.getValue().getDate());
                    if (start.compareTo(end) > 0) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_START_DATE"));
                    }
                }
            }
            catch (NumberFormatException e1) {
                logger.error((Object)"ProjectTaskFormData.validate", (Throwable)e1);
            }
            catch (ALIllegalDateException e1) {
                logger.error((Object)"ProjectTaskFormData.validate", (Throwable)e1);
            }
            try {
                this.plan_workload = this.planWorkloadString.equals("") ? new BigDecimal(0) : new BigDecimal(this.planWorkloadString);
                if (this.plan_workload.compareTo(BigDecimal.valueOf(0L)) < 0) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_PLAN_WORKLOAD"));
                } else if (this.plan_workload.precision() - this.plan_workload.scale() > 5) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_PLAN_WORKLOAD_RATIONAL_INTEGER"));
                } else if (this.plan_workload.scale() > 3) {
                    msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_PLAN_WORKLOAD_DECIMAL"));
                }
            }
            catch (Exception e) {
                msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_PLAN_WORKLOAD_INTEGER"));
            }
        }
        boolean isProjectMember = false;
        if (!this.taskMembers.isEmpty()) {
            block9: for (ProjectTaskMemberResultData data : this.taskMembers) {
                for (ALEipUser user : this.projectMembers) {
                    if (!data.getUserId().toString().equals(user.getUserId().toString())) continue;
                    isProjectMember = true;
                    continue block9;
                }
            }
        } else {
            isProjectMember = true;
        }
        if (!isProjectMember) {
            msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_TASKMEMBER_NOT_EXIST"));
        }
        return msgList.isEmpty();
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTProjectTask task = ProjectUtils.getEipTProjectTask(rundata, context);
            if (task == null) {
                return false;
            }
            this.tracker.setValue(task.getTracker());
            this.task_name.setValue(task.getTaskName());
            this.explanation.setValue(task.getExplanation());
            this.status.setValue(task.getStatus());
            this.priority.setValue(task.getPriority());
            String nullStr = null;
            if (ProjectUtils.isEmptyDate(task.getStartPlanDate())) {
                this.start_plan_date_check.setValue("TRUE");
                this.start_plan_date.setValue(nullStr);
            } else {
                this.start_plan_date.setValue(task.getStartPlanDate());
            }
            if (ProjectUtils.isEmptyDate(task.getEndPlanDate())) {
                this.end_plan_date_check.setValue("TRUE");
                this.end_plan_date.setValue(nullStr);
            } else {
                this.end_plan_date.setValue(task.getEndPlanDate());
            }
            if (ProjectUtils.isEmptyDate(task.getStartDate())) {
                this.start_date_check.setValue("TRUE");
                this.start_date.setValue(nullStr);
            } else {
                this.start_date_check.setValue("FALSE");
                this.start_date.setValue(task.getStartDate());
            }
            if (ProjectUtils.isEmptyDate(task.getEndDate())) {
                this.end_date_check.setValue("TRUE");
                this.end_date.setValue(nullStr);
            } else {
                this.end_date_check.setValue("FALSE");
                this.end_date.setValue(task.getEndDate());
            }
            this.plan_workload = new BigDecimal(this.df.format(task.getPlanWorkload()));
            this.progress_rate.setValue((long)task.getProgressRate().intValue());
            this.taskMembers = ProjectUtils.getProjectTaskMembers(String.valueOf(task.getTaskId()));
            List files = this.pfile.getSelectQueryForFiles("TASK_ID", task.getTaskId()).fetchList();
            this.fileuploadList = this.pfile.getFileList(files);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.loginUser.getUserId().getValueWithInt());
            EipTProjectTask task = (EipTProjectTask)Database.create(EipTProjectTask.class);
            this.setInsertUpdate(task);
            task.setTurbineUser(tuser);
            task.setCreateDate(Calendar.getInstance().getTime());
            if (this.parentTaskId != null) {
                task.setParentTaskId(Integer.valueOf(this.parentTaskId));
            }
            int orderNo = 1;
            SelectQuery query = Database.query(EipTProjectTask.class);
            query.andQualifier(ExpressionFactory.matchExp((String)"parentTaskId", (Object)this.parentTaskId));
            query.orderDesending("orderNo");
            EipTProjectTask parentTask = (EipTProjectTask)query.fetchSingle();
            if (parentTask != null) {
                orderNo = parentTask.getOrderNo() + 1;
            }
            task.setOrderNo(Integer.valueOf(orderNo));
            ArrayList<ProjectTaskMemberResultData> mailUserList = new ArrayList<ProjectTaskMemberResultData>();
            for (int i = 0; i < this.taskMembers.size(); ++i) {
                ProjectTaskMemberResultData member = this.taskMembers.get(i);
                EipTProjectTaskMember data = new EipTProjectTaskMember();
                data.setEipTProjectTask(task);
                data.setUserId(Integer.valueOf((int)member.getUserId().getValue()));
                data.setWorkload(member.getWorkload());
                if (tuser.getUserId().equals(member.getUserId().getValueWithInt())) continue;
                mailUserList.add(member);
            }
            if (mailUserList.size() > 0) {
                ProjectUtils.sendMailForTaskMembers(rundata, context, task, this.project, mailUserList);
            }
            this.pfile.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, task, msgList);
            Database.commit();
            ProjectFormUtils.updateProject(this.project.getProjectId(), this.loginUser.getUserId().getValueWithInt());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(task.getTaskId().intValue(), 370, ALLocalizationUtils.getl10nFormat((String)"PROJECT_EVENTLOG_TASK_ADD", (Object[])new Object[]{task.getTaskName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean setInsertUpdate(EipTProjectTask task) {
        task.setEipTProject(this.project);
        task.setTracker(this.tracker.getValue());
        task.setTaskName(this.task_name.getValue());
        task.setExplanation(this.explanation.getValue());
        task.setStatus(this.status.getValue());
        task.setPriority(this.priority.getValue());
        if (!this.hasChildren) {
            task.setStartPlanDate(this.getInputDate(this.start_plan_date_check, this.start_plan_date));
            task.setEndPlanDate(this.getInputDate(this.end_plan_date_check, this.end_plan_date));
            task.setStartDate(this.getInputDate(this.start_date_check, this.start_date));
            task.setEndDate(this.getInputDate(this.end_date_check, this.end_date));
            task.setPlanWorkload(this.plan_workload);
            task.setProgressRate(Integer.valueOf((int)this.progress_rate.getValue()));
        }
        task.setUpdateUserId(Integer.valueOf(this.loginUser.getUserId().getValueWithInt()));
        task.setUpdateDate(Calendar.getInstance().getTime());
        return true;
    }

    private Date getInputDate(ALStringField check, ALDateField date) {
        try {
            if (check.getValue() == null) {
                return date.getValue().getDate();
            }
            return ProjectUtils.getEmptyDate();
        }
        catch (Exception e) {
            return ProjectUtils.getEmptyDate();
        }
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTProjectTask task = ProjectUtils.getEipTProjectTask(rundata, context);
            if (task == null) {
                return false;
            }
            this.setInsertUpdate(task);
            if (!this.hasChildren) {
                ProjectUtils.removeProjectTaskMember(task);
                ArrayList<ProjectTaskMemberResultData> mailUserList = new ArrayList<ProjectTaskMemberResultData>();
                List<ProjectTaskMemberResultData> oldMenber = ProjectUtils.getProjectTaskMembers(task.getTaskId().toString());
                ArrayList<Integer> oldMemberIdList = new ArrayList<Integer>();
                for (ProjectTaskMemberResultData rd : oldMenber) {
                    oldMemberIdList.add(rd.getUserId().getValueWithInt());
                }
                TurbineUser tuser = (TurbineUser)Database.get(TurbineUser.class, (Object)this.loginUser.getUserId().getValueWithInt());
                for (int i = 0; i < this.taskMembers.size(); ++i) {
                    ProjectTaskMemberResultData member = this.taskMembers.get(i);
                    EipTProjectTaskMember data = (EipTProjectTaskMember)Database.create(EipTProjectTaskMember.class);
                    data.setEipTProjectTask(task);
                    data.setUserId(Integer.valueOf((int)member.getUserId().getValue()));
                    data.setWorkload(member.getWorkload());
                    if (oldMemberIdList.contains(member.getUserId().getValueWithInt()) || tuser.getUserId().equals(member.getUserId().getValueWithInt())) continue;
                    mailUserList.add(member);
                }
                if (mailUserList.size() > 0) {
                    ProjectUtils.sendMailForTaskMembers(rundata, context, task, this.project, mailUserList);
                }
            }
            List<Integer> attIdList = this.pfile.getRequestedHasFileIdList(this.fileuploadList);
            List files = this.pfile.getSelectQueryForFiles("TASK_ID", task.getTaskId()).fetchList();
            if (files != null) {
                for (int i = 0; i < files.size(); ++i) {
                    EipTProjectTaskFile file = (EipTProjectTaskFile)files.get(i);
                    if (attIdList.contains(file.getFileId())) continue;
                    ALStorageService.deleteFile((String)(ProjectFile.getSaveDirPath(this.uid) + file.getFilePath()));
                    Database.delete((Persistent)file);
                }
            }
            this.pfile.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, task, msgList);
            Database.commit();
            ProjectFormUtils.updateProject(this.project.getProjectId(), this.loginUser.getUserId().getValueWithInt());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(task.getTaskId().intValue(), 370, ALLocalizationUtils.getl10nFormat((String)"PROJECT_EVENTLOG_TASK_UPDATE", (Object[])new Object[]{task.getTaskName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTProjectTask task = ProjectUtils.getEipTProjectTask(rundata, context);
            if (task == null) {
                return false;
            }
            if (this.hasChildren) {
                msgList.add(ALLocalizationUtils.getl10n((String)"PROJECT_VALIDATE_HAS_CHILD"));
                return false;
            }
            ProjectUtils.removeProjectTaskMember(task);
            ProjectUtils.removeProjectTaskComment(rundata, task);
            this.pfile.removeFile(rundata, "eipTProjectTask", task.getTaskId());
            Database.delete((Persistent)task);
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(task.getTaskId().intValue(), 370, ALLocalizationUtils.getl10nFormat((String)"PROJECT_EVENTLOG_TASK_DELETE", (Object[])new Object[]{task.getTaskName()}));
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getTracker() {
        return this.tracker;
    }

    public ALStringField getTaskName() {
        return this.task_name;
    }

    public ALStringField getExplanation() {
        return this.explanation;
    }

    public ALStringField getStatus() {
        return this.status;
    }

    public ALStringField getPriority() {
        return this.priority;
    }

    public ALDateField getStartPlanDate() {
        return this.start_plan_date;
    }

    public ALDateField getEndPlanDate() {
        return this.end_plan_date;
    }

    public ALDateField getStartDate() {
        return this.start_date;
    }

    public ALDateField getEndDate() {
        return this.end_date;
    }

    public String getStartPlanDateString() {
        try {
            return ALDateUtil.format((Date)this.start_plan_date.getValue().getDate(), (String)"yyyy\u5e74M\u6708d\u65e5\uff08E\uff09");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEndPlanDateString() {
        try {
            return ALDateUtil.format((Date)this.end_plan_date.getValue().getDate(), (String)"yyyy\u5e74M\u6708d\u65e5\uff08E\uff09");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getStartDateString() {
        try {
            return ALDateUtil.format((Date)this.start_date.getValue().getDate(), (String)"yyyy\u5e74M\u6708d\u65e5\uff08E\uff09");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getEndDateString() {
        try {
            return ALDateUtil.format((Date)this.end_date.getValue().getDate(), (String)"yyyy\u5e74M\u6708d\u65e5\uff08E\uff09");
        }
        catch (Exception e) {
            return "";
        }
    }

    public ALStringField getStartPlanDateCheck() {
        return this.start_plan_date_check;
    }

    public ALStringField getEndPlanDateCheck() {
        return this.end_plan_date_check;
    }

    public ALStringField getStartDateCheck() {
        return this.start_date_check;
    }

    public ALStringField getEndDateCheck() {
        return this.end_date_check;
    }

    public BigDecimal getPlanWorkload() {
        return this.plan_workload;
    }

    public String getPlanWorkloadString() {
        if (this.plan_workload == null) {
            return "";
        }
        return this.plan_workload.toString();
    }

    public ALNumberField getProgressRate() {
        return this.progress_rate;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public int getLoginUserId() {
        return this.loginUser.getUserId().getValueWithInt();
    }

    public Integer getParentTaskId() {
        return this.parentTaskId;
    }

    public boolean getHasChildren() {
        return this.hasChildren;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public Map<String, String> getTrackerMap() {
        return ProjectUtils.getKubunMap("tracker");
    }

    public Map<String, String> getStatusMap() {
        return ProjectUtils.getKubunMap("status");
    }

    public Map<String, String> getPriorityMap() {
        return ProjectUtils.getKubunMap("priority");
    }

    public List<ProjectTaskMemberResultData> getTaskMembers() {
        return this.taskMembers;
    }

    public List<ALEipUser> getProjectMembers() {
        return this.projectMembers;
    }

    public List<FileuploadBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public List<ProjectResultData> getAllProject() {
        return this.allProject;
    }

    public boolean isProjectExists() {
        return this.allProject != null && this.allProject.size() > 0;
    }
}

