/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.project;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTask;
import com.aimluck.eip.cayenne.om.portlet.EipTProjectTaskFile;
import com.aimluck.eip.common.ALAbstractMultiFilterSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipHolidaysManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.project.ProjectResultData;
import com.aimluck.eip.project.ProjectTaskMemberResultData;
import com.aimluck.eip.project.ProjectTaskResultData;
import com.aimluck.eip.project.util.ProjectFile;
import com.aimluck.eip.project.util.ProjectFormUtils;
import com.aimluck.eip.project.util.ProjectUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.DataRow;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ProjectTaskSelectData
extends ALAbstractMultiFilterSelectData<EipTProjectTask, EipTProjectTask>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ProjectTaskSelectData.class.getName());
    private int taskCount;
    private List<ProjectResultData> allProject;
    private Integer selectedProjectId;
    private final ProjectFile<EipTProjectTaskFile, EipTProjectTask> pfile = new ProjectFile(EipTProjectTaskFile.class);
    private List<ALEipUser> projectMembers;
    private ALDateTimeField base_date_from;
    private ALDateTimeField base_date_to;
    private String target_keyword;
    private String target_user_id;
    private String target_tracker;
    private String target_priority;
    private String target_status;
    private String target_progress_rate_from;
    private String target_progress_rate_to;
    private String target_delay;
    private String progress_line_checked;
    private int viewDateMaxYear;
    private boolean indentFlg = true;
    private Calendar calFrom;
    private Calendar calTo;
    private boolean isAndroid2;
    private Integer loginUserId;
    private boolean isFileUploadable;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String resetCondition = rundata.getParameters().get("reset_condition");
        if (resetCondition != null && resetCondition.length() > 0) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_keyword", (String)"");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"");
        }
        this.allProject = ProjectUtils.getAllProject();
        this.setProject(rundata, context);
        super.init(action, rundata, context);
        Calendar cal = Calendar.getInstance();
        this.viewDateMaxYear = cal.get(1) + 10;
        this.projectMembers = 0 != this.selectedProjectId ? ProjectUtils.getProjectMembers(this.selectedProjectId) : ALEipUtils.getUsers((String)"LoginUser");
        this.calFrom = ProjectUtils.getViewCalendar(rundata, context, "base_date_from");
        this.calTo = ProjectUtils.getViewCalendar(rundata, context, "base_date_to");
        this.calFrom.set(5, 1);
        this.calTo.set(5, this.calTo.getActualMaximum(5));
        this.base_date_from = new ALDateTimeField();
        this.base_date_to = new ALDateTimeField();
        this.base_date_from.setValue(this.calFrom.getTime());
        this.base_date_to.setValue(this.calTo.getTime());
        this.progress_line_checked = ProjectUtils.getParameter(rundata, context, "progress_line_checked");
        this.isAndroid2 = ALEipUtils.isAndroid2Browser((RunData)rundata);
        this.loginUserId = ALEipUtils.getUserId((RunData)rundata);
        this.isFileUploadable = ALEipUtils.isFileUploadable((RunData)rundata);
    }

    protected ResultList<EipTProjectTask> selectList(RunData rundata, Context context) {
        if (null == this.selectedProjectId) {
            return null;
        }
        this.setSessionParams(rundata, context);
        SQLTemplate sqltemp = null;
        SQLTemplate sqlCountTemp = null;
        sqltemp = Database.sql(EipTProjectTask.class, (String)this.getFetchQuery(rundata, context));
        sqlCountTemp = Database.sql(EipTProjectTask.class, (String)this.getCountQuery(rundata, context));
        this.setPostgresParams((SQLTemplate<EipTProjectTask>)sqltemp, (SQLTemplate<EipTProjectTask>)sqlCountTemp);
        ResultList list = new ResultList();
        List result = sqltemp.fetchListAsDataRow();
        for (int i = 0; i < result.size(); ++i) {
            DataRow row = (DataRow)result.get(i);
            Object parentTaskId = row.get((Object)"parent_task_id");
            Object explanation = row.get((Object)"explanation");
            Object startPlanDate = row.get((Object)"start_plan_date");
            Object endPlanDate = row.get((Object)"end_plan_date");
            Object startDate = row.get((Object)"start_date");
            Object endDate = row.get((Object)"end_date");
            Object updateDate = row.get((Object)"update_date");
            EipTProjectTask task = new EipTProjectTask();
            task.setTaskId(row.get((Object)"task_id").toString());
            task.setTaskName(row.get((Object)"task_name").toString());
            if (parentTaskId != null) {
                task.setParentTaskId(Integer.valueOf(parentTaskId.toString()));
            }
            task.setProjectId(Integer.valueOf(row.get((Object)"project_id").toString()));
            task.setTracker(row.get((Object)"tracker").toString());
            if (explanation != null) {
                task.setExplanation(explanation.toString());
            }
            task.setStatus(row.get((Object)"status").toString());
            task.setPriority(row.get((Object)"priority").toString());
            if (startPlanDate == null) {
                task.setStartPlanDate(ProjectUtils.getEmptyDate());
            } else {
                task.setStartPlanDate((Date)startPlanDate);
            }
            if (endPlanDate == null) {
                task.setEndPlanDate(ProjectUtils.getEmptyDate());
            } else {
                task.setEndPlanDate((Date)endPlanDate);
            }
            if (startDate == null) {
                task.setStartDate(ProjectUtils.getEmptyDate());
            } else {
                task.setStartDate((Date)startDate);
            }
            if (endDate == null) {
                task.setEndDate(ProjectUtils.getEmptyDate());
            } else {
                task.setEndDate((Date)endDate);
            }
            task.setPlanWorkload(new BigDecimal(row.get((Object)"plan_workload").toString()));
            task.setProgressRate(Integer.valueOf(row.get((Object)"progress_rate").toString()));
            task.setUpdateDate((Date)updateDate);
            task.setIndent(Integer.valueOf(row.get((Object)"indent").toString()).intValue());
            list.add((Object)task);
        }
        int count = 0;
        List countResult = sqlCountTemp.fetchListAsDataRow();
        for (DataRow row : countResult) {
            Long tmp = (Long)row.get((Object)"count");
            count = tmp != null ? tmp.intValue() : 0;
        }
        this.setPageParam(count);
        this.taskCount = count;
        if (!this.getWhereList().isEmpty()) {
            this.indentFlg = false;
        }
        return list;
    }

    private void setSessionParams(RunData rundata, Context context) {
        this.target_keyword = ProjectUtils.getParameter(rundata, context, "target_keyword");
        this.target_user_id = ProjectUtils.getParameter(rundata, context, "target_user_id");
        this.target_tracker = ProjectUtils.getParameter(rundata, context, "target_tracker");
        this.target_priority = ProjectUtils.getParameter(rundata, context, "target_priority");
        this.target_status = ProjectUtils.getParameter(rundata, context, "target_status");
        this.target_progress_rate_from = ProjectUtils.getParameter(rundata, context, "target_progress_rate_from");
        this.target_progress_rate_to = ProjectUtils.getParameter(rundata, context, "target_progress_rate_to");
        this.target_delay = ProjectUtils.getParameter(rundata, context, "target_delay");
        if (this.isRejectParameter(this.target_user_id)) {
            this.target_user_id = "0";
        }
        if (this.isRejectParameter(this.target_tracker)) {
            this.target_tracker = "0";
        }
        if (this.isRejectParameter(this.target_priority)) {
            this.target_priority = "0";
        }
        if (this.isRejectParameter(this.target_status)) {
            this.target_status = "0";
        }
        if (this.isRejectParameter(this.target_progress_rate_from)) {
            this.target_progress_rate_from = "0";
        }
        if (this.isRejectParameter(this.target_progress_rate_to)) {
            this.target_progress_rate_to = "0";
        }
    }

    private String getCommonSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("    FROM");
        sb.append("      eip_t_project_task AS task");
        sb.append("    WHERE ");
        if (0 != this.selectedProjectId) {
            sb.append("task.project_id = #bind($project_id) AND ");
        }
        sb.append("       task.parent_task_id IS NULL");
        return sb.toString();
    }

    private String getFetchQuery(RunData rundata, Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT");
        sb.append(" 0 AS indent");
        sb.append(", task.task_id");
        sb.append(", task.task_name");
        sb.append(", task.parent_task_id");
        sb.append(", task.project_id");
        sb.append(", task.tracker");
        sb.append(", task.explanation");
        sb.append(", task.status");
        sb.append(", task.priority");
        sb.append(", task.start_plan_date");
        sb.append(", task.end_plan_date");
        sb.append(", task.start_date");
        sb.append(", task.end_date");
        sb.append(", task.plan_workload");
        sb.append(", task.progress_rate");
        sb.append(", task.update_date");
        sb.append(this.getCommonSQL());
        List<String> whereList = this.getWhereList();
        for (int i = 0; i < whereList.size(); ++i) {
            sb.append(" AND ");
            sb.append(whereList.get(i));
        }
        sb.append(this.getOrderBy(rundata, context));
        sb.append(" LIMIT ").append(this.getRowsNum()).append(" OFFSET ").append((this.current_page - 1) * this.getRowsNum());
        return sb.toString();
    }

    private String getCountQuery(RunData rundata, Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(task_id) AS count ");
        sb.append(this.getCommonSQL());
        List<String> whereList = this.getWhereList();
        for (int i = 0; i < whereList.size(); ++i) {
            sb.append(" AND ");
            sb.append(whereList.get(i));
        }
        return sb.toString();
    }

    private List<String> getWhereList() {
        ArrayList<String> whereList = new ArrayList<String>();
        if (this.target_keyword != null && this.target_keyword.trim().length() > 0) {
            whereList.add(" task.task_name LIKE #bind($target_keyword)");
        }
        if (StringUtils.isNotEmpty((String)this.target_user_id) && !this.target_user_id.equals("all")) {
            StringBuilder where = new StringBuilder();
            where.append(" EXISTS(");
            where.append("   SELECT 0");
            where.append("     FROM eip_t_project_task_member AS member");
            where.append("    WHERE member.task_id = task.task_id");
            where.append("      AND member.user_id = #bind($target_user_id)");
            where.append(" )");
            whereList.add(String.valueOf(where));
        }
        if (StringUtils.isNotEmpty((String)this.target_tracker) && !this.target_tracker.equals("all")) {
            whereList.add(" task.tracker = #bind($target_tracker)");
        }
        if (StringUtils.isNotEmpty((String)this.target_priority) && !this.target_priority.equals("all")) {
            whereList.add(" task.priority = #bind($target_priority)");
        }
        if (StringUtils.isNotEmpty((String)this.target_status) && !this.target_status.equals("all")) {
            whereList.add(" task.status = #bind($target_status)");
        }
        if (StringUtils.isNotEmpty((String)this.target_progress_rate_from) && !this.target_progress_rate_from.equals("0")) {
            whereList.add(" task.progress_rate >= #bind($target_progress_rate_from)");
        }
        if (StringUtils.isNotEmpty((String)this.target_progress_rate_to) && !this.target_progress_rate_to.equals("100")) {
            whereList.add(" task.progress_rate <= #bind($target_progress_rate_to)");
        }
        if (StringUtils.isNotEmpty((String)this.target_delay) && this.target_delay.equals("t")) {
            StringBuilder task_days = new StringBuilder();
            task_days.append(" CASE WHEN task.end_plan_date - task.start_plan_date + 1 < 0");
            task_days.append("    THEN 0");
            task_days.append("    ELSE task.end_plan_date - task.start_plan_date + 1");
            task_days.append("  END ");
            StringBuilder lapsed_days = new StringBuilder();
            lapsed_days.append(" CASE");
            lapsed_days.append("    WHEN task.start_plan_date IS NULL OR task.end_plan_date IS NULL");
            lapsed_days.append("      THEN 0");
            lapsed_days.append("    WHEN ").append(ProjectUtils.getCurrentDateWithCast()).append(" < task.end_plan_date");
            lapsed_days.append("      THEN");
            lapsed_days.append("        CASE WHEN ").append(ProjectUtils.getCurrentDateWithCast()).append(" - task.start_plan_date + 1 < 0");
            lapsed_days.append("          THEN 0");
            lapsed_days.append("          ELSE ").append(ProjectUtils.getCurrentDateWithCast()).append(" - task.start_plan_date + 1");
            lapsed_days.append("        END");
            lapsed_days.append("      ELSE");
            lapsed_days.append("        task.end_plan_date - task.start_plan_date + 1");
            lapsed_days.append("  END ");
            StringBuilder sb = new StringBuilder();
            sb.append(" ( ");
            sb.append(" ( " + task_days + " ) ");
            sb.append("  <> 0 AND ( ");
            sb.append(" ( " + lapsed_days + " ) ");
            sb.append(" * 100 / ");
            sb.append(" ( " + task_days + " ) ");
            sb.append(" > progress_rate ");
            sb.append(" ) ");
            sb.append(" ) ");
            whereList.add(sb.toString());
        }
        return whereList;
    }

    private void setPostgresParams(SQLTemplate<EipTProjectTask> sqltemp, SQLTemplate<EipTProjectTask> sqlCountTemp) {
        sqltemp.param("project_id", (Object)this.selectedProjectId);
        sqlCountTemp.param("project_id", (Object)this.selectedProjectId);
        if (StringUtils.isNotEmpty((String)this.target_keyword) && this.target_keyword.trim().length() > 0) {
            sqltemp.param("target_keyword", (Object)("%" + this.target_keyword + "%"));
            sqlCountTemp.param("target_keyword", (Object)("%" + this.target_keyword + "%"));
        }
        if (StringUtils.isNotEmpty((String)this.target_user_id) && !this.target_user_id.equals("all")) {
            sqltemp.param("target_user_id", (Object)Integer.valueOf(this.target_user_id));
            sqlCountTemp.param("target_user_id", (Object)Integer.valueOf(this.target_user_id));
        }
        if (StringUtils.isNotEmpty((String)this.target_tracker) && !this.target_tracker.equals("all")) {
            sqltemp.param("target_tracker", (Object)this.target_tracker);
            sqlCountTemp.param("target_tracker", (Object)this.target_tracker);
        }
        if (StringUtils.isNotEmpty((String)this.target_priority) && !this.target_priority.equals("all")) {
            sqltemp.param("target_priority", (Object)this.target_priority);
            sqlCountTemp.param("target_priority", (Object)this.target_priority);
        }
        if (StringUtils.isNotEmpty((String)this.target_status) && !this.target_status.equals("all")) {
            sqltemp.param("target_status", (Object)this.target_status);
            sqlCountTemp.param("target_status", (Object)this.target_status);
        }
        if (StringUtils.isNotEmpty((String)this.target_progress_rate_from) && !this.target_progress_rate_from.equals("0")) {
            sqltemp.param("target_progress_rate_from", (Object)Integer.valueOf(this.target_progress_rate_from));
            sqlCountTemp.param("target_progress_rate_from", (Object)Integer.valueOf(this.target_progress_rate_from));
        }
        if (StringUtils.isNotEmpty((String)this.target_progress_rate_to) && !this.target_progress_rate_to.equals("100")) {
            sqltemp.param("target_progress_rate_to", (Object)Integer.valueOf(this.target_progress_rate_to));
            sqlCountTemp.param("target_progress_rate_to", (Object)Integer.valueOf(this.target_progress_rate_to));
        }
    }

    protected String getOrderBy(RunData rundata, Context context) {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        String sort_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (sort != null && sort.length() > 0) {
            crt_key = map.getValue(sort);
        }
        this.current_sort = sort;
        this.current_sort_type = sort_type;
        if (crt_key != null && crt_key.length() > 0) {
            this.indentFlg = false;
            if (sort_type != null && "desc".equals(sort_type)) {
                return "  ORDER BY " + crt_key + " DESC";
            }
            return "  ORDER BY " + crt_key;
        }
        return "  ORDER BY order_no";
    }

    protected EipTProjectTask selectDetail(RunData rundata, Context context) {
        return ProjectUtils.getEipTProjectTask(rundata, context);
    }

    protected Object getResultData(EipTProjectTask record) {
        ProjectTaskResultData data;
        Integer taskId = (int)(data = ProjectUtils.getProjectTaskResultData(record)).getTaskId().getValue();
        int cntChild = ProjectUtils.getCountChildrenTask(taskId);
        data.setHasChildren(cntChild >= 2);
        data.setHasChildrenForForm(cntChild > 0);
        int lapsedDays = ProjectUtils.getLapsedDays(ProjectUtils.toString(record.getStartPlanDate()), ProjectUtils.toString(Calendar.getInstance().getTime()));
        int taskDays = ProjectUtils.getLapsedDays(ProjectUtils.toString(record.getStartPlanDate()), ProjectUtils.toString(record.getEndPlanDate()));
        data.setPlanTerm(taskDays);
        if (lapsedDays > taskDays) {
            lapsedDays = taskDays;
        }
        data.setPlanProgressRate(ProjectUtils.getPlanWorkload(lapsedDays, taskDays).intValue());
        List<ProjectTaskMemberResultData> memberList = data.getMemberList();
        BigDecimal workload = BigDecimal.valueOf(0L);
        workload = workload.setScale(1);
        for (int i = 0; i < memberList.size(); ++i) {
            ProjectTaskMemberResultData member = memberList.get(i);
            workload = workload.add(member.getWorkload());
        }
        data.setWorkload(workload);
        BigDecimal forecastWorkload = BigDecimal.valueOf(0L);
        if (data.getProgressRate().getValue() != 0L) {
            forecastWorkload = workload.multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(data.getProgressRate().getValue()), 2, 4);
        }
        data.setForecastWorkload(forecastWorkload);
        data.setIndentFlg(this.indentFlg);
        data.setEditable(ProjectFormUtils.isEditable(taskId, this.loginUserId));
        return data;
    }

    protected Object getResultDataDetail(EipTProjectTask record) {
        ProjectTaskResultData data = ProjectUtils.getProjectTaskResultData(record);
        int taskId = (int)data.getTaskId().getValue();
        List list = this.pfile.getSelectQueryForFiles("TASK_ID", taskId).fetchList();
        data.setAttachmentFiles(this.pfile.getFileList(list));
        data.setCommentList(ProjectUtils.getProjectTaskCommentList("" + taskId));
        data.setTopicPath(ProjectUtils.getTaskTopicPath(record.getProjectId()));
        data.setLoginUserId(this.loginUserId.longValue());
        return data;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("task_name", "task_name");
        map.putValue("tracker", "tracker");
        map.putValue("status", "status");
        map.putValue("workload", "workload");
        map.putValue("plan_workload", "plan_workload");
        map.putValue("start_plan_date", "start_plan_date");
        map.putValue("end_plan_date", "end_plan_date");
        map.putValue("progress_rate", "progress_rate");
        return map;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public List<ProjectResultData> getAllProject() {
        return this.allProject;
    }

    public Integer getSelectedProjectId() {
        return this.selectedProjectId;
    }

    public List<ALEipUser> getProjectMembers() {
        return this.projectMembers;
    }

    public String getTargetKeyword() {
        return this.target_keyword;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public String getTargetUserName() {
        if (!"".equals(this.getTargetUserId()) && this.getTargetUserId() != null) {
            try {
                return ALEipUtils.getALEipUser((int)Integer.parseInt(this.target_user_id)).getAliasName().toString();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getTargetTracker() {
        return this.target_tracker;
    }

    public String getTargetTrackerName() {
        if (!"".equals(this.getTargetTracker()) && this.getTargetTracker() != null) {
            return this.getTrackerMap().get(this.target_tracker);
        }
        return null;
    }

    public String getTargetPriority() {
        return this.target_priority;
    }

    public String getTargetPriorityName() {
        if (!"".equals(this.getTargetPriority()) && this.getTargetPriority() != null) {
            return this.getPriorityMap().get(this.target_priority);
        }
        return null;
    }

    public String getTargetStatus() {
        return this.target_status;
    }

    public String getTargetStatusName() {
        if (!"".equals(this.getTargetStatus()) && this.getTargetStatus() != null) {
            return this.getStatusMap().get(this.target_status);
        }
        return null;
    }

    public String getTargetProgressRateFrom() {
        return this.target_progress_rate_from;
    }

    public String getTargetProgressRateTo() {
        return this.target_progress_rate_to;
    }

    public String getTargetDelay() {
        return this.target_delay;
    }

    public String getProgressLineChecked() {
        return this.progress_line_checked;
    }

    public boolean isAndroid2() {
        return this.isAndroid2;
    }

    public int getViewDateMaxYear() {
        return this.viewDateMaxYear;
    }

    public ALDateTimeField getBaseDateFrom() {
        return this.base_date_from;
    }

    public ALDateTimeField getBaseDateTo() {
        return this.base_date_to;
    }

    public int getBaseDateFromYear() {
        return this.calFrom.get(1);
    }

    public int getBaseDateToYear() {
        return this.calTo.get(1);
    }

    public int getDay(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return cal.get(5);
    }

    public boolean isToday(int days) {
        Calendar today = Calendar.getInstance();
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return today.get(1) == cal.get(1) && today.get(2) == cal.get(2) && today.get(5) == cal.get(5);
    }

    public int getDays() {
        return ProjectUtils.getLapsedDays(this.calFrom, this.calTo);
    }

    public int getDays(Date dateTo) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateTo);
        return ProjectUtils.getLapsedDays(this.calFrom, cal);
    }

    public int getYear(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return cal.get(1);
    }

    public int getMonth(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return cal.get(2);
    }

    public int getWeek(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return cal.get(3);
    }

    public Map<String, String> getTrackerMap() {
        return ProjectUtils.getKubunMap("tracker");
    }

    public Map<String, String> getStatusMap() {
        return ProjectUtils.getKubunMap("status");
    }

    public Map<String, String> getPriorityMap() {
        return ProjectUtils.getKubunMap("priority");
    }

    public long getNowTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public boolean isHoliday(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        ALEipHolidaysManager holidaysManager = ALEipHolidaysManager.getInstance();
        return holidaysManager.isHoliday(cal.getTime()) != null;
    }

    public boolean isSaturday(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return 7 == cal.get(7);
    }

    public boolean isSunday(int days) {
        Calendar cal = (Calendar)this.calFrom.clone();
        cal.add(5, days - 1);
        return 1 == cal.get(7);
    }

    public String getViewtype() {
        return "project";
    }

    private boolean isRejectParameter(String numeric) {
        return StringUtils.isNotEmpty((String)numeric) && !"all".equals(numeric) && !StringUtils.isNumeric((String)numeric);
    }

    public void setProject(RunData rundata, Context context) {
        String filter = rundata.getParameters().getString("filter", "");
        String filterType = rundata.getParameters().getString("filtertype", "");
        String sesFilter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String sesFilterType = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        sesFilter = sesFilter == null ? "" : sesFilter;
        String string = sesFilterType = sesFilterType == null ? "" : sesFilterType;
        if (filterType.isEmpty()) {
            filter = sesFilter;
            filterType = sesFilterType;
        }
        if (StringUtils.isEmpty((String)filter) || StringUtils.isEmpty((String)filterType)) {
            this.selectedProjectId = 0;
            this.setFilter(rundata, context);
            return;
        }
        boolean existProject = false;
        for (ProjectResultData data : this.allProject) {
            if (!filter.equals(data.getProjectId().toString())) continue;
            existProject = true;
            break;
        }
        this.selectedProjectId = !existProject ? Integer.valueOf(0) : Integer.valueOf(filter);
        this.setFilter(rundata, context);
    }

    private void setFilter(RunData rundata, Context context) {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)String.valueOf(this.selectedProjectId));
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"project_id");
    }

    public boolean isFileUploadable() {
        return this.isFileUploadable;
    }
}

