/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.commons.utils;

import com.aimluck.eip.cayenne.om.portlet.IEipTFile;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.storage.ALStorageService;
import java.util.List;
import org.apache.cayenne.exp.ExpressionFactory;

public abstract class ALDeleteFileUtil {
    public static <T> void deleteFiles(int id, String property, String base, List<String> fpaths, Class<T> clazz) throws ALFileNotRemovedException {
        SelectQuery<T> query = Database.query(clazz);
        query.andQualifier(ExpressionFactory.matchDbExp((String)property, (Object)id));
        List<T> files = query.fetchList();
        Database.deleteAll(files);
        if (fpaths.size() > 0) {
            try {
                int fsize = fpaths.size();
                for (int i = 0; i < fsize; ++i) {
                    ALStorageService.deleteFile(base + fpaths.get(i));
                }
            }
            catch (Exception e) {
                Database.rollback();
                ALFileNotRemovedException fe = new ALFileNotRemovedException();
                fe.initCause(e);
                throw fe;
            }
        }
        Database.commit();
    }

    public static void deleteFiles(String savePath, List<?> files) throws ALFileNotRemovedException {
        try {
            for (Object file : files) {
                if (file instanceof IEipTFile) {
                    IEipTFile ifile = (IEipTFile)file;
                    ALStorageService.deleteFile(savePath + ifile.getFilePath());
                    continue;
                }
                throw new ALFileNotRemovedException();
            }
            Database.deleteAll(files);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            ALFileNotRemovedException fe = new ALFileNotRemovedException();
            fe.initCause(t);
            throw fe;
        }
    }

    public static void deleteFiles(String rootPath, String categoryKey, List<?> files) throws ALFileNotRemovedException {
        try {
            for (Object file : files) {
                if (file instanceof IEipTFile) {
                    IEipTFile ifile = (IEipTFile)file;
                    ALStorageService.deleteFile(ALStorageService.getDocumentPath(rootPath, categoryKey + ALStorageService.separator() + ifile.getOwnerId()) + ifile.getFilePath());
                    continue;
                }
                throw new ALFileNotRemovedException();
            }
            Database.deleteAll(files);
            Database.commit();
        }
        catch (Throwable t) {
            Database.rollback();
            ALFileNotRemovedException fe = new ALFileNotRemovedException();
            fe.initCause(t);
            throw fe;
        }
    }
}

