/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import com.aimluck.eip.util.ALTimelineUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.AccountExpiredException;
import org.apache.jetspeed.services.security.CredentialExpiredException;
import org.apache.jetspeed.services.security.FailedLoginException;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.jetspeed.services.security.nosecurity.FakeJetspeedUser;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.StringUtils;

public class ALJLoginUser
extends ActionEvent {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ALJLoginUser.class.getName());
    public static String KEY_MYGROUP = "mygroup";

    public void doPerform(RunData rundata) throws Exception {
        String message;
        JetspeedRunData data = (JetspeedRunData)rundata;
        String username = data.getParameters().getString("username", "");
        String password = data.getParameters().getString("password", "");
        if (ALCellularUtils.isCellularPhone((RunData)data) && username != null && password != null && data.getRequest().getMethod() == "GET") {
            String externalLoginUrl = ALConfigService.get(ALConfigHandler.Property.EXTERNAL_LOGIN_URL);
            if (!"".equals(externalLoginUrl)) {
                data.setRedirectURI(externalLoginUrl);
            }
            data.getResponse().sendRedirect(data.getRedirectURI());
        } else if (!data.getRequest().isRequestedSessionIdFromCookie()) {
            data.setScreenTemplate("CookieError");
            return;
        }
        ALStringField tmpname = new ALStringField();
        tmpname.setTrim(true);
        tmpname.setNotNull(true);
        tmpname.setCharacterType(19);
        tmpname.limitMaxLength(16);
        tmpname.setValue(username);
        boolean valid = tmpname.validate(new ArrayList<String>());
        if (ALCellularUtils.isCellularPhone((RunData)data) && data.getParameters().getString("key", "").trim() != null) {
            valid = true;
        }
        int length = username.length();
        for (int i1 = 0; i1 < length; ++i1) {
            if (!this.isSymbol(username.charAt(i1)) || username.charAt(i1) == "_".charAt(0) || username.charAt(i1) == "-".charAt(0) || username.charAt(i1) == ".".charAt(0)) continue;
            valid = false;
            break;
        }
        if (!valid) {
            data.setUser((User)JetspeedSecurity.getAnonymousUser());
            data.setMessage(ALLocalizationUtils.getl10n("LOGINACTION_NO_USERID_PW"));
            data.getUser().setHasLoggedIn(Boolean.FALSE);
            return;
        }
        if (ALCellularUtils.isSmartPhone((RunData)data) && "admin".equals(username)) {
            data.setUser((User)JetspeedSecurity.getAnonymousUser());
            data.setMessage(ALLocalizationUtils.getl10n("LOGINACTION_LOGIN_ONLY_PC"));
            data.getUser().setHasLoggedIn(Boolean.FALSE);
            return;
        }
        if ("admin".equals(username) && "T".equals(ALConfigService.get(ALConfigHandler.Property.FIRST_ADMIN_LOGIN))) {
            if (!ALTimelineUtils.hasTimelinePost()) {
                ALTimelineUtils.postTimeline(data, 2);
            }
            ALConfigService.put(ALConfigHandler.Property.FIRST_ADMIN_LOGIN, "F");
        }
        boolean newUserApproval = JetspeedResources.getBoolean((String)"newuser.approval.enable", (boolean)false);
        String secretkey = data.getParameters().getString("secretkey", null);
        if (secretkey != null) {
            String button1 = data.getParameters().getString("submit1", null);
            if (button1 != null && button1.equalsIgnoreCase("Cancel")) {
                data.setScreenTemplate(TurbineTemplate.getDefaultScreen());
                return;
            }
            JetspeedUser user = JetspeedSecurity.getUser((String)username);
            if (user == null) {
                logger.warn((Object)"JLogin User: Unexpected condition : user is NULL");
                return;
            }
            String confirm_value = user.getConfirmed();
            if (!secretkey.equals(confirm_value) && !confirm_value.equals("CONFIRMED")) {
                if (newUserApproval) {
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                    return;
                }
                if (user.getConfirmed().equals("REJECTED")) {
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                    return;
                }
                data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                return;
            }
            user.setConfirmed("CONFIRMED");
            data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_WELCOME"));
            JetspeedSecurity.saveUser((JetspeedUser)user);
        }
        JetspeedUser user = null;
        try {
            if (ALCellularUtils.isCellularPhone((RunData)data)) {
                String celluid;
                Cookie[] key = data.getParameters().getString("key", "").trim();
                if (key != null && key.length() > 0 && key.contains("_")) {
                    username = key.substring(0, key.lastIndexOf("_"));
                    String base64value = key.substring(key.lastIndexOf("_") + 1);
                    ALEipUser eipuser = ALEipUtils.getALEipUser(username);
                    if (eipuser != null) {
                        if (!ALCellularUtils.getCheckValueForCellLogin(username, eipuser.getUserId().toString()).equals(base64value)) {
                            username = "";
                        }
                    } else {
                        username = "";
                    }
                }
                if (!"".equals(celluid = ALCellularUtils.getCellularUid(rundata))) {
                    password = "cellularuid_" + celluid;
                }
            }
            user = JetspeedSecurity.login((String)username, (String)password);
            JetspeedSecurity.saveUser((JetspeedUser)user);
            if (rundata.getRequest().getCookies() != null) {
                for (Cookie cookie : rundata.getRequest().getCookies()) {
                    String cookieName = cookie.getName();
                    if (!cookieName.startsWith("aui_info_disp_")) continue;
                    cookie.setMaxAge(0);
                    cookie.setPath("/");
                    cookie.setValue("true");
                    data.getResponse().addCookie(cookie);
                }
            }
            int loginUserId = Integer.parseInt(user.getUserId());
            ALEventlogFactoryService.getInstance().getEventlogHandler().logLogin(loginUserId);
        }
        catch (LoginException e) {
            message = e.getMessage() != null ? e.getMessage() : e.toString();
            data.setMessage(message);
            data.setUser((User)JetspeedSecurity.getAnonymousUser());
            data.getUser().setHasLoggedIn(Boolean.FALSE);
            if (e instanceof FailedLoginException) {
                if ("T".equals(message)) {
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_ACCOUNT_DISABLED"));
                    return;
                }
                if ("N".equals(message)) {
                    data.setMessage(ALLocalizationUtils.getl10n("LOGINACTION_INVALIDATION_USER"));
                    return;
                }
                if (!this.disableCheck(data)) {
                    logger.info((Object)("JLoginUser: Credential Failure on login for user: " + username));
                    data.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_FAILED_MSG"));
                }
            } else if (e instanceof AccountExpiredException) {
                logger.info((Object)("JLoginUser: Account Expired for user " + username));
            } else if (e instanceof CredentialExpiredException) {
                logger.info((Object)("JLoginUser: Credentials expired for user: " + username));
                data.setMessage(Localization.getString((RunData)rundata, (String)"PASSWORDFORM_EXPIRED_MSG"));
                data.getParameters().setString("username", username);
            }
            return;
        }
        catch (Throwable other) {
            message = other.getMessage() != null ? other.getMessage() : other.toString();
            data.setMessage(message);
            data.setStackTrace(StringUtils.stackTrace((Throwable)other), other);
            FakeJetspeedUser juser = new FakeJetspeedUser(JetspeedSecurity.getAnonymousUserName(), false);
            data.setUser((User)juser);
            return;
        }
        if (data.getUser().hasLoggedIn()) {
            boolean userRequestsRememberMe;
            String confirmed;
            if (JetspeedSecurity.isDisableAccountCheckEnabled()) {
                JetspeedSecurity.resetDisableAccountCheck((String)data.getParameters().getString("username", ""));
            }
            if ((confirmed = data.getUser().getConfirmed()) == null || !confirmed.equals("CONFIRMED")) {
                if (confirmed != null && confirmed.equals("REJECTED")) {
                    data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_KEYNOTVALID"));
                    data.getUser().setHasLoggedIn(Boolean.FALSE);
                    return;
                }
                data.setMessage(Localization.getString((RunData)rundata, (String)"JLOGINUSER_CONFIRMFIRST"));
                data.getUser().setHasLoggedIn(Boolean.FALSE);
                return;
            }
            boolean automaticLogonEnabled = JetspeedResources.getBoolean((String)"automatic.logon.enable", (boolean)false);
            if (automaticLogonEnabled && (userRequestsRememberMe = data.getParameters().getBoolean("rememberme", false))) {
                int maxage = JetspeedResources.getInt((String)"automatic.logon.cookie.maxage", (int)-1);
                String comment = JetspeedResources.getString((String)"automatic.logon.cookie.comment", (String)"");
                String domain = JetspeedResources.getString((String)"automatic.logon.cookie.domain");
                String path = JetspeedResources.getString((String)"automatic.logon.cookie.path", (String)"/");
                if (domain == null) {
                    String server = data.getServerName();
                    domain = "." + server;
                }
                String loginCookieValue = null;
                if (JetspeedResources.getString((String)"automatic.logon.cookie.generation", (String)"everylogon").equals("everylogon")) {
                    loginCookieValue = "" + Math.random();
                    data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                    JetspeedSecurity.saveUser((JetspeedUser)data.getJetspeedUser());
                } else {
                    loginCookieValue = (String)data.getUser().getPerm("logincookie");
                    if (loginCookieValue == null || loginCookieValue.length() == 0) {
                        loginCookieValue = "" + Math.random();
                        data.getUser().setPerm("logincookie", (Object)loginCookieValue);
                        JetspeedSecurity.saveUser((JetspeedUser)data.getJetspeedUser());
                    }
                }
                Cookie userName = new Cookie("username", data.getUser().getUserName());
                Cookie loginCookie = new Cookie("logincookie", loginCookieValue);
                userName.setMaxAge(maxage);
                userName.setComment(comment);
                userName.setDomain(domain);
                userName.setPath(path);
                loginCookie.setMaxAge(maxage);
                loginCookie.setComment(comment);
                loginCookie.setDomain(domain);
                loginCookie.setPath(path);
                data.getResponse().addCookie(userName);
                data.getResponse().addCookie(loginCookie);
            }
            JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
            String redirectUrl = data.getParameters().getString("redirect", "");
            if (redirectUrl != null && !"".equals(redirectUrl)) {
                data.setRedirectURI(redirectUrl);
                data.getResponse().sendRedirect(redirectUrl);
                JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                jsLink = null;
                return;
            }
            if (ALCellularUtils.isCellularPhone((RunData)data)) {
                rundata.setRedirectURI(jsLink.getPortletById("").addQueryData("action", "controls.Restore").toString());
                rundata.getResponse().sendRedirect(rundata.getRedirectURI());
                JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                jsLink = null;
                return;
            }
            String client = ALEipUtils.getClient(rundata);
            String peid = data.getParameters().getString("js_peid");
            if (peid == null) {
                peid = (String)data.getUser().getTemp("js_peid");
            }
            if (peid == null && "IPHONE".equals(client)) {
                String firstPortletId = ALEipUtils.getFirstPortletId(data.getUser().getUserName());
                String url = jsLink.getPortletById(firstPortletId).addQueryData("action", "controls.Maximize").toString();
                data.setRedirectURI(url);
                data.getResponse().sendRedirect(url);
                JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
                jsLink = null;
                return;
            }
        } else {
            this.disableCheck(data);
        }
    }

    protected boolean isSymbol(char ch) {
        byte[] chars;
        try {
            chars = Character.valueOf(ch).toString().getBytes("shift_jis");
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
        return chars != null && chars.length != 2 && !Character.isDigit(ch) && !Character.isLetter(ch);
    }

    private boolean disableCheck(JetspeedRunData data) {
        boolean disabled = false;
        if (JetspeedSecurity.isDisableAccountCheckEnabled() && (disabled = JetspeedSecurity.checkDisableAccount((String)data.getParameters().getString("username", "")))) {
            data.setMessage(Localization.getString((RunData)data, (String)"JLOGINUSER_ACCOUNT_DISABLED"));
            data.setScreenTemplate(JetspeedResources.getString((String)"logon.disabled.form"));
            data.getUser().setHasLoggedIn(Boolean.FALSE);
        }
        return disabled;
    }
}

