/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.modules.screens.ALJSONScreen;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import net.sf.json.JSONArray;
import org.apache.jetspeed.om.BaseSecurityReference;
import org.apache.jetspeed.om.SecurityReference;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.Skin;
import org.apache.jetspeed.om.profile.psml.PsmlSkin;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletSkin;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.MetaData;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.StringUtils;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class PortletCustomizeFormJSONScreen
extends ALJSONScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PortletCustomizeFormJSONScreen.class.getName());

    @Override
    protected String getJSONString(RunData rundata, Context context) throws Exception {
        String result = new JSONArray().toString();
        SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        String peid = jdata.getParameters().getString("js_peid");
        PortletSet found = null;
        List params = (List)customizationState.getAttribute("customize-parameters");
        String newSecurityParent = rundata.getParameters().getString("_security_ref");
        String newSkinName = rundata.getParameters().getString("_skin");
        String newTitle = rundata.getParameters().getString("current_title");
        boolean changeRequested = params != null || newSkinName != null || newSecurityParent != null || newTitle != null;
        boolean madePsChange = false;
        boolean madePcChange = false;
        if (peid == null || !changeRequested) {
            this.doCancel(rundata, context);
            return result;
        }
        Profile profile = ((JetspeedRunData)rundata).getCustomizedProfile();
        Entry entry = profile.getDocument().getEntryById(peid);
        Stack<Object> sets = new Stack<Object>();
        sets.push(profile.getRootSet());
        while (found == null && sets.size() > 0) {
            PortletSet set = (PortletSet)sets.pop();
            if (set.getID().equals(peid)) {
                found = set;
                continue;
            }
            Enumeration en = set.getPortlets();
            while (found == null && en.hasMoreElements()) {
                Portlet p;
                Portlet real = p = (Portlet)en.nextElement();
                while (real instanceof PortletControl) {
                    real = ((PortletControl)p).getPortlet();
                }
                if (real instanceof PortletSet) {
                    if (real.getID().equals(peid)) {
                        found = real;
                        continue;
                    }
                    sets.push(real);
                    continue;
                }
                if (!p.getID().equals(peid)) continue;
                found = p;
            }
        }
        if (found == null) {
            this.doCancel(rundata, context);
            return result;
        }
        PortletConfig pc = found.getPortletConfig();
        if (newSecurityParent != null) {
            boolean securityChanged = false;
            SecurityReference currentSecurityRef = pc.getSecurityRef();
            if (currentSecurityRef != null) {
                securityChanged = !newSecurityParent.equals(currentSecurityRef.getParent());
            } else {
                boolean bl = securityChanged = newSecurityParent.trim().length() > 0;
            }
            if (securityChanged) {
                BaseSecurityReference securityRef = null;
                if (newSecurityParent.trim().length() > 0) {
                    securityRef = new BaseSecurityReference();
                    securityRef.setParent(newSecurityParent);
                }
                pc.setSecurityRef(securityRef);
                entry.setSecurityRef((SecurityReference)securityRef);
                madePcChange = true;
            }
        }
        if (newSkinName != null) {
            boolean skinChanged = false;
            String currentSkinName = null;
            if (pc.getSkin() != null) {
                currentSkinName = pc.getPortletSkin().getName();
            }
            if (currentSkinName != null) {
                skinChanged = !newSkinName.equals(currentSkinName);
            } else {
                boolean bl = skinChanged = newSkinName.trim().length() > 0;
            }
            if (skinChanged) {
                PortletSkin skin = null;
                if (newSkinName.trim().length() > 0) {
                    skin = PortalToolkit.getSkin((String)newSkinName);
                    if (skin != null) {
                        pc.setPortletSkin(skin);
                        Skin psmlSkin = entry.getSkin();
                        if (psmlSkin == null) {
                            entry.setSkin((Skin)new PsmlSkin());
                        }
                        entry.getSkin().setName(newSkinName);
                    } else {
                        logger.warn((Object)("Unable to update skin for portlet entry " + entry.getId() + " because skin does not exist."));
                    }
                } else {
                    pc.setPortletSkin(null);
                    entry.setSkin(null);
                }
                madePcChange = true;
            }
        }
        if (newTitle != null) {
            boolean titleChanged = false;
            String currentTitle = entry.getTitle();
            MetaData md = pc.getMetainfo();
            if (currentTitle == null && md != null && md.getTitle() != null) {
                currentTitle = md.getTitle();
            }
            if (currentTitle != null) {
                titleChanged = !newTitle.equals(currentTitle);
            } else {
                boolean bl = titleChanged = newTitle.trim().length() > 0;
            }
            if (titleChanged && newTitle.trim().length() > 0) {
                if (md == null) {
                    md = new MetaData();
                    pc.setMetainfo(md);
                }
                md.setTitle(newTitle);
                entry.setTitle(newTitle);
                madePcChange = true;
            }
        }
        try {
            PortletInstance instance = PersistenceManager.getInstance((Portlet)found, (RunData)rundata);
            PortletEntry regEntry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)found.getName());
            for (Parameter param : params) {
                String name = param.getName();
                String newValue = null;
                String[] testArray = rundata.getParameters().getStrings(name);
                if (testArray != null && testArray.length > 1) {
                    newValue = StringUtils.arrayToString((String[])testArray, (String)",");
                } else {
                    newValue = rundata.getParameters().getString(name);
                    if (newValue == null) {
                        newValue = "";
                    }
                }
                String regValue = name.startsWith("pref-") ? "" : regEntry.getParameter(name).getValue();
                String psmlValue = instance.getAttribute(name);
                if (newValue != null) {
                    if (!regValue.equals(newValue) || !psmlValue.equals(newValue)) {
                        instance.setAttribute(name, newValue);
                        psmlValue = newValue;
                    }
                    madePsChange = true;
                }
                if (psmlValue == null || !psmlValue.equals(regValue)) continue;
                instance.removeAttribute(name);
                madePsChange = true;
            }
            if (madePsChange || madePcChange) {
                try {
                    profile.store();
                    found.init();
                    PortletSessionState.setPortletConfigChanged((Portlet)found, (RunData)rundata);
                }
                catch (PortletException e) {
                    logger.error((Object)("Customizer failed to reinitialize the portlet " + found.getName()), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to save profile ", (Throwable)e);
                }
            }
            this.doCancel(rundata, context);
        }
        catch (Exception e) {
            logger.error((Object)"ALCustomizeAction.doUpdate", (Throwable)e);
        }
        return result;
    }

    public void doCancel(RunData rundata, Context context) {
        ((JetspeedRunData)rundata).setCustomized(null);
        if (((JetspeedRunData)rundata).getCustomized() == null) {
            try {
                ActionLoader.getInstance().exec(rundata, "controls.EndCustomize");
            }
            catch (Exception e) {
                logger.error((Object)"Unable to load action controls.EndCustomize ", (Throwable)e);
            }
        }
    }
}

