/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.modules.screens.ALVelocityScreen;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.gadgets.ALUserPref;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.om.profile.ProfileLocator;
import org.apache.jetspeed.om.registry.Parameter;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseParameter;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.portal.PortletInstance;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.jetspeed.util.template.JetspeedTool;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class PortletCustomizeFormScreen
extends ALVelocityScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)PortletCustomizeFormScreen.class.getName());

    @Override
    protected void doOutput(RunData rundata, Context context) throws Exception {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        jdata.cleanupFromCustomization();
        if (jdata.getUser() == null) {
            return;
        }
        if (jdata.getProfile() == null) {
            return;
        }
        String editMediaType = jdata.getParameters().getString("mtype");
        String resetStack = jdata.getParameters().getString("reset");
        String peid = jdata.getParameters().getString("js_peid");
        Profile profile = null;
        if (resetStack != null && (resetStack.equalsIgnoreCase("on") || resetStack.equalsIgnoreCase("1"))) {
            jdata.cleanupFromCustomization();
        }
        if (jdata.getCustomizedProfile() == null) {
            ProfileLocator locator = (ProfileLocator)jdata.getProfile().clone();
            if (editMediaType != null) {
                locator.setMediaType(editMediaType);
            }
            profile = (Profile)Profiler.getProfile((ProfileLocator)locator).clone();
            jdata.setCustomizedProfile(profile);
        } else {
            profile = jdata.getCustomizedProfile();
        }
        if (peid == null) {
            peid = profile.getRootSet().getID();
            jdata.setJs_peid(peid);
        }
        PortletSet found = null;
        Stack<Object> sets = new Stack<Object>();
        sets.push(profile.getRootSet());
        while (found == null && sets.size() > 0) {
            PortletSet set = (PortletSet)sets.pop();
            if (set.getID().equals(peid)) {
                found = set;
                continue;
            }
            Enumeration en = set.getPortlets();
            while (found == null && en.hasMoreElements()) {
                Portlet p;
                Portlet real = p = (Portlet)en.nextElement();
                while (real instanceof PortletControl) {
                    real = ((PortletControl)p).getPortlet();
                }
                if (real instanceof PortletSet) {
                    if (real.getID().equals(peid)) {
                        found = real;
                        continue;
                    }
                    sets.push(real);
                    continue;
                }
                if (!p.getID().equals(peid)) continue;
                found = p;
            }
        }
        if (found != null) {
            PortalResource portalResource = new PortalResource(found);
            try {
                JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                portalResource.setOwner(jsLink.getUserName());
                JetspeedLinkFactory.putInstance((JetspeedLink)jsLink);
            }
            catch (Exception e) {
                logger.warn((Object)"[Customize]", (Throwable)e);
                portalResource.setOwner(null);
            }
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)jdata.getUser()), (PortalResource)portalResource, (String)"customize")) {
                logger.warn((Object)("User " + jdata.getUser().getUserName() + " has no customize permission for portlet with id " + peid));
                jdata.setMessage("Sorry, you have no customize permission for this portlet");
                return;
            }
            PortletInstance instance = PersistenceManager.getInstance((Portlet)found, (RunData)rundata);
            context.put("portlet_instance", (Object)PersistenceManager.getInstance((Portlet)found, (RunData)rundata));
            PortletEntry entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)found.getName());
            ArrayList<BaseParameter> params = new ArrayList<BaseParameter>();
            Iterator i = entry.getParameterNames();
            while (i.hasNext()) {
                String name = (String)i.next();
                Parameter param = entry.getParameter(name);
                if (param.isHidden() || name.charAt(0) == '_' || !JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)rundata.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry, param), (String)"customize")) continue;
                BaseParameter clone = new BaseParameter();
                clone.setName(param.getName());
                clone.setTitle(param.getTitle());
                clone.setDescription(param.getDescription());
                clone.setType(param.getType());
                String value = instance.getAttribute(name, null) != null ? instance.getAttribute(name) : (found.getPortletConfig().getInitParameter(name) != null ? found.getPortletConfig().getInitParameter(name) : param.getValue());
                clone.setValue(ALStringUtil.sanitizing(value));
                params.add(clone);
            }
            Collections.sort(params, new Comparator<Parameter>(){

                @Override
                public int compare(Parameter a, Parameter b) {
                    Parameter p1 = a;
                    Parameter p2 = b;
                    return p1.getName().compareTo(p2.getName());
                }
            });
            PortletConfig pc = found.getPortletConfig();
            if ("GadgetsTemplate".equals(pc.getName())) {
                String appId = pc.getInitParameter("aid");
                ALApplication app = ALApplicationService.get(new ALApplicationGetRequest().withAppId(appId).withIsFetchXml(true));
                ArrayList<List<Map.Entry<String, String>>> enumsList = new ArrayList<List<Map.Entry<String, String>>>();
                List<ALUserPref> userPrefs = app.getUserPrefs();
                Collections.sort(userPrefs, new Comparator<ALUserPref>(){

                    @Override
                    public int compare(ALUserPref a, ALUserPref b) {
                        ALUserPref p1 = a;
                        ALUserPref p2 = b;
                        return p1.getName().compareTo(p2.getName());
                    }
                });
                for (ALUserPref userPref : userPrefs) {
                    String value;
                    String name = "pref-" + userPref.getName();
                    BaseParameter clone = new BaseParameter();
                    clone.setName(name);
                    clone.setTitle(userPref.getDisplayName());
                    clone.setDescription(null);
                    boolean hidden = false;
                    boolean list = false;
                    switch (userPref.getType()) {
                        case ENUM: {
                            List<Map.Entry<String, String>> enums = userPref.getEnums();
                            enumsList.add(enums);
                            clone.setType("enum");
                            break;
                        }
                        case LIST: {
                            clone.setType("list");
                            list = true;
                            break;
                        }
                        case BOOL: {
                            clone.setType("boolean");
                            break;
                        }
                        case HIDDEN: {
                            clone.setType("hidden");
                            hidden = true;
                            break;
                        }
                        default: {
                            clone.setType(null);
                        }
                    }
                    if (instance.getAttribute(name, null) != null) {
                        value = instance.getAttribute(name);
                    } else if (found.getPortletConfig().getInitParameter(name) != null) {
                        value = found.getPortletConfig().getInitParameter(name);
                    } else {
                        value = userPref.getDefault();
                        if (list) {
                            value = value.replace("|", ",");
                        }
                    }
                    clone.setValue(ALStringUtil.sanitizing(value));
                    if (hidden) continue;
                    params.add(clone);
                }
                context.put("enums", enumsList);
            }
            SessionState customizationState = ((JetspeedRunData)rundata).getPageSessionState();
            customizationState.setAttribute("customize-parameters", params);
            context.put("data", (Object)rundata);
            context.put("parameters", params);
            context.put("portlet", (Object)found);
            context.put("jetspeed", (Object)new JetspeedTool(rundata));
            context.put("l10n", (Object)ALLocalizationUtils.createLocalization(rundata));
            context.put("utils", (Object)new ALCommonUtils());
            context.put("js_peid", (Object)peid);
            String currentTitle = profile.getDocument().getEntryById(found.getID()).getTitle();
            if (currentTitle == null && found.getPortletConfig().getMetainfo() != null) {
                currentTitle = found.getPortletConfig().getMetainfo().getTitle();
            }
            context.put("current_title", (Object)new ALStringField(currentTitle));
            String layout_template = "portlets/html/customizer-portlet.vm";
            this.setTemplate(rundata, context, layout_template);
        }
        jdata.getUser().removeTemp("js_peid");
    }

    @Override
    protected String getPortletName() {
        return "Customize";
    }
}

