/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.orgutils;

import com.aimluck.eip.http.HttpServletRequestLocator;
import com.aimluck.eip.http.ServletContextLocator;
import com.aimluck.eip.services.config.ALConfigHandler;
import com.aimluck.eip.services.config.ALConfigService;
import com.aimluck.eip.services.social.ALContainerConfigService;
import com.aimluck.eip.services.social.ALSocialApplicationHandler;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALServletUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.velocity.context.Context;

public abstract class ALOrgUtilsHandler {
    public abstract String getTheme(String var1);

    public abstract String getAlias(String var1);

    public abstract String getAliasjp(String var1);

    public abstract String getCopyright(String var1);

    public abstract String getAliasCopyright(String var1);

    public abstract String getCopyrightShort(String var1);

    public abstract String getVersion(String var1);

    public Map<String, String> getParameters(String orgId) {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("theme", this.getTheme(orgId));
        hash.put("alias", this.getAlias(orgId));
        hash.put("aliasjp", this.getAliasjp(orgId));
        hash.put("copyright", this.getCopyright(orgId));
        hash.put("copyright_short", this.getCopyrightShort(orgId));
        hash.put("alias_copyright", this.getAliasCopyright(orgId));
        hash.put("version", this.getVersion(orgId));
        String url = this.getExternalResourcesUrl(orgId);
        hash.put("external_resources_url", url);
        hash.put("unlockeddomain_url", this.getUnlockedDomainBaseUrl(orgId));
        hash.put("context_path", this.getContextPath(orgId));
        hash.put("isXDomain", String.valueOf(url.startsWith("http")));
        HttpServletRequest request = HttpServletRequestLocator.get();
        String useragent = request.getHeader("User-Agent").trim();
        hash.put("client", ALEipUtils.getClient(useragent));
        hash.put("clientVer", ALEipUtils.getClientVersion(useragent));
        return hash;
    }

    public String getExternalResourcesUrl(String orgId) {
        StringBuffer url = new StringBuffer();
        String external_resources_url = "";
        try {
            external_resources_url = ALConfigService.get(ALConfigHandler.Property.EXTERNAL_RESOURCES_URL);
        }
        catch (IllegalStateException ignore) {
            // empty catch block
        }
        if (external_resources_url.isEmpty()) {
            ServletContext servletContext = ServletContextLocator.get();
            String contextPath = servletContext.getContextPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            url.append(contextPath);
        } else {
            url.append(external_resources_url);
        }
        return url.toString();
    }

    public String getXDomainBasePath(String orgId) {
        String url = this.getExternalResourcesUrl(orgId);
        if (url.startsWith("http")) {
            return url;
        }
        return ALServletUtils.getRequestBaseUrl() + url;
    }

    public String getUnlockedDomainBaseUrl(String orgId) {
        String unlockedDomain = "";
        try {
            unlockedDomain = ALContainerConfigService.get(ALSocialApplicationHandler.Property.UNLOCKED_DOMAIN);
        }
        catch (IllegalStateException ignore) {
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (unlockedDomain.isEmpty()) {
            return "";
        }
        HttpServletRequest request = HttpServletRequestLocator.get();
        String scheme = request.getScheme();
        StringBuffer url = new StringBuffer(scheme);
        url.append("://");
        url.append(unlockedDomain);
        return url.toString();
    }

    public String getContextPath(String orgId) {
        String contextPath = ServletContextLocator.get().getContextPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        return contextPath;
    }

    public void assignCommonContext(Context context, String orgId) {
        Map<String, String> map = this.getParameters(orgId);
        for (Map.Entry<String, String> next : map.entrySet()) {
            context.put(next.getKey(), (Object)next.getValue());
        }
    }
}

