/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.services.social.gadgets;

import java.util.Map;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

public class AipoBlobCrypterSecurityToken
extends BlobCrypterSecurityToken {
    protected static final String APP_KEY = "a";
    protected String appId;

    public AipoBlobCrypterSecurityToken(BlobCrypter crypter, String container, String domain) {
        super(crypter, container, domain);
    }

    static BlobCrypterSecurityToken decrypt(BlobCrypter crypter, String container, String domain, String token, String activeUrl) throws BlobCrypterException {
        Map values = crypter.unwrap(token, 3600);
        AipoBlobCrypterSecurityToken t = new AipoBlobCrypterSecurityToken(crypter, container, domain);
        AipoBlobCrypterSecurityToken.setTokenValues(t, values);
        t.setActiveUrl(activeUrl);
        return t;
    }

    protected static void setTokenValues(BlobCrypterSecurityToken token, Map<String, String> values) {
        String expiresAt;
        token.setOwnerId(values.get("o"));
        token.setViewerId(values.get("v"));
        token.setAppUrl(values.get("g"));
        String moduleId = values.get("i");
        if (moduleId != null) {
            token.setModuleId(Long.parseLong(moduleId));
        }
        if ((expiresAt = values.get("x")) != null) {
            token.setExpiresAt(Long.valueOf(Long.parseLong(expiresAt)));
        }
        token.setTrustedJson(values.get("j"));
        if (token instanceof AipoBlobCrypterSecurityToken) {
            AipoBlobCrypterSecurityToken aipoToken = (AipoBlobCrypterSecurityToken)token;
            aipoToken.setAppId(values.get(APP_KEY));
        }
    }

    protected Map<String, String> buildValuesMap() {
        Map values = super.buildValuesMap();
        if (this.appId != null) {
            values.put(APP_KEY, this.appId);
        }
        return values;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }
}

