/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.util;

import com.aimluck.eip.common.ALApplication;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.services.portal.ALPortalApplicationService;
import com.aimluck.eip.services.social.ALApplicationService;
import com.aimluck.eip.services.social.model.ALApplicationGetRequest;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.jetspeed.modules.actions.portlets.PortletFilter;
import org.apache.jetspeed.om.profile.IdentityElement;
import org.apache.jetspeed.om.profile.Layout;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.om.registry.PortletInfoEntry;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseCategory;
import org.apache.jetspeed.om.registry.base.BasePortletEntry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.security.PortalResource;
import org.apache.jetspeed.util.PortletSessionState;
import org.apache.jetspeed.util.ServiceUtil;
import org.apache.turbine.util.RunData;

public class CustomizeUtils {
    public static final String USER_SELECTIONS = "session.portlets.user.selections";
    public static final String UI_PORTLETS_SELECTED = "portletsSelected";
    public static final String PORTLET_LIST = "session.portlets.list";
    private static final String HIDE_EMPTY_CATEGORIES = "customizer.hide.empty.categories";
    public static final String FILTER_FIELDS = "filter_fields";
    public static final String FILTER_VALUES = "filter_values";
    public static final String REFERENCES_REMOVED = "references-removed";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CustomizeUtils.class.getName());

    public static boolean isEditable(RunData data, PortletEntry entry, String mediaType) {
        return JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"view") && !entry.isHidden() && !entry.getType().equals("abstract") && entry.hasMediaType(mediaType) && !entry.getSecurityRef().getParent().equals("admin-view");
    }

    public static List<PortletEntry> buildPortletList(RunData data, String mediaType, List<PortletEntry> allPortlets) {
        ArrayList<PortletEntry> list = new ArrayList();
        Iterator i = Registry.get((String)Registry.PORTLET).listEntryNames();
        while (i.hasNext()) {
            PortletEntry entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)((String)i.next()));
            allPortlets.add(entry);
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"view") || entry.isHidden() || entry.getType().equals("abstract") || !entry.hasMediaType(mediaType) || !ALPortalApplicationService.isActive(entry.getName()) || !CustomizeUtils.isAdminUserView(entry, data) || entry.getSecurityRef().getParent().equals("admin-view")) continue;
            list.add(entry);
        }
        ResultList<ALApplication> resultList = ALApplicationService.getList(new ALApplicationGetRequest().withStatus(ALApplicationGetRequest.Status.ACTIVE));
        for (ALApplication app : resultList) {
            BasePortletEntry entry = new BasePortletEntry();
            entry.setTitle(app.getTitle().getValue());
            entry.setDescription(app.getDescription().getValue());
            entry.setName("GadgetsTemplate::" + app.getAppId().getValue());
            entry.setParent("GadgetsTemplate");
            entry.addParameter("aid", app.getAppId().getValue());
            entry.addParameter("url", app.getUrl().getValue());
            list.add((PortletEntry)entry);
        }
        String[] filterFields = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_VALUES);
        list = PortletFilter.filterPortlets(list, (String[])filterFields, (String[])filterValues);
        Collections.sort(list, new Comparator<PortletEntry>(){

            @Override
            public int compare(PortletEntry o1, PortletEntry o2) {
                String t1 = o1.getTitle() != null ? o1.getTitle().toLowerCase() : o1.getName().toLowerCase();
                String t2 = o2.getTitle() != null ? o2.getTitle().toLowerCase() : o2.getName().toLowerCase();
                return t1.compareTo(t2);
            }
        });
        PortletSessionState.setAttribute((RunData)data, (String)PORTLET_LIST, list);
        return list;
    }

    public static List<PortletEntry> buildPortletListWithStatus(RunData data, String mediaType, List<PortletEntry> allPortlets, ALApplicationGetRequest.Status status) {
        ArrayList<PortletEntry> list = new ArrayList();
        Iterator i = Registry.get((String)Registry.PORTLET).listEntryNames();
        while (i.hasNext()) {
            PortletEntry entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)((String)i.next()));
            entry.setType("active");
            allPortlets.add(entry);
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"view") || entry.isHidden() || entry.getType().equals("abstract") || !entry.hasMediaType(mediaType) || !ALPortalApplicationService.isActive(entry.getName()) || !CustomizeUtils.isAdminUserView(entry, data) || entry.getSecurityRef().getParent().equals("admin-view") || status.equals((Object)ALApplicationGetRequest.Status.INACTIVE)) continue;
            list.add(entry);
        }
        ResultList<ALApplication> appList = ALApplicationService.getList(new ALApplicationGetRequest().withStatus(status));
        for (ALApplication app : appList) {
            BasePortletEntry entry = new BasePortletEntry();
            entry.setTitle(app.getTitle().getValue());
            entry.setDescription(app.getDescription().getValue());
            entry.setName("GadgetsTemplate::" + app.getAppId().getValue());
            entry.setParent("GadgetsTemplate");
            entry.setType(app.getStatus() == 1 ? "active" : "inactive");
            list.add((PortletEntry)entry);
        }
        String[] filterFields = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_VALUES);
        list = PortletFilter.filterPortlets(list, (String[])filterFields, (String[])filterValues);
        Collections.sort(list, new Comparator<PortletEntry>(){

            @Override
            public int compare(PortletEntry o1, PortletEntry o2) {
                String t1 = o1.getTitle() != null ? o1.getTitle().toLowerCase() : o1.getName().toLowerCase();
                String t2 = o2.getTitle() != null ? o2.getTitle().toLowerCase() : o2.getName().toLowerCase();
                return t1.compareTo(t2);
            }
        });
        PortletSessionState.setAttribute((RunData)data, (String)PORTLET_LIST, list);
        return list;
    }

    public static List<PortletEntry> buildAllPortletList(RunData data, String mediaType, List<PortletEntry> allPortlets) {
        ArrayList<PortletEntry> list = new ArrayList();
        Iterator i = Registry.get((String)Registry.PORTLET).listEntryNames();
        while (i.hasNext()) {
            PortletEntry entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)((String)i.next()));
            allPortlets.add(entry);
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"view") || entry.getType().equals("abstract") || !entry.hasMediaType(mediaType) || entry.getSecurityRef() == null || entry.getSecurityRef().getParent().equals("admin-view")) continue;
            list.add(entry);
        }
        ResultList<ALApplication> resultList = ALApplicationService.getList(new ALApplicationGetRequest().withStatus(ALApplicationGetRequest.Status.ACTIVE));
        for (ALApplication app : resultList) {
            BasePortletEntry entry = new BasePortletEntry();
            entry.setTitle(app.getTitle().getValue());
            entry.setDescription(app.getDescription().getValue());
            entry.setName("GadgetsTemplate::" + app.getAppId().getValue());
            entry.setParent("GadgetsTemplate");
            entry.addParameter("aid", app.getAppId().getValue());
            entry.addParameter("url", app.getUrl().getValue());
            list.add((PortletEntry)entry);
        }
        String[] filterFields = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_FIELDS);
        String[] filterValues = (String[])PortletSessionState.getAttribute((RunData)data, (String)FILTER_VALUES);
        list = PortletFilter.filterPortlets(list, (String[])filterFields, (String[])filterValues);
        Collections.sort(list, new Comparator<PortletEntry>(){

            @Override
            public int compare(PortletEntry o1, PortletEntry o2) {
                String t1 = o1.getTitle() != null ? o1.getTitle().toLowerCase() : o1.getName().toLowerCase();
                String t2 = o2.getTitle() != null ? o2.getTitle().toLowerCase() : o2.getName().toLowerCase();
                return t1.compareTo(t2);
            }
        });
        PortletSessionState.setAttribute((RunData)data, (String)PORTLET_LIST, list);
        return list;
    }

    public static Map<String, PortletEntry> getUserSelections(RunData data) {
        HashMap userSelections = (HashMap)PortletSessionState.getAttribute((RunData)data, (String)USER_SELECTIONS, null);
        if (userSelections == null) {
            userSelections = new HashMap();
            PortletSessionState.setAttribute((RunData)data, (String)USER_SELECTIONS, userSelections);
        }
        return userSelections;
    }

    public static List<PortletInfoEntry> buildInfoList(RunData data, String regName, String mediaType) {
        ArrayList<PortletInfoEntry> list = new ArrayList<PortletInfoEntry>();
        Iterator i = Registry.get((String)regName).listEntryNames();
        while (i.hasNext()) {
            PortletInfoEntry entry = (PortletInfoEntry)Registry.getEntry((String)regName, (String)((String)i.next()));
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"customize") || entry.isHidden() || !entry.hasMediaType(mediaType)) continue;
            list.add(entry);
        }
        Collections.sort(list, new Comparator<RegistryEntry>(){

            @Override
            public int compare(RegistryEntry o1, RegistryEntry o2) {
                String t1 = o1.getTitle() != null ? o1.getTitle() : o1.getName();
                String t2 = o2.getTitle() != null ? o2.getTitle() : o2.getName();
                return t1.compareTo(t2);
            }
        });
        return list;
    }

    public static List<RegistryEntry> buildList(RunData data, String regName) {
        ArrayList<RegistryEntry> list = new ArrayList<RegistryEntry>();
        Iterator i = Registry.get((String)regName).listEntryNames();
        while (i.hasNext()) {
            RegistryEntry entry = Registry.getEntry((String)regName, (String)((String)i.next()));
            if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource(entry), (String)"customize") || entry.isHidden()) continue;
            list.add(entry);
        }
        Collections.sort(list, new Comparator<RegistryEntry>(){

            @Override
            public int compare(RegistryEntry o1, RegistryEntry o2) {
                String t1 = o1.getTitle() != null ? o1.getTitle() : o1.getName();
                String t2 = o2.getTitle() != null ? o2.getTitle() : o2.getName();
                return t1.compareTo(t2);
            }
        });
        return list;
    }

    public static List<BaseCategory> buildCategoryList(RunData data, String mediaType, List<PortletEntry> portlets) {
        boolean hideEmpties = JetspeedResources.getBoolean((String)HIDE_EMPTY_CATEGORIES, (boolean)true);
        TreeMap<String, BaseCategory> catMap = new TreeMap<String, BaseCategory>();
        for (PortletEntry entry : portlets) {
            BaseCategory cat;
            Iterator cItr;
            if (hideEmpties) {
                if (!JetspeedSecurity.checkPermission((JetspeedUser)((JetspeedUser)data.getUser()), (PortalResource)new PortalResource((RegistryEntry)entry), (String)"view") || entry.isHidden() || entry.getType().equals("abstract") || !entry.hasMediaType(mediaType)) continue;
                cItr = entry.listCategories();
                while (cItr.hasNext()) {
                    cat = (BaseCategory)cItr.next();
                    catMap.put(cat.getName(), cat);
                }
                continue;
            }
            cItr = entry.listCategories();
            while (cItr.hasNext()) {
                cat = (BaseCategory)cItr.next();
                catMap.put(cat.getName(), cat);
            }
        }
        return new ArrayList<BaseCategory>(catMap.values());
    }

    public static List<?>[] buildColumns(Portlets set, int colNum) {
        int i;
        Iterator iterator = set.getEntriesIterator();
        int row = 0;
        int col = 0;
        int rowNum = 0;
        while (iterator.hasNext()) {
            IdentityElement identityElement = (IdentityElement)iterator.next();
            Layout layout = identityElement.getLayout();
            if (layout == null) continue;
            for (int p = 0; p < layout.getParameterCount(); ++p) {
                Parameter prop = layout.getParameter(p);
                try {
                    if (prop.getName().equals("row")) {
                        row = Integer.parseInt(prop.getValue());
                        if (row <= rowNum) continue;
                        rowNum = row;
                        continue;
                    }
                    if (!prop.getName().equals("column") || (col = Integer.parseInt(prop.getValue())) <= colNum) continue;
                    prop.setValue(String.valueOf(col % colNum));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        int sCount = set.getEntryCount() + set.getPortletsCount();
        row = sCount / colNum + 1;
        if (row > rowNum) {
            rowNum = row;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Controller customize colNum: " + colNum + " rowNum: " + rowNum));
        }
        List[] table = new List[colNum];
        List<Object> filler = Collections.nCopies(rowNum + 1, null);
        for (int i2 = 0; i2 < colNum; ++i2) {
            table[i2] = new ArrayList();
            table[i2].addAll(filler);
        }
        ArrayList<IdentityElement> work = new ArrayList<IdentityElement>();
        for (i = 0; i < set.getEntryCount(); ++i) {
            CustomizeUtils.addElement((IdentityElement)set.getEntry(i), table, work, colNum);
        }
        for (i = 0; i < set.getReferenceCount(); ++i) {
            CustomizeUtils.addElement((IdentityElement)set.getReference(i), table, work, colNum);
        }
        Iterator i3 = work.iterator();
        for (row = 0; row < rowNum; ++row) {
            for (col = 0; i3.hasNext() && col < colNum; ++col) {
                if (table[col].get(row) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Set portlet at col " + col + " row " + row));
                }
                table[col].set(row, i3.next());
            }
        }
        for (int j = 0; j < table.length; ++j) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Column " + j));
            }
            i3 = table[j].iterator();
            while (i3.hasNext()) {
                Object obj = i3.next();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Element " + obj));
                }
                if (obj != null) continue;
                i3.remove();
            }
        }
        return table;
    }

    protected static void addElement(IdentityElement element, List[] table, List<IdentityElement> work, int columnCount) {
        Layout layout = element.getLayout();
        int row = -1;
        int col = -1;
        if (layout != null) {
            try {
                for (int p = 0; p < layout.getParameterCount(); ++p) {
                    Parameter prop = layout.getParameter(p);
                    if (prop.getName().equals("row")) {
                        row = Integer.parseInt(prop.getValue());
                        continue;
                    }
                    if (!prop.getName().equals("column")) continue;
                    col = Integer.parseInt(prop.getValue());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Constraints col " + col + " row " + row));
        }
        if (row >= 0 && col >= 0 && col < columnCount) {
            table[col].add(row, element);
        } else {
            if (layout != null) {
                element.setLayout(null);
                layout = null;
            }
            work.add(element);
        }
    }

    public static boolean isAdminUserView(PortletEntry entry, RunData data) {
        JetspeedRunData jdata;
        if (data != null && (jdata = (JetspeedRunData)data).getUserId() != null && entry != null && entry.getSecurityRef() != null && entry.getSecurityRef().getParent() != null && entry.getSecurityRef().getParent().equals("admin-user-view")) {
            return ALEipUtils.isAdmin(data);
        }
        return true;
    }

    public static boolean isAdminUserView(String portletName, RunData data) {
        PortletEntry entry = null;
        try {
            entry = (PortletEntry)Registry.getEntry((String)Registry.PORTLET, (String)portletName);
        }
        catch (Exception e) {
            logger.error((Object)"CustomizeUtils.isAdminUserView", (Throwable)e);
        }
        return CustomizeUtils.isAdminUserView(entry, data);
    }

    public static boolean isAdminUserView(PortletEntry entry) {
        JetspeedRunData jData = null;
        try {
            JetspeedRunDataService jrds = (JetspeedRunDataService)ServiceUtil.getServiceByName((String)"RunDataService");
            jData = jrds.getCurrentRunData();
        }
        catch (Exception e) {
            logger.error((Object)"CustomizeUtils.isAdminUserView", (Throwable)e);
        }
        return CustomizeUtils.isAdminUserView(entry, (RunData)jData);
    }
}

