/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CellScheduleFormMemberForSelectData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CellScheduleFormMemberForSelectData.class.getName());
    private ALEipUser login_user;
    private ALCellStringField selectedgroup;
    private int rows_num = 10;
    private int start;
    private int count;
    private int pages_num = 1;
    private int current_page = 1;
    private List<ALEipUser> users;

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            action.setMode("new_form");
            this.setMode(action.getMode());
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = this.setFormData(rundata, context, msgList);
            action.setResultData((Object)this);
            action.addErrorMessages(msgList);
            action.putData(rundata, context);
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String groupname;
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"start")) {
            this.current_page = rundata.getParameters().getInt("start");
        }
        if ((groupname = rundata.getParameters().getString("selectedgroup")) != null && !"".equals(groupname)) {
            this.users = this.getUsersByGroupName(rundata.getParameters().getString("selectedgroup"));
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"selectedgroup", (String)groupname);
        } else {
            groupname = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"selectedgroup");
        }
        this.users = this.getUsersByGroupName(groupname);
        super.init(action, rundata, context);
    }

    public void loadParameters(RunData rundata, Context context) {
    }

    public void initField() {
        this.selectedgroup = new ALCellStringField();
        this.selectedgroup.setFieldName(ALLocalizationUtils.getl10n((String)"SCHEDULE_SETFIELDNAME_GROUP"));
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) throws ALDBErrorException, ALPageNotFoundException {
        return true;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALDBErrorException {
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
        boolean res = ScheduleUtils.setFormDataDelegate(rundata, context, (ALData)this, fields, msgList);
        if (!res) {
            return res;
        }
        return true;
    }

    private List<ALEipUser> getUsersByGroupName(String groupname) {
        if (groupname == null || groupname.length() == 0) {
            return new ArrayList<ALEipUser>();
        }
        if ("all".equals(groupname)) {
            groupname = "LoginUser";
        }
        List userlist = ALEipUtils.getUsers((String)groupname);
        ScheduleUtils.removeUser(userlist, this.login_user);
        int size = userlist.size();
        this.setPageParam(size);
        int start = this.getStart();
        int rowsNum = this.getRowsNum();
        int count = -1;
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        for (int i = 0; i < rowsNum && (count = i + start) < size; ++i) {
            list.add((ALEipUser)userlist.get(count));
        }
        return list;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public ALEipUser getLoginUser() {
        return this.login_user;
    }

    public ALCellStringField getSelectedGroup() {
        return this.selectedgroup;
    }

    protected void setPageParam(int cnt) {
        this.start = this.rows_num * (this.current_page - 1);
        this.count = cnt;
        this.pages_num = (int)Math.ceil((double)this.count / (double)this.rows_num);
    }

    public void setRowsNum(int num) {
        if (num >= 1) {
            this.rows_num = num;
        }
    }

    public int getRowsNum() {
        return this.rows_num;
    }

    public int getCount() {
        return this.count;
    }

    public int getPagesNum() {
        return this.pages_num;
    }

    public int getCurrentPage() {
        return this.current_page;
    }

    public int getStart() {
        return this.start;
    }

    public List<ALEipUser> getUsers() {
        return this.users;
    }
}

