/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.schedule.ScheduleOnedayContainer;
import com.aimluck.eip.schedule.ScheduleOnedayGroupSelectData;
import com.aimluck.eip.schedule.ScheduleOnedayResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleDetailOnedaySelectData
extends ScheduleOnedayGroupSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleDetailOnedaySelectData.class.getName());
    private int loginuserid;
    private ALDateTimeField view_date = null;
    private int userid = 0;
    private String type;
    private boolean hasAclviewOther = false;
    private ScheduleOnedayContainer con;

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.loginuserid = ALEipUtils.getUserId((RunData)rundata);
        this.viewtype = "detail";
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"view_date")) {
            this.view_date = new ALDateTimeField("yyyy-MM-dd");
            String tmpViewDate = rundata.getParameters().getString("view_date");
            this.view_date.setValue(tmpViewDate);
            if (!this.view_date.validate(new ArrayList())) {
                this.view_date = null;
            }
        }
        if (rundata.getParameters().containsKey((Object)"userid")) {
            String tmpid = rundata.getParameters().getString("userid");
            if (tmpid != null && tmpid.startsWith("f")) {
                this.userid = Integer.parseInt(tmpid.substring("f".length(), tmpid.length()));
                this.type = "F";
            } else {
                this.userid = rundata.getParameters().getInt("userid");
                this.type = "U";
            }
        } else if (rundata.getParameters().containsKey((Object)"facilityid")) {
            this.userid = Integer.parseInt(rundata.getParameters().getString("facilityid"));
            this.type = "F";
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclviewOther = aclhandler.hasAuthority(this.loginuserid, "schedule_other", 1);
        this.con = new ScheduleOnedayContainer();
        this.con.initField();
        this.con.initHour(0, 24);
    }

    @Override
    protected List<VEipTScheduleList> getScheduleList(RunData rundata, Context context) {
        if (this.view_date == null || this.userid <= 0) {
            return new ArrayList<VEipTScheduleList>();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.view_date.getValue());
        cal.add(5, 1);
        cal.add(14, -1);
        ALDateTimeField field = new ALDateTimeField();
        field.setValue(cal.getTime());
        ArrayList<Integer> ulist = new ArrayList<Integer>();
        if ("U".equals(this.type)) {
            ulist.add(this.userid);
        }
        ArrayList<Integer> flist = new ArrayList<Integer>();
        if ("F".equals(this.type)) {
            ulist.add(this.userid);
        }
        return ScheduleUtils.getScheduleList(this.loginuserid, this.view_date.getValue(), field.getValue(), ulist, flist);
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleOnedayResultData rd = new ScheduleOnedayResultData();
        rd.initField();
        try {
            if ("R".equals(record.getStatus())) {
                return rd;
            }
            if (!ScheduleUtils.isView(this.view_date, record.getRepeatPattern(), record.getStartDate(), record.getEndDate())) {
                return rd;
            }
            boolean is_member = record.isMember();
            if (!"D".equals(record.getStatus()) && "P".equals(record.getPublicFlag()) && this.userid != record.getUserId() && this.userid != record.getOwnerId() && !is_member) {
                return rd;
            }
            if (!this.hasAclviewOther && !is_member) {
                return rd;
            }
            if ("C".equals(record.getPublicFlag()) && this.userid != record.getUserId() && this.userid != record.getOwnerId() && !is_member) {
                rd.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
                rd.setTmpreserve(false);
            } else {
                rd.setName(record.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setLoginuser(record.getUserId() == this.userid);
            rd.setOwner(record.getOwnerId() == this.userid);
            rd.setMember(is_member);
            rd.setPattern(record.getRepeatPattern());
            if (rd.getPattern().equals("S")) {
                return rd;
            }
            if (!rd.getPattern().equals("N")) {
                if (!ScheduleUtils.isView(this.view_date, rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    return rd;
                }
                rd.setRepeat(true);
            }
            this.con.addResultData(rd, 0, 24, this.view_date);
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    public ScheduleOnedayContainer getScheduleOnedayContainer() {
        return this.con;
    }
}

