/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleSearchResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ScheduleListContainer
implements ALData {
    public static final int SCHEDULE_LIST_DATE_LIMIT = 7;
    private ALDateTimeField viewStartDate;
    private List<ScheduleResultData> scheduleList;
    private boolean isSort = false;

    public void setViewStartDate(Calendar cal) {
        this.viewStartDate.setValue(cal.getTime());
    }

    public void initField() {
        this.viewStartDate = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        this.scheduleList = new ArrayList<ScheduleResultData>();
    }

    public boolean addResultData(ScheduleSearchResultData rd) {
        this.isSort = false;
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(this.viewStartDate.getValue());
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(startDate.getTime());
        endDate.add(5, 7);
        while (startDate.before(endDate)) {
            ALDateTimeField field = new ALDateTimeField("yyyy-MM-dd-HH-mm");
            ScheduleSearchResultData addRd = new ScheduleSearchResultData();
            field.setValue(startDate.getTime());
            if (!rd.getPattern().equals("N")) {
                boolean isClone = false;
                boolean isSpan = false;
                if (rd.getPattern().equals("S") && !field.getValue().before(rd.getStartDate().getValue()) && !field.getValue().after(rd.getEndDate().getValue())) {
                    isClone = true;
                    isSpan = true;
                }
                if (!rd.getPattern().equals("S") && ScheduleUtils.isView(field, rd.getPattern(), rd.getStartDate().getValue(), rd.getEndDate().getValue())) {
                    isClone = true;
                }
                if (isClone) {
                    Calendar temp = Calendar.getInstance();
                    temp.setTime(field.getValue());
                    temp.set(10, Integer.parseInt(rd.getStartDate().getHour()));
                    temp.set(12, Integer.parseInt(rd.getStartDate().getMinute()));
                    temp.set(13, 0);
                    temp.set(14, 0);
                    Calendar temp2 = Calendar.getInstance();
                    temp2.setTime(field.getValue());
                    temp2.set(10, Integer.parseInt(rd.getEndDate().getHour()));
                    temp2.set(12, Integer.parseInt(rd.getEndDate().getMinute()));
                    temp2.set(13, 0);
                    temp2.set(14, 0);
                    addRd.initField();
                    addRd.setScheduleId((int)rd.getScheduleId().getValue());
                    addRd.setParentId((int)rd.getParentId().getValue());
                    addRd.setName(rd.getName().getValue());
                    addRd.setStartDate(temp.getTime());
                    addRd.setEndDate(temp2.getTime());
                    addRd.setTmpreserve(rd.isTmpreserve());
                    addRd.setPublic(rd.isPublic());
                    addRd.setHidden(rd.isHidden());
                    addRd.setDummy(rd.isDummy());
                    addRd.setLoginuser(rd.isLoginuser());
                    addRd.setOwner(rd.isOwner());
                    addRd.setMember(rd.isMember());
                    addRd.setType(rd.getType());
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    if (!sdf.format(rd.getStartDate().getValue()).equals(sdf.format(rd.getEndDate().getValue()))) {
                        addRd.setTerm(true);
                    }
                    addRd.setRepeat(!isSpan);
                    addRd.setPattern(rd.getPattern());
                    addRd.setCreateUser(rd.getCreateUser());
                    this.addResultDataInternal(addRd);
                }
            } else {
                this.addResultDataInternal(rd);
                return true;
            }
            startDate.add(5, 1);
        }
        return false;
    }

    protected void addResultDataInternal(ScheduleResultData rd) {
        int size = this.scheduleList.size();
        boolean canAdd = true;
        boolean repeat_del = false;
        for (int i = 0; i < size; ++i) {
            repeat_del = false;
            ScheduleResultData rd2 = this.scheduleList.get(i);
            if (rd.isRepeat() && rd2.isDummy() && rd.getScheduleId().getValue() == rd2.getParentId().getValue() && ScheduleUtils.equalsToDate(rd.getStartDate().getValue(), rd2.getStartDate().getValue(), false)) {
                canAdd = false;
                break;
            }
            if (rd2.isRepeat() && rd.isDummy() && rd2.getScheduleId().getValue() == rd.getParentId().getValue() && ScheduleUtils.equalsToDate(rd.getStartDate().getValue(), rd2.getStartDate().getValue(), false)) {
                this.scheduleList.remove(rd2);
                canAdd = true;
                repeat_del = true;
            }
            if (repeat_del || rd.isDummy() || rd2.isDummy() || rd.getPattern().equals("S") || rd2.getPattern().equals("S") || !(rd.getStartDate().getValue().before(rd2.getStartDate().getValue()) && rd2.getStartDate().getValue().before(rd.getEndDate().getValue()) || rd2.getStartDate().getValue().before(rd.getStartDate().getValue()) && rd.getStartDate().getValue().before(rd2.getEndDate().getValue()) || rd.getStartDate().getValue().before(rd2.getEndDate().getValue()) && rd2.getEndDate().getValue().before(rd.getEndDate().getValue()) || rd2.getStartDate().getValue().before(rd.getEndDate().getValue()) && rd.getEndDate().getValue().before(rd2.getEndDate().getValue())) && (!rd.getEndDate().getValue().equals(rd2.getEndDate().getValue()) || !rd.getStartDate().getValue().equals(rd2.getStartDate().getValue()))) continue;
            rd2.setDuplicate(true);
            rd.setDuplicate(true);
        }
        if (canAdd) {
            this.scheduleList.add(rd);
        }
    }

    public List<ScheduleResultData> getScheduleList() {
        if (!this.isSort) {
            Collections.sort(this.scheduleList, new Comparator<ScheduleResultData>(){

                @Override
                public int compare(ScheduleResultData a, ScheduleResultData b) {
                    Calendar cal = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    cal.setTime(a.getStartDate().getValue());
                    cal2.setTime(b.getStartDate().getValue());
                    if (cal.getTime().compareTo(cal2.getTime()) != 0) {
                        return cal.getTime().compareTo(cal2.getTime());
                    }
                    if (!a.getPattern().equals("S") && !b.getPattern().equals("S")) {
                        cal.setTime(a.getEndDate().getValue());
                        cal2.setTime(b.getEndDate().getValue());
                        return cal.getTime().compareTo(cal2.getTime());
                    }
                    if (a.getPattern().equals("S") && b.getPattern().equals("S")) {
                        if (a.isTerm()) {
                            return -1;
                        }
                        if (b.isTerm()) {
                            return 1;
                        }
                        return 0;
                    }
                    if (a.getPattern().equals("S")) {
                        return -1;
                    }
                    return 1;
                }
            });
            this.isSort = true;
        }
        ArrayList<ScheduleResultData> results = new ArrayList<ScheduleResultData>();
        for (ScheduleResultData rd : this.scheduleList) {
            if (rd.isDummy()) continue;
            results.add(rd);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String date = "";
        for (ScheduleResultData rd : this.scheduleList) {
            if (!rd.isDummy() && !date.equals(sdf.format(rd.getStartDate().getValue()))) {
                date = sdf.format(rd.getStartDate().getValue());
                rd.setDayStart(true);
                continue;
            }
            rd.setDayStart(false);
        }
        return results;
    }
}

