/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.facilities.util.FacilitiesUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.ScheduleMonthlySelectData;
import com.aimluck.eip.schedule.ScheduleSearchResultData;
import com.aimluck.eip.schedule.util.ScheduleUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleSearchSelectData
extends ScheduleMonthlySelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleSearchSelectData.class.getName());
    private static final String TARGET_GROUP_NAME_AT_SERCH = "target_group_name_at_serch";
    private final ALStringField target_keyword = new ALStringField();
    private int userid;
    private ALStringField description;
    private final String TARGET_USER_ID_AT_SERCH = "target_user_id_at_serch";

    @Override
    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.viewtype = "search";
        this.userid = ALEipUtils.getUserId((RunData)rundata);
    }

    @Override
    protected ResultList<VEipTScheduleList> selectList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        try {
            this.target_keyword.setValue(ScheduleUtils.getTargetKeyword(rundata, context));
            this.setupLists(rundata, context);
            return this.getScheduleList(rundata, context);
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleSearchSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    @Override
    protected String getTargetGroupName(RunData rundata, Context context) {
        return this.getTargetGroupName(rundata, context, TARGET_GROUP_NAME_AT_SERCH);
    }

    @Override
    protected String getTargetUserId(RunData rundata, Context context) {
        return this.getTargetUserId(rundata, context, "target_user_id_at_serch");
    }

    protected ResultList<VEipTScheduleList> getScheduleList(RunData rundata, Context context) {
        List<Integer> tmpUsers = new ArrayList();
        List<Object> tmpFacilities = new ArrayList();
        if ("all".equals(this.target_user_id)) {
            tmpUsers = ALEipUtils.getUserIds((String)this.target_group_name);
            tmpFacilities = "Facility".equals(this.target_group_name) ? this.getFacilityIdAllList() : FacilitiesUtils.getFacilityIds((String)this.target_group_name);
        } else if (this.target_user_id != null && !this.target_user_id.equals("")) {
            if (this.target_user_id.startsWith("f")) {
                String fid = this.target_user_id.substring("f".length(), this.target_user_id.length());
                tmpFacilities.add(Integer.valueOf(fid));
            } else {
                tmpUsers.add(Integer.valueOf(this.target_user_id));
            }
        } else {
            return new ResultList();
        }
        return (ResultList)ScheduleUtils.getScheduleList(this.userid, tmpUsers, tmpFacilities, this.target_keyword.getValue(), this.getCurrentPage(), this.getRowsNum());
    }

    @Override
    protected Object getResultData(VEipTScheduleList record) throws ALPageNotFoundException, ALDBErrorException {
        ScheduleSearchResultData rd = new ScheduleSearchResultData();
        rd.initField();
        try {
            if ("R".equals(record.getStatus())) {
                return null;
            }
            boolean is_member = record.isMember();
            if ("C".equals(record.getPublicFlag()) && this.userid != record.getOwnerId() && !is_member) {
                rd.setName(ALLocalizationUtils.getl10n((String)"SCHEDULE_CLOSE_PUBLIC_WORD"));
                rd.setTmpreserve(false);
            } else {
                rd.setName(record.getName());
                rd.setTmpreserve("T".equals(record.getStatus()));
            }
            rd.setScheduleId(record.getScheduleId());
            rd.setParentId(record.getParentId());
            rd.setStartDate(record.getStartDate());
            rd.setEndDate(record.getEndDate());
            rd.setPublic("O".equals(record.getPublicFlag()));
            rd.setHidden("P".equals(record.getPublicFlag()));
            rd.setDummy("D".equals(record.getStatus()));
            rd.setOwner(record.getOwnerId() == this.userid);
            rd.setMember(is_member);
            rd.setPattern(record.getRepeatPattern());
            rd.setCreateUser(ALEipUtils.getALEipUser((int)record.getCreateUserId()));
            rd.setNote(record.getNote());
            rd.setPlace(record.getPlace());
            rd.setDescription(record.getNote());
            if (!rd.getPattern().equals("N") && !rd.getPattern().equals("S")) {
                rd.setRepeat(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return null;
        }
        return rd;
    }

    private List<Integer> getFacilityIdAllList() {
        ArrayList<Integer> facilityIdAllList = new ArrayList<Integer>();
        try {
            SelectQuery query = Database.query(EipMFacility.class);
            query.select("FACILITY_ID");
            List aList = query.fetchList();
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMFacility record = (EipMFacility)aList.get(i);
                facilityIdAllList.add(record.getFacilityId());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
        }
        return facilityIdAllList;
    }

    @Override
    public String getViewtype() {
        return this.viewtype;
    }

    public ALStringField getTargetKeyword() {
        return this.target_keyword;
    }

    public void setDescription(String string) {
        this.description.setValue(string);
    }

    public boolean isLoginUserID(Long id) {
        return id == (long)this.userid;
    }
}

