/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.schedule.util;

import com.aimluck.commons.field.ALAbstractField;
import com.aimluck.commons.field.ALCellDateField;
import com.aimluck.commons.field.ALCellDateTimeField;
import com.aimluck.commons.field.ALCellStringField;
import com.aimluck.commons.field.ALDateContainer;
import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALIllegalDateException;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMFacility;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTSchedule;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.cayenne.om.portlet.VEipTScheduleList;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.schedule.AjaxScheduleResultData;
import com.aimluck.eip.schedule.AjaxTermScheduleWeekContainer;
import com.aimluck.eip.schedule.ScheduleResultData;
import com.aimluck.eip.schedule.ScheduleTermWeekContainer;
import com.aimluck.eip.schedule.ScheduleToDoResultData;
import com.aimluck.eip.schedule.ScheduleToDoWeekContainer;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.user.util.UserUtils;
import com.aimluck.eip.userfacility.beans.UserFacilityLiteBean;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.security.Principal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Ordering;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class ScheduleUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)ScheduleUtils.class.getName());
    public static final String SCHEDULEMAP_TYPE_USER = "U";
    public static final String SCHEDULEMAP_TYPE_FACILITY = "F";
    public static final String TARGET_FACILITY_ID = "f";
    public static final String MAIL_FOR_INSERT = "I";
    public static final String MAIL_FOR_UPDATE = "U";
    public static final String MAIL_FOR_DELETE = "D";
    public static final String MAIL_FOR_ALL = "A";
    public static final String MAIL_FOR_NONE = "N";
    public static final String FLAG_CHANGE_TURN_STR = "flagchangeturn";
    public static final String SCHEDULE_PORTLET_NAME = "Schedule";
    public static final String AJAX_SCHEDULE_PORTLET_NAME = "AjaxSchedule";
    public static final String SCHEDULE_ADMIN_PORTLET_NAME = "ScheduleAdmin";
    public static final String TARGET_KEYWORD = "keyword";
    public static final String FILTER_NAMESPACE = "com.aimluck.eip.schedule.filter";
    public static final String FILTER_NAMESPACE_TYPE = "com.aimluck.eip.schedule.filtertype";
    private static Map<String, String> tabToLayOut = new HashMap<String, String>();
    private static Map<String, String> LayOutTotab;

    public static String getLayoutFromTabName(String tabname) {
        return tabToLayOut.get(tabname);
    }

    public static String getTabNameFromLayout(String Layout) {
        return LayOutTotab.get(Layout);
    }

    public static EipTSchedule getEipTSchedule(RunData rundata, Context context, boolean isOwner) throws ALPageNotFoundException, ALDBErrorException {
        return ScheduleUtils.getEipTSchedule(rundata, context, isOwner, ALEipUtils.getUserId((RunData)rundata));
    }

    public static EipTSchedule getEipTSchedule(RunData rundata, int scheduleid, boolean isOwner, int userid) throws ALPageNotFoundException, ALDBErrorException {
        try {
            List schedules;
            SelectQuery query = Database.query(EipTSchedule.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)scheduleid);
            query.setQualifier(exp1);
            if (isOwner) {
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
            }
            if ((schedules = query.fetchList()) == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            EipTSchedule record = (EipTSchedule)schedules.get(0);
            SelectQuery mapquery = Database.query(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp2 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
            mapquery.andQualifier(mapexp2);
            Expression mapexp3 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
            mapquery.andQualifier(mapexp3);
            List schedulemaps = mapquery.fetchList();
            boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
            boolean is_public = "O".equals(record.getPublicFlag());
            if (!is_member && !is_public) {
                logger.error((Object)"[ScheduleUtils] Cannnot access this record. ");
                throw new ALPageNotFoundException();
            }
            return (EipTSchedule)schedules.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTSchedule getEipTSchedule(RunData rundata, Context context, boolean isOwner, int userid) throws ALPageNotFoundException, ALDBErrorException {
        String scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                throw new ALPageNotFoundException();
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"[ScheduleUtils] NumberFormatException: ENTITYID is wrong.");
            throw new ALPageNotFoundException();
        }
        try {
            List schedules;
            SelectQuery query = Database.query(EipTSchedule.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)scheduleid);
            query.setQualifier(exp1);
            if (isOwner) {
                Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.andQualifier(exp2);
            }
            if ((schedules = query.fetchList()) == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            EipTSchedule record = (EipTSchedule)schedules.get(0);
            SelectQuery mapquery = Database.query(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp21 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            Expression mapexp22 = ExpressionFactory.matchExp((String)"eipTSchedule.createUserId", (Object)ALEipUtils.getUserId((RunData)rundata));
            mapquery.andQualifier(mapexp21.orExp(mapexp22));
            List schedulemaps = mapquery.fetchList();
            boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
            int loginuser_id = ALEipUtils.getUserId((RunData)rundata);
            boolean is_owner = record.getOwnerId() == loginuser_id;
            boolean is_createuser = loginuser_id == record.getCreateUserId();
            boolean is_public = "O".equals(record.getPublicFlag());
            if (!(is_public || is_member || is_createuser || is_owner)) {
                ALEipUtils.redirectPermissionError((RunData)rundata);
            }
            return (EipTSchedule)schedules.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static boolean hasAuthorityForScheduleDetail(RunData rundata, Context context, EipTSchedule record, String type) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int userId = ALEipUtils.getUserId((RunData)rundata);
            SelectQuery mapquery = Database.query(EipTScheduleMap.class);
            Expression mapexp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)record.getScheduleId());
            mapquery.setQualifier(mapexp1);
            Expression mapexp21 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.toString(userId));
            Expression mapexp22 = ExpressionFactory.matchExp((String)"eipTSchedule.createUserId", (Object)userId);
            mapquery.andQualifier(mapexp21.orExp(mapexp22));
            Expression mapexp3 = ExpressionFactory.matchExp((String)"type", (Object)type);
            mapquery.andQualifier(mapexp3);
            List schedulemaps = mapquery.fetchList();
            boolean is_member = schedulemaps != null && schedulemaps.size() > 0;
            boolean is_owner = record.getOwnerId() == userId;
            boolean is_createuser = record.getCreateUserId() == userId;
            boolean is_public = "O".equals(record.getPublicFlag());
            return type.equals(SCHEDULEMAP_TYPE_FACILITY) || is_public || is_member || is_createuser || is_owner;
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTSchedule getEipTScheduleDetailForTooltip(RunData rundata, Context context, String type) throws ALPageNotFoundException, ALDBErrorException {
        String scheduleid = rundata.getParameters().getString("scheduleid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                return null;
            }
            SelectQuery query = Database.query(EipTSchedule.class);
            query.getQuery().setRefreshingObjects(true);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)scheduleid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTScheduleMaps.type", (Object)type);
            query.andQualifier(exp2);
            List schedules = query.fetchList();
            if (schedules == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                return null;
            }
            EipTSchedule record = (EipTSchedule)schedules.get(0);
            if (!ScheduleUtils.hasAuthorityForScheduleDetail(rundata, context, record, type)) {
                return null;
            }
            return record;
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTSchedule getEipTScheduleDetail(RunData rundata, Context context, String type) throws ALPageNotFoundException, ALDBErrorException {
        String scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                throw new ALPageNotFoundException();
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"[ScheduleUtils] NumberFormatException: ENTITYID is wrong.", (Throwable)ex);
            throw new ALPageNotFoundException();
        }
        try {
            SelectQuery query = Database.query(EipTSchedule.class);
            query.getQuery().setRefreshingObjects(true);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)scheduleid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTScheduleMaps.type", (Object)type);
            query.andQualifier(exp2);
            List schedules = query.fetchList();
            if (schedules == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            EipTSchedule record = (EipTSchedule)schedules.get(0);
            if (!ScheduleUtils.hasAuthorityForScheduleDetail(rundata, context, record, type)) {
                ALEipUtils.redirectPermissionError((RunData)rundata);
            }
            return record;
        }
        catch (ALPageNotFoundException ex) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTScheduleMap getEipTScheduleMap(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                throw new ALPageNotFoundException();
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"[ScheduleUtils] NumberFormatException: ENTITYID is wrong.", (Throwable)ex);
            throw new ALPageNotFoundException();
        }
        try {
            SelectQuery query = Database.query(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)scheduleid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            List schedules = query.fetchList();
            if (schedules == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            return (EipTScheduleMap)schedules.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<EipTScheduleMap> getEipTScheduleMaps(EipTSchedule schedule) throws ALPageNotFoundException, ALDBErrorException {
        Integer scheduleid = schedule.getScheduleId();
        try {
            SelectQuery query = Database.query(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)scheduleid);
            query.setQualifier(exp1);
            List schedules = query.fetchList();
            if (schedules == null || schedules.size() == 0) {
                logger.error((Object)"[ScheduleUtils] Not found record.");
                throw new ALPageNotFoundException();
            }
            return schedules;
        }
        catch (Exception ex) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List<ALEipUser> getUsers(RunData rundata, Context context, boolean includeLoginUser) throws ALPageNotFoundException, ALDBErrorException {
        ArrayList<ALEipUser> list = new ArrayList<ALEipUser>();
        String scheduleid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (scheduleid == null || Integer.valueOf(scheduleid) == null) {
                logger.error((Object)"[ScheduleUtils] ENTITYID is empty.");
                throw new ALPageNotFoundException();
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"[ScheduleUtils] NumberFormatException: ENTITYID is wrong.", (Throwable)ex);
            throw new ALPageNotFoundException();
        }
        try {
            SelectQuery mapquery = Database.query(EipTScheduleMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"scheduleId", (Object)Integer.valueOf(scheduleid));
            mapquery.setQualifier(exp1);
            if (!includeLoginUser) {
                Expression exp2 = ExpressionFactory.noMatchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
                mapquery.andQualifier(exp2);
            }
            List schedulemaps = mapquery.fetchList();
            ArrayList<Integer> uidlist = new ArrayList<Integer>();
            EipTScheduleMap map = null;
            int mapsize = schedulemaps.size();
            for (int i = 0; i < mapsize; ++i) {
                map = (EipTScheduleMap)schedulemaps.get(i);
                if (uidlist.contains(map.getUserId())) continue;
                uidlist.add(map.getUserId());
            }
            SelectQuery userquery = Database.query(TurbineUser.class);
            Expression userexp = ExpressionFactory.inDbExp((String)"USER_ID", uidlist);
            userquery.setQualifier(userexp);
            ArrayList<Ordering> orders = new ArrayList<Ordering>();
            orders.add(new Ordering("lastNameKana", true));
            orders.add(new Ordering("firstNameKana", true));
            userquery.getQuery().addOrderings(orders);
            List ulist = userquery.fetchList();
            for (int j = 0; j < ulist.size(); ++j) {
                TurbineUser tuser = (TurbineUser)ulist.get(j);
                ALEipUser user = new ALEipUser();
                user.initField();
                user.setUserId(tuser.getUserId().intValue());
                user.setName(tuser.getLoginName());
                user.setAliasName(tuser.getFirstName(), tuser.getLastName());
                list.add(user);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return list;
    }

    public static int[] getFacilityIds(EipTSchedule schedule) throws ALPageNotFoundException, ALDBErrorException {
        List list = schedule.getEipTScheduleMaps();
        ArrayList<Integer> flist = new ArrayList<Integer>();
        EipTScheduleMap map = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (EipTScheduleMap)list.get(i);
            if (!SCHEDULEMAP_TYPE_FACILITY.equals(map.getType())) continue;
            flist.add(map.getUserId());
        }
        int fsize = flist.size();
        int[] ids = new int[fsize];
        for (int i = 0; i < fsize; ++i) {
            ids[i] = (Integer)flist.get(i);
        }
        return ids;
    }

    public static boolean isView(ALDateTimeField date, String ptn, Date startDate, Date limitDate) {
        int count = 0;
        boolean result = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date.getValue());
        if (ptn.charAt(0) == 'D') {
            result = true;
            count = 1;
        } else if (ptn.charAt(0) == 'W') {
            int dow = cal.get(7);
            switch (dow) {
                case 1: {
                    result = ptn.charAt(1) != '0';
                    break;
                }
                case 2: {
                    result = ptn.charAt(2) != '0';
                    break;
                }
                case 3: {
                    result = ptn.charAt(3) != '0';
                    break;
                }
                case 4: {
                    result = ptn.charAt(4) != '0';
                    break;
                }
                case 5: {
                    result = ptn.charAt(5) != '0';
                    break;
                }
                case 6: {
                    result = ptn.charAt(6) != '0';
                    break;
                }
                case 7: {
                    result = ptn.charAt(7) != '0';
                    break;
                }
                default: {
                    result = false;
                }
            }
            count = 8;
        } else if (ptn.charAt(0) == 'M') {
            int mday = Integer.parseInt(ptn.substring(1, 3));
            result = Integer.parseInt(date.getDay()) == mday;
            count = 3;
        } else {
            return true;
        }
        if (result && ptn.charAt(count) == 'L') {
            result = ScheduleUtils.equalsToDate(startDate, date.getValue(), false) || ScheduleUtils.equalsToDate(limitDate, date.getValue(), false) ? true : result && startDate.before(cal.getTime()) && limitDate.after(cal.getTime());
        }
        return result;
    }

    public static String getPortletURIinPersonalConfigPane(RunData rundata, String portletEntryName) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId() + "," + entries[j].getId()).addQueryData("action", "controls.Restore");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getPortletURItoTodoDetailPane(RunData rundata, String portletEntryName, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoModePane(rundata, portletEntryName, entityid, schedulePortletId, "detail");
    }

    public static String getPortletURItoTodoPublicDetailPane(RunData rundata, String portletEntryName, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoModePane(rundata, portletEntryName, entityid, schedulePortletId, "public_detail");
    }

    public static String getPortletURItoTodoModePane(RunData rundata, String portletEntryName, long entityid, String schedulePortletId, String mode) {
        if (mode == null || "".equals(mode)) {
            return null;
        }
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId()).addPathInfo("js_peid", entries[j].getId()).addQueryData("action", "controls.Maximize").addQueryData("mode", mode).addQueryData("entityid", entityid).addQueryData("sch", schedulePortletId);
                    int jmode = ((JetspeedRunData)rundata).getMode();
                    if (jmode == 2) {
                        duri.addQueryData("prev", 2);
                    } else {
                        duri.addQueryData("prev", 0);
                    }
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static String getPortletURItoTodoDetailPaneForCell(RunData rundata, String portletEntryName, long entityid, String schedulePortletId) {
        return ScheduleUtils.getPortletURItoTodoModePaneForCell(rundata, portletEntryName, entityid, schedulePortletId, "detail");
    }

    public static String getPortletURItoTodoModePaneForCell(RunData rundata, String portletEntryName, long entityid, String schedulePortletId, String mode) {
        if (mode == null || "".equals(mode)) {
            return null;
        }
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Entry[] entries = portlets.getEntriesArray();
            if (entries == null || entries.length <= 0) {
                return null;
            }
            int ent_length = entries.length;
            for (int j = 0; j < ent_length; ++j) {
                if (!entries[j].getParent().equals(portletEntryName)) continue;
                JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                duri = duri.addPathInfo("js_peid", entries[j].getId()).addQueryData("action", "controls.Maximize").addQueryData("mode", mode).addQueryData("entityid", entityid).addQueryData("sch", schedulePortletId);
                return duri.toString();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return null;
        }
        return null;
    }

    public static boolean equalsToDate(Date date1, Date date2, boolean checkTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int date1Year = cal.get(1);
        int date1Month = cal.get(2) + 1;
        int date1Day = cal.get(5);
        int date1Hour = cal.get(10);
        int date1Minute = cal.get(12);
        cal.setTime(date2);
        int date2Year = cal.get(1);
        int date2Month = cal.get(2) + 1;
        int date2Day = cal.get(5);
        int date2Hour = cal.get(10);
        int date2Minute = cal.get(12);
        return checkTime ? date1Year == date2Year && date1Month == date2Month && date1Day == date2Day && date1Hour == date2Hour && date1Minute == date2Minute : date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }

    public static int compareToDate(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int date1Year = cal.get(1);
        int date1Month = cal.get(2) + 1;
        int date1Day = cal.get(5);
        cal.setTime(date2);
        int date2Year = cal.get(1);
        int date2Month = cal.get(2) + 1;
        int date2Day = cal.get(5);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day) {
            return 0;
        }
        if (date1Year < date2Year) {
            return 1;
        }
        if (date2Year > date1Year) {
            return -1;
        }
        if (date1Month < date2Month) {
            return 1;
        }
        if (date2Month > date1Month) {
            return -1;
        }
        if (date1Day < date2Day) {
            return 1;
        }
        return -1;
    }

    public static int compareTime(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int date1Hour = cal.get(11);
        int date1Minute = cal.get(12);
        cal.setTime(date2);
        int date2Hour = cal.get(11);
        int date2Minute = cal.get(12);
        if (date1Hour == date2Hour && date1Minute == date2Minute) {
            return 0;
        }
        if (date1Hour < date2Hour) {
            return 1;
        }
        if (date1Hour > date2Hour) {
            return -1;
        }
        if (date1Minute < date2Minute) {
            return 1;
        }
        return -1;
    }

    public static void insertDummySchedule(EipTSchedule schedule, int ownerid, Date startDate, Date endDate, int[] memberIdList, int[] facilityIdList) throws ALDBErrorException {
        EipTSchedule dummySchedule = (EipTSchedule)Database.create(EipTSchedule.class);
        dummySchedule.setParentId(schedule.getScheduleId());
        dummySchedule.setName("dummy");
        dummySchedule.setPlace("");
        dummySchedule.setNote("");
        dummySchedule.setPublicFlag("P");
        dummySchedule.setEditFlag(SCHEDULEMAP_TYPE_FACILITY);
        dummySchedule.setOwnerId(Integer.valueOf(ownerid));
        Date now2 = new Date();
        dummySchedule.setCreateDate(now2);
        dummySchedule.setCreateUserId(Integer.valueOf(ownerid));
        dummySchedule.setUpdateDate(now2);
        dummySchedule.setUpdateUserId(Integer.valueOf(ownerid));
        dummySchedule.setRepeatPattern(MAIL_FOR_NONE);
        dummySchedule.setStartDate(startDate);
        dummySchedule.setEndDate(endDate);
        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)1L);
        int size = memberIdList.length;
        for (int i = 0; i < size; ++i) {
            EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
            int userid = memberIdList[i];
            map.setEipTSchedule(dummySchedule);
            map.setUserId(Integer.valueOf(userid));
            map.setStatus(MAIL_FOR_DELETE);
            map.setType("U");
            map.setCommonCategoryId(Integer.valueOf(1));
            map.setEipTCommonCategory(category);
        }
        if (facilityIdList != null && facilityIdList.length > 0) {
            int fsize = facilityIdList.length;
            for (int i = 0; i < fsize; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                int fid = facilityIdList[i];
                map.setEipTSchedule(dummySchedule);
                map.setUserId(Integer.valueOf(fid));
                map.setStatus(MAIL_FOR_DELETE);
                map.setType(SCHEDULEMAP_TYPE_FACILITY);
                map.setCommonCategoryId(Integer.valueOf(1));
                map.setEipTCommonCategory(category);
            }
        }
        Database.commit();
    }

    public static void insertDummySchedule(EipTSchedule schedule, int ownerid, Date startDate, Date endDate, int[] memberIdList) throws ALDBErrorException {
        EipTSchedule dummySchedule = (EipTSchedule)Database.create(EipTSchedule.class);
        dummySchedule.setParentId(schedule.getScheduleId());
        dummySchedule.setName("dummy");
        dummySchedule.setPlace("");
        dummySchedule.setNote("");
        dummySchedule.setPublicFlag("P");
        dummySchedule.setEditFlag(SCHEDULEMAP_TYPE_FACILITY);
        dummySchedule.setOwnerId(Integer.valueOf(ownerid));
        Date now2 = new Date();
        dummySchedule.setCreateDate(now2);
        dummySchedule.setCreateUserId(Integer.valueOf(ownerid));
        dummySchedule.setUpdateDate(now2);
        dummySchedule.setUpdateUserId(Integer.valueOf(ownerid));
        dummySchedule.setRepeatPattern(MAIL_FOR_NONE);
        dummySchedule.setStartDate(startDate);
        dummySchedule.setEndDate(endDate);
        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)1L);
        int size = memberIdList.length;
        for (int i = 0; i < size; ++i) {
            EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
            int userid = memberIdList[i];
            map.setEipTSchedule(dummySchedule);
            map.setUserId(Integer.valueOf(userid));
            map.setStatus(MAIL_FOR_DELETE);
            map.setType("U");
            map.setCommonCategoryId(Integer.valueOf(1));
            map.setEipTCommonCategory(category);
        }
        Database.commit();
    }

    public static void insertDummySchedule(EipTSchedule schedule, int ownerid, Date startDate, Date endDate, List<Integer> memberIdList, List<Integer> facilityIdList) throws ALDBErrorException {
        EipTSchedule dummySchedule = (EipTSchedule)Database.create(EipTSchedule.class);
        dummySchedule.setParentId(schedule.getScheduleId());
        dummySchedule.setName("dummy");
        dummySchedule.setPlace("");
        dummySchedule.setNote("");
        dummySchedule.setPublicFlag("P");
        dummySchedule.setEditFlag(SCHEDULEMAP_TYPE_FACILITY);
        dummySchedule.setOwnerId(Integer.valueOf(ownerid));
        Date now2 = new Date();
        dummySchedule.setCreateDate(now2);
        dummySchedule.setCreateUserId(Integer.valueOf(ownerid));
        dummySchedule.setUpdateDate(now2);
        dummySchedule.setUpdateUserId(Integer.valueOf(ownerid));
        dummySchedule.setRepeatPattern(MAIL_FOR_NONE);
        dummySchedule.setStartDate(startDate);
        dummySchedule.setEndDate(endDate);
        EipTCommonCategory category = CommonCategoryUtils.getEipTCommonCategory((Long)1L);
        int size = memberIdList.size();
        for (int i = 0; i < size; ++i) {
            EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
            int userid = memberIdList.get(i);
            map.setEipTSchedule(dummySchedule);
            map.setUserId(Integer.valueOf(userid));
            map.setStatus(MAIL_FOR_DELETE);
            map.setType("U");
            map.setCommonCategoryId(Integer.valueOf(1));
            map.setEipTCommonCategory(category);
        }
        if (facilityIdList != null) {
            int fsize = facilityIdList.size();
            for (int i = 0; i < fsize; ++i) {
                EipTScheduleMap map = (EipTScheduleMap)Database.create(EipTScheduleMap.class);
                int fid = facilityIdList.get(i);
                map.setEipTSchedule(dummySchedule);
                map.setUserId(Integer.valueOf(fid));
                map.setStatus(MAIL_FOR_DELETE);
                map.setType(SCHEDULEMAP_TYPE_FACILITY);
                map.setCommonCategoryId(Integer.valueOf(1));
                map.setEipTCommonCategory(category);
            }
        }
        Database.commit();
    }

    public static void sortByTime(List<VEipTScheduleList> list) {
        Collections.sort(list, new Comparator<VEipTScheduleList>(){
            private final Calendar cal = Calendar.getInstance();

            @Override
            public int compare(VEipTScheduleList o1, VEipTScheduleList o2) {
                this.cal.setTime(o1.getStartDate());
                int hour1 = this.cal.get(11);
                int minute1 = this.cal.get(12);
                this.cal.setTime(o2.getStartDate());
                int hour2 = this.cal.get(11);
                int minute2 = this.cal.get(12);
                if (hour1 != hour2) {
                    return hour1 - hour2;
                }
                if (minute1 != minute2) {
                    return minute1 - minute2;
                }
                this.cal.setTime(o1.getEndDate());
                hour1 = this.cal.get(11);
                minute1 = this.cal.get(12);
                this.cal.setTime(o2.getEndDate());
                hour2 = this.cal.get(11);
                minute2 = this.cal.get(12);
                if (hour1 != hour2) {
                    return hour1 - hour2;
                }
                if (minute1 != minute2) {
                    return minute1 - minute2;
                }
                return 0;
            }
        });
    }

    public static List<VEipTScheduleList> sortByDummySchedule(List<VEipTScheduleList> list) {
        ArrayList<VEipTScheduleList> dummyList = new ArrayList<VEipTScheduleList>();
        ArrayList<VEipTScheduleList> normalList = new ArrayList<VEipTScheduleList>();
        for (VEipTScheduleList scheduleMap : list) {
            if (MAIL_FOR_DELETE.equals(scheduleMap.getStatus())) {
                dummyList.add(scheduleMap);
                continue;
            }
            normalList.add(scheduleMap);
        }
        ArrayList<VEipTScheduleList> newList = new ArrayList<VEipTScheduleList>();
        newList.addAll(dummyList);
        newList.addAll(normalList);
        return newList;
    }

    public static boolean validateTabName(String tab_name) {
        if (tab_name == null) {
            return false;
        }
        return "calendar".equals(tab_name) || "oneday".equals(tab_name) || "weekly".equals(tab_name) || "monthly".equals(tab_name) || "oneday-group".equals(tab_name) || "weekly-group".equals(tab_name) || "list".equals(tab_name) || "search".equals(tab_name);
    }

    public static String getCurrentTab(RunData rundata, Context context) {
        String currentTab;
        String tmpCurrentTab;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"tab")) {
            String tab = rundata.getParameters().getString("tab");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tab);
        }
        if (!ScheduleUtils.validateTabName(tmpCurrentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab"))) {
            VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
            currentTab = portlet.getPortletConfig().getInitParameter("pba-template");
        } else {
            currentTab = tmpCurrentTab;
        }
        return currentTab;
    }

    public static String translateDate(Date date, String dateFormat) {
        if (date == null) {
            return "Unknown";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    public static boolean includeWeek(int selectedWeek, int startWeek, int endWeek) {
        if (startWeek <= endWeek) {
            return startWeek <= selectedWeek && selectedWeek <= endWeek;
        }
        return selectedWeek >= startWeek || endWeek >= selectedWeek;
    }

    public static boolean isContains(List<Integer> memberIdList, int userId) {
        int size = memberIdList.size();
        Integer tmpInt = null;
        for (int i = 0; i < size; ++i) {
            tmpInt = memberIdList.get(i);
            if (userId != tmpInt) continue;
            return true;
        }
        return false;
    }

    public static boolean isContains(List<ALEipUser> memberList, ALEipUser user) {
        int size = memberList.size();
        long userid = user.getUserId().getValue();
        ALEipUser member = null;
        for (int i = 0; i < size; ++i) {
            member = memberList.get(i);
            if (member.getUserId().getValue() != userid) continue;
            return true;
        }
        return false;
    }

    public static boolean removeUser(List<ALEipUser> memberList, ALEipUser user) {
        if (memberList == null || memberList.size() == 0 || user == null) {
            return false;
        }
        int index = -1;
        int size = memberList.size();
        long userid = user.getUserId().getValue();
        ALEipUser member = null;
        for (int i = 0; i < size; ++i) {
            member = memberList.get(i);
            if (member.getUserId().getValue() != userid) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            memberList.remove(index);
            return true;
        }
        return false;
    }

    public static EipTScheduleMap getScheduleMap(List<EipTScheduleMap> scheduleMaps, int userid) {
        EipTScheduleMap map = null;
        int size = scheduleMaps.size();
        for (int i = 0; i < size; ++i) {
            map = scheduleMaps.get(i);
            if (map.getUserId() != userid) continue;
            return map;
        }
        return null;
    }

    public static boolean setFormDataDelegate(RunData rundata, Context context, ALData formdata, Field[] fields, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        if (fields == null || fields.length == 0) {
            return false;
        }
        boolean res = false;
        try {
            String FORMAT_DATE = "yyyyMMdd";
            String FORMAT_TIME = "HHmm";
            int FORMAT_DATE_LEN = FORMAT_DATE.length();
            int FORMAT_TIME_LEN = FORMAT_TIME.length();
            int length = fields.length;
            for (int i = 0; i < length; ++i) {
                ALCellDateField field;
                fields[i].setAccessible(true);
                String name = fields[i].getName();
                Object obj = fields[i].get(formdata);
                if (obj instanceof ALCellDateTimeField) {
                    String dateString = new StringBuffer().append(name).append("_date").toString();
                    String timeString = new StringBuffer().append(name).append("_time").toString();
                    ALCellDateTimeField field2 = (ALCellDateTimeField)obj;
                    String dateStr = null;
                    String timeStr = null;
                    Calendar cal = Calendar.getInstance();
                    if (!rundata.getParameters().containsKey((Object)dateString)) continue;
                    dateStr = rundata.getParameters().getString(dateString);
                    if (!rundata.getParameters().containsKey((Object)timeString)) continue;
                    timeStr = rundata.getParameters().getString(timeString);
                    if (dateStr.length() != FORMAT_DATE_LEN) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_DAY"));
                        continue;
                    }
                    if (timeStr.length() != FORMAT_TIME_LEN) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_TIME"));
                        continue;
                    }
                    ArrayList tmpList = new ArrayList();
                    ALCellStringField sf = new ALCellStringField(dateStr);
                    sf.setTrim(true);
                    sf.setCharacterType(2);
                    sf.setValue(dateStr);
                    sf.validate(tmpList);
                    if (tmpList.size() != 0) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_DAY"));
                        continue;
                    }
                    sf = new ALCellStringField(timeStr);
                    sf.setTrim(true);
                    sf.setCharacterType(2);
                    sf.setValue(timeStr);
                    sf.validate(tmpList);
                    if (tmpList.size() != 0) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_TIME"));
                        continue;
                    }
                    Date date = null;
                    SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
                    sdf.setLenient(false);
                    sdf.setTimeZone(TimeZone.getDefault());
                    if (dateStr.equals("")) continue;
                    try {
                        date = sdf.parse(dateStr);
                    }
                    catch (Exception e) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_DAY"));
                        continue;
                    }
                    Date time = null;
                    SimpleDateFormat sdf2 = new SimpleDateFormat(FORMAT_TIME);
                    sdf2.setLenient(false);
                    sdf2.setTimeZone(TimeZone.getDefault());
                    if (timeStr.equals("")) continue;
                    try {
                        time = sdf2.parse(timeStr);
                    }
                    catch (Exception e) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_TIME"));
                        continue;
                    }
                    Calendar cal2 = Calendar.getInstance();
                    cal2.setTime(time);
                    cal.setLenient(false);
                    cal.setTime(date);
                    cal.set(11, cal2.get(11));
                    cal.set(12, cal2.get(12));
                    cal.set(13, 0);
                    cal.set(14, 0);
                    field2.setValue(cal.getTime());
                    continue;
                }
                if (obj instanceof ALCellDateField) {
                    field = (ALCellDateField)obj;
                    Date date = null;
                    ALDateContainer con = new ALDateContainer();
                    String dateString = new StringBuffer().append(name).toString();
                    String dateStr = null;
                    if (!rundata.getParameters().containsKey((Object)name)) continue;
                    dateStr = rundata.getParameters().getString(dateString);
                    if (dateStr.length() != FORMAT_DATE_LEN) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_DAY"));
                        continue;
                    }
                    ArrayList tmpList = new ArrayList();
                    ALCellStringField sf = new ALCellStringField(dateStr);
                    sf.setTrim(true);
                    sf.setCharacterType(2);
                    sf.setValue(dateStr);
                    sf.validate(tmpList);
                    if (tmpList.size() != 0) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_DAY"));
                        continue;
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
                    sdf.setLenient(false);
                    sdf.setTimeZone(TimeZone.getDefault());
                    try {
                        date = sdf.parse(dateStr);
                    }
                    catch (Exception e) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_NON_DAY"));
                        continue;
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setLenient(false);
                    cal.setTime(date);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    con.setYear(cal.get(1));
                    con.setMonth(cal.get(2) + 1);
                    con.setDay(cal.get(5));
                    field.setValue(con);
                    continue;
                }
                if (!(obj instanceof ALAbstractField)) continue;
                field = (ALAbstractField)obj;
                if (!rundata.getParameters().containsKey((Object)name)) continue;
                field.setValue(rundata.getParameters().getString(name));
            }
            res = true;
        }
        catch (RuntimeException e) {
            logger.error((Object)"schedule", (Throwable)e);
            return false;
        }
        catch (Exception ex) {
            logger.error((Object)"schedule", (Throwable)ex);
            return false;
        }
        return res;
    }

    public static void loadParametersDelegate(RunData rundata, Context context, String tmpStart, String tmpEnd, String tmpView) {
        ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd-HH-mm");
        dummy.setNotNull(true);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            Calendar cal = Calendar.getInstance();
            int min = cal.get(12);
            if (min <= 15) {
                cal.set(12, 15);
            } else if (min <= 30) {
                cal.set(12, 30);
            } else if (min <= 45) {
                cal.set(12, 45);
            } else {
                cal.set(12, 60);
            }
            Date now = cal.getTime();
            if (rundata.getParameters().containsKey((Object)"form_start")) {
                tmpStart = rundata.getParameters().getString("form_start");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)tmpStart);
                dummy.setValue(tmpStart);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_start");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_end");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else {
                dummy.setValue(now);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpStart", (String)dummy.toString());
            }
            if (rundata.getParameters().containsKey((Object)"form_end")) {
                tmpEnd = rundata.getParameters().getString("form_end");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)tmpEnd);
                dummy.setValue(tmpEnd);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_start");
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"form_end");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else {
                dummy.setValue(now);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpEnd", (String)dummy.toString());
            }
        }
        tmpStart = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tmpStart");
        ScheduleUtils.loadParametersViewDate(rundata, context, tmpStart, tmpView);
    }

    public static void loadParametersViewDate(RunData rundata, Context context, String tmpStart, String tmpView) {
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            if (rundata.getParameters().containsKey((Object)"view_date")) {
                ALDateTimeField dummy = new ALDateTimeField("yyyy-MM-dd");
                tmpView = rundata.getParameters().getString("view_date");
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)tmpView);
                dummy.setValue(tmpView);
                if (!dummy.validate(new ArrayList())) {
                    ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"tmpView");
                    logger.debug((Object)"[ScheduleFormData] Parameter cannot validate");
                    ALEipUtils.redirectPageNotFound((RunData)rundata);
                    return;
                }
            } else if ((tmpView == null || tmpView.equals("")) && tmpStart != null && !tmpStart.equals("")) {
                tmpView = tmpStart;
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tmpView", (String)tmpView);
            }
        }
    }

    public static boolean validateDelegate(ALDateTimeField start_date, ALDateTimeField end_date, ALStringField repeat_type, boolean is_repeat, boolean is_span, ALStringField week_0, ALStringField week_1, ALStringField week_2, ALStringField week_3, ALStringField week_4, ALStringField week_5, ALStringField week_6, ALStringField limit_flag, ALDateField limit_start_date, ALDateField limit_end_date, ALNumberField month_day, ALEipUser login_user, String entityid, List<String> msgList, boolean isCellPhone) throws ALDBErrorException, ALPageNotFoundException {
        int YEAR_FIRST = 2004;
        int YEAR_END = 2016;
        if (end_date == null) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_TYPE_RIGHT_END_DATE"));
            end_date = start_date;
        }
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(start_date.getValue());
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(end_date.getValue());
        if (is_repeat) {
            Calendar tmp_end_date = Calendar.getInstance();
            tmp_end_date.set(1, Integer.valueOf(start_date.getYear()));
            tmp_end_date.set(2, Integer.valueOf(start_date.getMonth()) - 1);
            tmp_end_date.set(5, Integer.valueOf(start_date.getDay()));
            tmp_end_date.set(11, Integer.valueOf(end_date.getHour()));
            tmp_end_date.set(12, Integer.valueOf(end_date.getMinute()));
            tmp_end_date.set(13, 0);
            end_date.setValue(tmp_end_date.getTime());
        }
        if (is_span) {
            Calendar tmp_start_date = Calendar.getInstance();
            tmp_start_date.setTime(start_date.getValue());
            tmp_start_date.set(11, 0);
            tmp_start_date.set(12, 0);
            tmp_start_date.set(13, 0);
            start_date.setValue(tmp_start_date.getTime());
            Calendar tmp_end_date = Calendar.getInstance();
            tmp_end_date.setTime(end_date.getValue());
            tmp_end_date.set(11, 0);
            tmp_end_date.set(12, 0);
            tmp_end_date.set(13, 0);
            end_date.setValue(tmp_end_date.getTime());
        }
        start_date.validate(msgList);
        int startyear = startDate.get(1);
        if ((startyear < YEAR_FIRST || startyear > YEAR_END) && isCellPhone) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_MESSAGE_SELECT_RIGHT_START_DATE", (Object[])new Object[]{YEAR_FIRST, YEAR_END}));
        }
        if ((double)startDate.get(12) % 15.0 != 0.0 && isCellPhone) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_SELECT_START_TIME_PER15"));
        }
        end_date.validate(msgList);
        int endyear = endDate.get(1);
        if ((endyear < YEAR_FIRST || endyear > YEAR_END) && isCellPhone) {
            msgList.add(ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_MESSAGE_SELECT_RIGHT_START_END_DATE", (Object[])new Object[]{YEAR_FIRST, YEAR_END}));
        }
        if ((double)endDate.get(12) % 15.0 != 0.0 && isCellPhone) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_SELECT_END_TIME_PER15"));
        }
        if (end_date.getValue().before(start_date.getValue())) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_SELECT_END_DATE_TO_START_DATE"));
        }
        if (is_repeat) {
            try {
                if ("W".equals(repeat_type.getValue())) {
                    if (week_0.getValue() == null && week_1.getValue() == null && week_2.getValue() == null && week_3.getValue() == null && week_4.getValue() == null && week_5.getValue() == null && week_6.getValue() == null) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_SELECT_EVERY_WEEKLY"));
                    }
                } else if ("M".equals(repeat_type.getValue())) {
                    if (month_day.getValue() == 0L && isCellPhone) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_SELECT_EVERY_MONTHLY"));
                    } else {
                        month_day.validate(msgList);
                    }
                }
                if ("ON".equals(limit_flag.getValue())) {
                    String repeat_pattern;
                    if (!ScheduleUtils.equalsToDate(limit_start_date.getValue().getDate(), limit_end_date.getValue().getDate(), false) && limit_start_date.getValue().getDate().after(limit_end_date.getValue().getDate())) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_SELECT_REPEAT_END_DAY_TO_START_DAY"));
                    }
                    if (isCellPhone) {
                        Calendar limitStartDate = Calendar.getInstance();
                        limitStartDate.setTime(limit_start_date.getValue().getDate());
                        int limitstartyear = limitStartDate.get(1);
                        if (limitstartyear < YEAR_FIRST || limitstartyear > YEAR_END) {
                            msgList.add(ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_MESSAGE_SELECT_START_DATE_IN_THIS_TERM", (Object[])new Object[]{YEAR_FIRST, YEAR_END}));
                        }
                        Calendar limitEndDate = Calendar.getInstance();
                        limitEndDate.setTime(limit_end_date.getValue().getDate());
                        int limitendyear = limitEndDate.get(1);
                        if (limitendyear < YEAR_FIRST || limitendyear > YEAR_END) {
                            msgList.add(ALLocalizationUtils.getl10nFormat((String)"SCHEDULE_MESSAGE_SELECT_END_DATE_IN_THIS_TERM", (Object[])new Object[]{YEAR_FIRST, YEAR_END}));
                        }
                    }
                    char lim = 'N';
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(end_date.getValue());
                    if ("ON".equals(limit_flag.getValue())) {
                        lim = 'L';
                    }
                    int date_count = 0;
                    if (MAIL_FOR_DELETE.equals(repeat_type.getValue())) {
                        repeat_pattern = new StringBuffer().append('D').append(lim).toString();
                    } else if ("W".equals(repeat_type.getValue())) {
                        repeat_pattern = new StringBuffer().append('W').append(week_0.getValue() != null ? 1 : 0).append(week_1.getValue() != null ? 1 : 0).append(week_2.getValue() != null ? 1 : 0).append(week_3.getValue() != null ? 1 : 0).append(week_4.getValue() != null ? 1 : 0).append(week_5.getValue() != null ? 1 : 0).append(week_6.getValue() != null ? 1 : 0).append(lim).toString();
                        date_count = (week_0.getValue() != null ? 1 : 0) + (week_1.getValue() != null ? 1 : 0) + (week_2.getValue() != null ? 1 : 0) + (week_3.getValue() != null ? 1 : 0) + (week_4.getValue() != null ? 1 : 0) + (week_5.getValue() != null ? 1 : 0) + (week_6.getValue() != null ? 1 : 0);
                    } else {
                        DecimalFormat format = new DecimalFormat("00");
                        repeat_pattern = new StringBuffer().append('M').append(format.format(month_day.getValue())).append(lim).toString();
                        date_count = 1;
                    }
                    GregorianCalendar sDate = new GregorianCalendar();
                    sDate.set(1, Integer.valueOf(limit_start_date.getYear()));
                    sDate.set(2, Integer.valueOf(limit_start_date.getMonth()) - 1);
                    sDate.set(5, Integer.valueOf(limit_start_date.getDay()));
                    sDate.set(11, 0);
                    sDate.set(12, 0);
                    sDate.set(13, 0);
                    GregorianCalendar finalDate = new GregorianCalendar();
                    finalDate.set(1, Integer.valueOf(limit_end_date.getYear()));
                    finalDate.set(2, Integer.valueOf(limit_end_date.getMonth()) - 1);
                    finalDate.set(5, Integer.valueOf(limit_end_date.getDay()));
                    finalDate.set(11, 23);
                    finalDate.set(12, 59);
                    finalDate.set(13, 59);
                    int countAvailableDate = 0;
                    while (!(!sDate.before(finalDate) && !((Calendar)sDate).equals(finalDate) || ScheduleUtils.matchDay(sDate, repeat_pattern) && ++countAvailableDate >= date_count)) {
                        ((Calendar)sDate).add(5, 1);
                    }
                    if (countAvailableDate < date_count) {
                        msgList.add(ALLocalizationUtils.getl10n((String)"SCHEDULE_MESSAGE_SELECT_REPEAT_SPAN_IN_THIS_TERM"));
                    }
                }
            }
            catch (NumberFormatException nfe) {
                logger.error((Object)"[ScheduleFormData] NumberFormatException: Limit Date is wrong.");
                throw new ALPageNotFoundException();
            }
            catch (ALIllegalDateException ad) {
                logger.error((Object)"[ScheduleFormData] ALIllegalDateException: Limit Date is wrong.");
                throw new ALPageNotFoundException();
            }
        }
        return msgList.size() == 0;
    }

    public static void addToDo(List<ScheduleToDoWeekContainer> weekConList, Date viewStartDate, int index, ScheduleToDoResultData rd) {
        try {
            boolean success = false;
            if (weekConList.size() > 0) {
                ScheduleToDoWeekContainer tmpWeekCon = null;
                int size = weekConList.size();
                for (int i = 0; i < size; ++i) {
                    tmpWeekCon = weekConList.get(i);
                    success = tmpWeekCon.canAddTodo(rd);
                    if (!success) continue;
                    tmpWeekCon.addToDoResultData(index, rd);
                    break;
                }
            }
            if (!success) {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(viewStartDate);
                ScheduleToDoWeekContainer weekCon = new ScheduleToDoWeekContainer();
                weekCon.initField();
                weekCon.setViewStartDate(cal2);
                weekCon.addToDoResultData(index, rd);
                weekConList.add(weekCon);
            }
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
        }
    }

    public static boolean isZeroLength(String[] strs) {
        if (strs == null || strs.length <= 0) {
            return true;
        }
        int len = strs.length;
        for (int i = 0; i < len; ++i) {
            if (strs[i] != null && !"".equals(strs[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpanDuplicate(int user_id, Date start_date, Date end_date, Integer update_id) {
        List list;
        SelectQuery query = Database.query(EipTScheduleMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)user_id);
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.greaterOrEqualExp((String)"eipTSchedule.endDate", (Object)start_date);
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)end_date);
        query.andQualifier(exp3);
        Expression exp4 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)"S");
        query.andQualifier(exp4);
        if (update_id != null) {
            Expression mapexp = ExpressionFactory.noMatchExp((String)"scheduleId", (Object)update_id);
            query.andQualifier(mapexp);
        }
        int count = (list = query.fetchList()) != null && list.size() > 0 ? list.size() : 0;
        return count > 0;
    }

    public static List<ALEipUser> getALEipUsers(String[] ids) throws ALDBErrorException {
        int ids_len = ids.length;
        Integer tmp_id = null;
        ArrayList<Integer> tmp_ids = new ArrayList<Integer>();
        for (int i = 0; i < ids_len; ++i) {
            try {
                tmp_id = Integer.valueOf(ids[i]);
                if (tmp_id <= 3) continue;
                tmp_ids.add(tmp_id);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", tmp_ids);
        List users = Database.query(TurbineUser.class, (Expression)exp).fetchList();
        if (users.size() == 0) {
            return null;
        }
        ArrayList<ALEipUser> uList = new ArrayList<ALEipUser>();
        TurbineUser tuser = null;
        ALEipUser user = null;
        int len = users.size();
        for (int i = 0; i < len; ++i) {
            tuser = (TurbineUser)users.get(i);
            user = new ALEipUser();
            user.initField();
            user.setUserId(tuser.getUserId().intValue());
            user.setName(tuser.getLoginName());
            user.setAliasName(tuser.getFirstName(), tuser.getLastName());
            uList.add(user);
        }
        return uList;
    }

    public static List<UserFacilityLiteBean> getALEipUserFacility(String[] ids, RunData rundata) throws ALDBErrorException {
        ArrayList<UserFacilityLiteBean> ulist = new ArrayList<UserFacilityLiteBean>();
        int ids_len = ids.length;
        Integer tmp_id = null;
        ArrayList<Integer> tmp_ids = new ArrayList<Integer>();
        ArrayList<String> f_ids = new ArrayList<String>();
        for (int i = 0; i < ids_len; ++i) {
            if (ids[i].startsWith(TARGET_FACILITY_ID)) {
                f_ids.add(ids[i].replace(TARGET_FACILITY_ID, ""));
                continue;
            }
            try {
                tmp_id = Integer.valueOf(ids[i]);
                if (tmp_id <= 3) continue;
                tmp_ids.add(tmp_id);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        UserFacilityLiteBean user = null;
        if (tmp_ids != null && tmp_ids.size() > 0) {
            StringBuffer tmp_ids_str = new StringBuffer();
            int tmp_ids_len = tmp_ids.size() - 1;
            for (int i = 0; i < tmp_ids_len; ++i) {
                tmp_ids_str.append(tmp_ids.get(i)).append(",");
            }
            tmp_ids_str.append(tmp_ids.get(tmp_ids_len));
            StringBuffer statement = new StringBuffer();
            statement.append("SELECT DISTINCT ");
            statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
            statement.append("FROM turbine_user_group_role as A ");
            statement.append("LEFT JOIN turbine_user as B ");
            statement.append("  on A.USER_ID = B.USER_ID ");
            statement.append("LEFT JOIN turbine_group as C ");
            statement.append("  on A.GROUP_ID = C.GROUP_ID ");
            statement.append("LEFT JOIN eip_m_user_position as D ");
            statement.append("  on A.USER_ID = D.USER_ID ");
            statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
            statement.append(" AND B.USER_ID IN (").append(tmp_ids_str.toString()).append(")");
            statement.append("ORDER BY D.POSITION");
            String query = statement.toString();
            List users = Database.sql(TurbineUser.class, (String)query).fetchList();
            int recNum = users.size();
            for (int j = 0; j < recNum; ++j) {
                TurbineUser tuser = (TurbineUser)users.get(j);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(tuser.getUserId().intValue());
                user.setName(tuser.getLoginName());
                user.setAliasName(tuser.getFirstName(), tuser.getLastName());
                user.setUserFacilityType("U");
                if (Integer.toString(ALEipUtils.getUserId((RunData)rundata)).equals(user.getUserFacilityId())) {
                    ulist.add(0, user);
                    continue;
                }
                ulist.add(user);
            }
        }
        if (f_ids != null && f_ids.size() > 0) {
            Expression f_exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", f_ids);
            List facilities = Database.query(EipMFacility.class, (Expression)f_exp).fetchList();
            if (facilities.size() == 0) {
                return null;
            }
            int f_size = facilities.size();
            for (int i = 0; i < f_size; ++i) {
                EipMFacility f_user = (EipMFacility)facilities.get(i);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(f_user.getFacilityId().intValue());
                user.setName(TARGET_FACILITY_ID + user.getUserFacilityId());
                user.setAliasName(f_user.getFacilityName());
                user.setUserFacilityType(SCHEDULEMAP_TYPE_FACILITY);
                ulist.add(user);
            }
        }
        return ulist;
    }

    public static List<UserFacilityLiteBean> getALEipFacility(String[] ids, RunData rundata) throws ALDBErrorException {
        ArrayList<UserFacilityLiteBean> ulist = new ArrayList<UserFacilityLiteBean>();
        int ids_len = ids.length;
        ArrayList<String> f_ids = new ArrayList<String>();
        for (int i = 0; i < ids_len; ++i) {
            if (!ids[i].startsWith(TARGET_FACILITY_ID)) continue;
            f_ids.add(ids[i].replace(TARGET_FACILITY_ID, ""));
        }
        UserFacilityLiteBean user = null;
        if (f_ids != null && f_ids.size() > 0) {
            Expression f_exp = ExpressionFactory.inDbExp((String)"FACILITY_ID", f_ids);
            List facilities = Database.query(EipMFacility.class, (Expression)f_exp).fetchList();
            if (facilities.size() == 0) {
                return null;
            }
            int f_size = facilities.size();
            for (int i = 0; i < f_size; ++i) {
                EipMFacility f_user = (EipMFacility)facilities.get(i);
                user = new UserFacilityLiteBean();
                user.initField();
                user.setUserFacilityId(f_user.getFacilityId().intValue());
                user.setName(TARGET_FACILITY_ID + user.getUserFacilityId());
                user.setAliasName(f_user.getFacilityName());
                user.setUserFacilityType(SCHEDULEMAP_TYPE_FACILITY);
                ulist.add(user);
            }
        }
        return ulist;
    }

    public static void addTerm(List<AjaxTermScheduleWeekContainer> weekConList, Date viewStartDate, int index, AjaxScheduleResultData rd) {
        try {
            boolean success = false;
            if (weekConList.size() > 0) {
                AjaxTermScheduleWeekContainer tmpWeekCon = null;
                int size = weekConList.size();
                for (int i = 0; i < size; ++i) {
                    tmpWeekCon = weekConList.get(i);
                    success = tmpWeekCon.canAddTerm(rd);
                    if (!success) continue;
                    tmpWeekCon.addTermResultData(index, rd);
                    break;
                }
            }
            if (!success) {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(viewStartDate);
                AjaxTermScheduleWeekContainer weekCon = new AjaxTermScheduleWeekContainer();
                weekCon.initField();
                weekCon.setViewStartDate(cal2);
                weekCon.addTermResultData(index, rd);
                weekConList.add(weekCon);
            }
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
        }
    }

    public static void addTermSchedule(List<ScheduleTermWeekContainer> weekConList, Date viewStartDate, int index, ScheduleResultData rd) {
        try {
            boolean success = false;
            if (weekConList.size() > 0) {
                ScheduleTermWeekContainer tmpWeekCon = null;
                int size = weekConList.size();
                for (int i = 0; i < size; ++i) {
                    tmpWeekCon = weekConList.get(i);
                    success = tmpWeekCon.canAddTerm(rd);
                    if (!success) continue;
                    tmpWeekCon.addTermResultData(index, rd);
                    break;
                }
            }
            if (!success) {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(viewStartDate);
                ScheduleTermWeekContainer weekCon = new ScheduleTermWeekContainer();
                weekCon.initField();
                weekCon.setViewStartDate(cal2);
                weekCon.addTermResultData(index, rd);
                weekConList.add(weekCon);
            }
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
        }
    }

    public static Date getEmptyDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        return cal.getTime();
    }

    public static String hasAuthOther(RunData rundata) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_other", 1)) {
                return "T";
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)e);
        }
        return SCHEDULEMAP_TYPE_FACILITY;
    }

    public static String hasAuthSelf(RunData rundata) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_self", 1)) {
                return "T";
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)e);
        }
        return SCHEDULEMAP_TYPE_FACILITY;
    }

    public static String hasAuthOtherUpdate(RunData rundata) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_other", 8)) {
                return "T";
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)e);
        }
        return SCHEDULEMAP_TYPE_FACILITY;
    }

    public static String hasAuthSelfUpdate(RunData rundata) {
        try {
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_self", 8)) {
                return "T";
            }
        }
        catch (Exception e) {
            logger.error((Object)"[ScheduleUtils]", (Throwable)e);
        }
        return SCHEDULEMAP_TYPE_FACILITY;
    }

    public static int getOwnerId(RunData rundata) {
        String scheduleId = rundata.getParameters().getString("entityid");
        if (scheduleId == null | "".equals(scheduleId)) {
            return ALEipUtils.getUserId((RunData)rundata);
        }
        Expression exp = ExpressionFactory.matchDbExp((String)"SCHEDULE_ID", (Object)Integer.valueOf(scheduleId));
        List list = Database.query(EipTSchedule.class, (Expression)exp).fetchList();
        if (list.size() == 0) {
            return ALEipUtils.getUserId((RunData)rundata);
        }
        return ((EipTSchedule)list.get(0)).getOwnerId();
    }

    public static boolean hasRelation(RunData rundata) {
        String scheduleId = rundata.getParameters().getString("entityid");
        if (scheduleId == null | "".equals(scheduleId)) {
            return false;
        }
        return ScheduleUtils.hasRelation(rundata, Integer.valueOf(scheduleId));
    }

    public static boolean hasRelation(RunData rundata, int scheduleId) {
        int userId = ALEipUtils.getUserId((RunData)rundata);
        Expression exp11 = ExpressionFactory.matchExp((String)"scheduleId", (Object)scheduleId);
        Expression exp12 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
        List list = Database.query(EipTScheduleMap.class, (Expression)exp11).andQualifier(exp12).fetchList();
        return list.size() != 0;
    }

    public static boolean hasMinimumAuthority(RunData rundata) {
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_self", 1);
        if (!hasAuthority) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createMsgForPc(RunData rundata, EipTSchedule schedule, List<ALEipUser> memberList, boolean add) {
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        String date_detail = "";
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
            date_detail = ScheduleUtils.getMsgDate(schedule);
        }
        catch (Exception e) {
            return "";
        }
        StringWriter out = null;
        try {
            VelocityService service = (VelocityService)((TurbineServices)TurbineServices.getInstance()).getService("VelocityService");
            Context context = service.getContext();
            context.put("userName", (Object)loginUser.getAliasName().toString());
            context.put("mailAddress", (Object)user.getEmail());
            if (add) {
                context.put("addScheduleMSG", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_ADD_SCHEDULE_FROM_USER"));
            } else {
                context.put("addScheduleMSG", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_EDIT_SCHEDULE_FROM_USER"));
            }
            context.put("title", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_TITLE"));
            context.put("titleValue", (Object)schedule.getName().toString());
            context.put("date", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_DATE"));
            context.put("dateValue", (Object)date_detail);
            if (schedule.getPlace().toString().length() > 0) {
                context.put("place", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_PLACE"));
                context.put("placeValue", (Object)schedule.getPlace().toString());
            }
            if (schedule.getNote().toString().length() > 0) {
                context.put("note", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_NOTE"));
                context.put("noteValue", (Object)schedule.getNote().toString());
            }
            if (memberList != null) {
                int size = memberList.size();
                StringBuffer body = new StringBuffer("");
                context.put("menbers", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_MENBERS"));
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        body.append(", ");
                    }
                    ALEipUser member = memberList.get(i);
                    body.append(member.getAliasName());
                }
                context.put("menbersList", (Object)body.toString());
            }
            context.put("Alias", (Object)ALOrgUtilsService.getAlias());
            context.put("accessTo", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_ACCESS_TO"));
            if (enableAsp) {
                context.put("globalUrl1", (Object)ALMailUtils.getGlobalurl());
            } else {
                context.put("outsideOffice", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_OUTSIDE_OFFICE"));
                context.put("globalurl2", (Object)ALMailUtils.getGlobalurl());
                context.put("insideOffice", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_INSIDE_OFFICE"));
                context.put("globalUrl3", (Object)ALMailUtils.getLocalurl());
            }
            out = new StringWriter();
            service.handleRequest(context, "mail/createSchedule.vm", (Writer)out);
            out.flush();
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger.warn((Object)message, (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createMsgForCellPhone(RunData rundata, EipTSchedule schedule, List<ALEipUser> memberList, int destUserID, boolean add) {
        String message;
        ALEipUser loginUser = null;
        ALBaseUser user = null;
        String date_detail = "";
        try {
            loginUser = ALEipUtils.getALEipUser((RunData)rundata);
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(loginUser.getUserId().toString()));
            date_detail = ScheduleUtils.getMsgDate(schedule);
        }
        catch (Exception e) {
            return "";
        }
        StringWriter out = null;
        try {
            ALEipUser destUser;
            CharSequence body;
            VelocityService service = (VelocityService)((TurbineServices)TurbineServices.getInstance()).getService("VelocityService");
            Context context = service.getContext();
            context.put("userName", (Object)loginUser.getAliasName().toString());
            context.put("mailAddress", (Object)user.getEmail());
            if (add) {
                context.put("addScheduleMSG", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_ADD_SCHEDULE_FROM_USER"));
            } else {
                context.put("addScheduleMSG", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_EDIT_SCHEDULE_FROM_USER"));
            }
            context.put("title", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_TITLE"));
            context.put("titleValue", (Object)schedule.getName().toString());
            context.put("date", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_DATE"));
            context.put("dateValue", (Object)date_detail);
            if (memberList != null) {
                int size = memberList.size();
                body = new StringBuffer("");
                context.put("menbers", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_SUB_MENBERS"));
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        ((StringBuffer)body).append(", ");
                    }
                    ALEipUser member = memberList.get(i);
                    ((StringBuffer)body).append(member.getAliasName());
                }
                context.put("menbersList", (Object)((StringBuffer)body).toString());
            }
            try {
                destUser = ALEipUtils.getALEipUser((int)destUserID);
            }
            catch (ALDBErrorException ex) {
                logger.error((Object)"schedule", (Throwable)ex);
                body = "";
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return body;
            }
            context.put("Alias", (Object)ALOrgUtilsService.getAlias());
            context.put("accessTo", (Object)ALLocalizationUtils.getl10n((String)"SCHEDULE_ACCESS_TO"));
            context.put("globalUrl1", (Object)(ALMailUtils.getGlobalurl() + "?key=" + ALCellularUtils.getCellularKey((ALEipUser)destUser)));
            out = new StringWriter();
            service.handleRequest(context, "mail/createSchedule.vm", (Writer)out);
            out.flush();
            String string = out.toString();
            return string;
        }
        catch (RuntimeException e) {
            message = e.getMessage();
            logger.warn((Object)message, (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            message = e.getMessage();
            logger.warn((Object)message, (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public static String getMsgDate(EipTSchedule schedule) {
        Calendar start_cal = Calendar.getInstance();
        start_cal.setTime(schedule.getStartDate());
        Calendar end_cal = Calendar.getInstance();
        end_cal.setTime(schedule.getEndDate());
        StringBuffer result = new StringBuffer();
        String ptn = schedule.getRepeatPattern();
        int count = 0;
        boolean is_repeat = true;
        boolean is_span = false;
        if (ptn.charAt(0) == 'D') {
            result.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_EVERY_DAY"));
            count = 1;
        } else if (ptn.charAt(0) == 'W') {
            result.append(new StringBuffer().append(ALLocalizationUtils.getl10n((String)"SCHEDULE_EVERY_WEEK")).append(ptn.charAt(1) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_SUNDAY") : "").append(ptn.charAt(2) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_MONDAY") : "").append(ptn.charAt(3) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_TUSEDAY") : "").append(ptn.charAt(4) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_WEDNESDAY") : "").append(ptn.charAt(5) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_THURSDAY") : "").append(ptn.charAt(6) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_FRIDAY") : "").append(ptn.charAt(7) != '0' ? ALLocalizationUtils.getl10n((String)"SCHEDULE_SATURDAY") : "").append(ALLocalizationUtils.getl10n((String)"SCHEDULE_A_DAY_OF_THE_WEEK")).toString());
            count = 8;
        } else if (ptn.charAt(0) == 'M') {
            result.append(ALLocalizationUtils.getl10n((String)"SCHEDULE_EVERY_MONTH_SPACE")).append(Integer.parseInt(ptn.substring(1, 3))).append(ALLocalizationUtils.getl10n((String)"SCHEDULE_DAY")).toString();
            count = 3;
        } else if (ptn.charAt(0) == 'S') {
            is_span = true;
            is_repeat = false;
        } else {
            is_repeat = false;
        }
        ALDateTimeField date_field = new ALDateTimeField("yyyy/MM/dd");
        ALDateTimeField time_field = new ALDateTimeField("HH:mm");
        if (!is_span) {
            if (!is_repeat) {
                date_field.setValue(schedule.getStartDate());
                result.append(date_field.toString());
            }
            time_field.setValue(schedule.getStartDate());
            result.append(" ").append(time_field.toString()).append(" - ");
            time_field.setValue(schedule.getEndDate());
            result.append(time_field.toString()).append(" ");
        } else {
            Date start = schedule.getStartDate();
            Date end = schedule.getEndDate();
            date_field.setValue(start);
            result.append(date_field.toString());
            if (!start.equals(end)) {
                result.append(" - ");
                date_field.setValue(end);
                result.append(date_field.toString());
            }
        }
        if (is_repeat && ptn.charAt(count) != 'N') {
            date_field.setValue(schedule.getStartDate());
            result.append(" \uff08").append(date_field.toString()).append(" - ");
            date_field.setValue(schedule.getEndDate());
            result.append(date_field.toString()).append("\uff09").toString();
        }
        return result.toString();
    }

    public static boolean isDuplicateFacilitySchedule(EipTSchedule schedule, List<Integer> facilityIdList, Integer _old_scheduleid, Date _old_viewDate) {
        boolean week_6;
        boolean week_5;
        boolean week_4;
        boolean week_3;
        boolean week_2;
        boolean week_1;
        boolean week_0;
        String limit_flag;
        String repeat_type;
        String repeat_pattern;
        Date end_date;
        Date start_date;
        GregorianCalendar cald = new GregorianCalendar();
        boolean result = false;
        int month_day = -1;
        Integer db_scheduleid = null;
        boolean[] week_array = new boolean[7];
        boolean unlimited_repeat = false;
        try {
            start_date = schedule.getStartDate();
            end_date = schedule.getEndDate();
            repeat_pattern = schedule.getRepeatPattern();
            repeat_type = repeat_pattern.substring(0, 0);
            limit_flag = repeat_pattern.substring(repeat_pattern.length() - 1);
            week_0 = repeat_pattern.matches("W1.......");
            week_1 = repeat_pattern.matches("W.1......");
            week_2 = repeat_pattern.matches("W..1.....");
            week_3 = repeat_pattern.matches("W...1....");
            week_4 = repeat_pattern.matches("W....1...");
            week_5 = repeat_pattern.matches("W.....1..");
            week_6 = repeat_pattern.matches("W......1.");
            if (repeat_pattern.startsWith("M")) {
                month_day = Integer.parseInt(repeat_pattern.substring(1, 3));
            }
            if (repeat_pattern.startsWith(MAIL_FOR_NONE)) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(start_date);
                int dow = cal.get(7);
                week_0 = dow == 1;
                week_1 = dow == 2;
                week_2 = dow == 3;
                week_3 = dow == 4;
                week_4 = dow == 5;
                week_5 = dow == 6;
                week_6 = dow == 7;
                month_day = cal.get(5);
            } else if (repeat_pattern.endsWith(MAIL_FOR_NONE)) {
                unlimited_repeat = true;
            }
            week_array[0] = week_0;
            week_array[1] = week_1;
            week_array[2] = week_2;
            week_array[3] = week_3;
            week_array[4] = week_4;
            week_array[5] = week_5;
            week_array[6] = week_6;
        }
        catch (RuntimeException e) {
            logger.error((Object)"schedule", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"schedule", (Throwable)e);
            return false;
        }
        if (facilityIdList.size() > 0) {
            Expression dexp01;
            List<Integer> fids = facilityIdList;
            SelectQuery fquery = Database.query(EipTScheduleMap.class);
            Expression fexp1 = ExpressionFactory.inExp((String)"userId", fids);
            fquery.setQualifier(fexp1);
            Expression fexp2 = ExpressionFactory.matchExp((String)"type", (Object)SCHEDULEMAP_TYPE_FACILITY);
            fquery.andQualifier(fexp2);
            Expression oneexp = null;
            Expression rdexp = null;
            Expression rwexp = null;
            Expression rmexp = null;
            Expression exp100 = ExpressionFactory.matchExp((String)"eipTSchedule.repeatPattern", (Object)MAIL_FOR_NONE);
            try {
                if (!unlimited_repeat) {
                    Expression exp101 = ExpressionFactory.lessOrEqualExp((String)"eipTSchedule.startDate", (Object)end_date);
                    Expression exp102 = ExpressionFactory.greaterExp((String)"eipTSchedule.endDate", (Object)start_date);
                    oneexp = exp100.andExp(exp101.andExp(exp102));
                } else {
                    oneexp = exp100;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if ("ON".equals(limit_flag)) {
                // empty if block
            }
            rdexp = dexp01 = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"D_");
            Expression wexp = null;
            ArrayList<Expression> wexps = new ArrayList<Expression>();
            if (week_0) {
                wexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"W1_______");
                wexps.add(wexp);
            }
            if (week_1) {
                wexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"W_1______");
                wexps.add(wexp);
            }
            if (week_2) {
                wexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"W__1_____");
                wexps.add(wexp);
            }
            if (week_3) {
                wexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"W___1____");
                wexps.add(wexp);
            }
            if (week_4) {
                wexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"W____1___");
                wexps.add(wexp);
            }
            if (week_5) {
                wexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"W_____1__");
                wexps.add(wexp);
            }
            if (week_6) {
                wexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"W______1_");
                wexps.add(wexp);
            }
            if (wexps.size() > 0) {
                rwexp = (Expression)wexps.get(0);
                int wexpssize = wexps.size();
                for (int k = 1; k < wexpssize; ++k) {
                    rwexp = rwexp.orExp((Expression)wexps.get(k));
                }
            } else {
                rwexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"W________");
            }
            if (month_day > 0) {
                DecimalFormat exF = new DecimalFormat("00");
                String md_str = exF.format(month_day);
                rmexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)("M" + md_str + "_"));
            } else {
                rmexp = ExpressionFactory.likeExp((String)"eipTSchedule.repeatPattern", (Object)"M___");
            }
            Expression repeatexp = oneexp;
            if (rdexp != null) {
                repeatexp = repeatexp.orExp(rdexp);
            }
            if (rwexp != null) {
                repeatexp = repeatexp.orExp(rwexp);
            }
            if (rmexp != null) {
                repeatexp = repeatexp.orExp(rmexp);
            }
            fquery.andQualifier(repeatexp);
            db_scheduleid = schedule.getScheduleId();
            if (db_scheduleid != null && db_scheduleid >= 0) {
                Expression exp00 = ExpressionFactory.noMatchDbExp((String)"eipTSchedule.SCHEDULE_ID", (Object)db_scheduleid);
                fquery.andQualifier(exp00);
            }
            fquery.distinct(true);
            List f_list = fquery.fetchList();
            if (f_list != null && f_list.size() > 0) {
                boolean existFacility = false;
                int f_list_size = f_list.size();
                for (int i = 0; i < f_list_size; ++i) {
                    block98: {
                        EipTScheduleMap map = (EipTScheduleMap)f_list.get(i);
                        Date dbStartDate = map.getEipTSchedule().getStartDate();
                        Date dbEndDate = map.getEipTSchedule().getEndDate();
                        boolean containtsRs = false;
                        String ptn = map.getEipTSchedule().getRepeatPattern();
                        if (ptn.charAt(0) == 'N') {
                            if (MAIL_FOR_DELETE.equals(repeat_type) || MAIL_FOR_NONE.equals(repeat_type)) {
                                try {
                                    if (dbStartDate.before(end_date) && dbEndDate.after(start_date) || unlimited_repeat) {
                                        containtsRs = true;
                                    }
                                }
                                catch (Exception e) {
                                    containtsRs = false;
                                }
                            } else if (dbStartDate.before(end_date) && dbEndDate.after(start_date) || unlimited_repeat) {
                                containtsRs = true;
                            }
                        } else if (ptn.charAt(0) == 'D') {
                            if (ptn.charAt(1) == 'L') {
                                try {
                                    if (dbStartDate.before(end_date) && dbEndDate.after(start_date) || unlimited_repeat) {
                                        containtsRs = true;
                                    }
                                }
                                catch (Exception e) {
                                    containtsRs = false;
                                }
                            } else {
                                containtsRs = true;
                            }
                        } else if (ptn.charAt(0) == 'W') {
                            if (ptn.charAt(8) == 'L') {
                                try {
                                    if (dbStartDate.before(end_date) && dbEndDate.after(start_date) || unlimited_repeat) {
                                        containtsRs = true;
                                    }
                                }
                                catch (Exception e) {
                                    containtsRs = false;
                                }
                            } else {
                                containtsRs = true;
                            }
                        } else if (ptn.charAt(0) == 'M') {
                            if (ptn.charAt(3) == 'L') {
                                try {
                                    if (dbStartDate.before(end_date) && dbEndDate.after(start_date) || unlimited_repeat) {
                                        containtsRs = true;
                                    }
                                }
                                catch (Exception e) {
                                    containtsRs = false;
                                }
                            } else {
                                containtsRs = true;
                            }
                        } else {
                            containtsRs = true;
                        }
                        if (containtsRs) {
                            int ss_flg = ScheduleUtils.compareTime(start_date, dbEndDate);
                            int se_flg = ScheduleUtils.compareTime(end_date, dbStartDate);
                            if (ss_flg > 0 && se_flg < 0) {
                                if (!MAIL_FOR_NONE.equals(ptn) && ptn.endsWith(MAIL_FOR_NONE) && unlimited_repeat) {
                                    existFacility = true;
                                } else {
                                    Date _start_date = null;
                                    Date _end_date = null;
                                    if (!MAIL_FOR_NONE.equals(ptn) && ptn.endsWith(MAIL_FOR_NONE) && !unlimited_repeat) {
                                        _start_date = (Date)start_date.clone();
                                        _end_date = (Date)end_date.clone();
                                    } else if ((MAIL_FOR_NONE.equals(ptn) || !ptn.endsWith(MAIL_FOR_NONE)) && unlimited_repeat) {
                                        _start_date = (Date)dbStartDate.clone();
                                        _end_date = (Date)dbEndDate.clone();
                                    } else if (!(!MAIL_FOR_NONE.equals(ptn) && ptn.endsWith(MAIL_FOR_NONE) || unlimited_repeat)) {
                                        _start_date = dbStartDate.after(start_date) ? (Date)dbStartDate.clone() : (Date)start_date.clone();
                                        _end_date = dbEndDate.before(end_date) ? (Date)dbEndDate.clone() : (Date)end_date.clone();
                                    }
                                    if (_start_date == null || _end_date == null) continue;
                                    Expression dexp1 = ExpressionFactory.matchExp((String)"name", (Object)"dummy");
                                    Expression dexp2 = ExpressionFactory.matchExp((String)"parentId", (Object)map.getScheduleId());
                                    if (db_scheduleid != null) {
                                        Expression dexp21 = ExpressionFactory.matchExp((String)"parentId", (Object)db_scheduleid);
                                        dexp2 = dexp2.orExp(dexp21);
                                    }
                                    Expression dexp3 = null;
                                    cald.setTime(_start_date);
                                    cald.set(14, 0);
                                    cald.set(13, 0);
                                    cald.set(12, 0);
                                    cald.set(11, 0);
                                    Date ddate = cald.getTime();
                                    List temp = null;
                                    if (MAIL_FOR_NONE.equals(repeat_pattern)) {
                                        if (_old_scheduleid != null && _old_viewDate != null && _old_scheduleid.intValue() == map.getScheduleId().intValue() && ScheduleUtils.compareToDate(_start_date, _old_viewDate) == 0) continue;
                                        try {
                                            dexp3 = ExpressionFactory.matchExp((String)"startDate", (Object)ddate);
                                            temp = Database.query(EipTSchedule.class, (Expression)dexp1.andExp(dexp2).andExp(dexp3)).fetchList();
                                            if (temp == null || temp.size() <= 0) {
                                                existFacility = true;
                                            }
                                            break block98;
                                        }
                                        catch (Exception e) {
                                            logger.error((Object)"[DuplicateFacilityCheck]: ", (Throwable)e);
                                            existFacility = true;
                                        }
                                        break;
                                    }
                                    if (repeat_pattern.startsWith(MAIL_FOR_DELETE)) {
                                        while (!ddate.after(_end_date)) {
                                            block99: {
                                                if (ScheduleUtils.matchDay(cald, ptn)) {
                                                    try {
                                                        dexp3 = ExpressionFactory.matchExp((String)"startDate", (Object)ddate);
                                                        temp = Database.query(EipTSchedule.class, (Expression)dexp1.andExp(dexp2).andExp(dexp3)).fetchList();
                                                        if (temp == null || temp.size() <= 0) {
                                                            existFacility = true;
                                                        }
                                                        break block99;
                                                    }
                                                    catch (Exception e) {
                                                        logger.error((Object)"[DuplicateFacilityCheck]: ", (Throwable)e);
                                                        existFacility = true;
                                                    }
                                                    break;
                                                }
                                            }
                                            cald.add(5, 1);
                                            ddate = cald.getTime();
                                        }
                                    } else if (repeat_pattern.startsWith("W")) {
                                        int wlen = week_array.length;
                                        if (wlen < 1) continue;
                                        while (!ddate.after(_end_date)) {
                                            block100: {
                                                int k = (cald.get(7) - 1) % wlen;
                                                if (week_array[k] && ScheduleUtils.matchDay(cald, ptn)) {
                                                    try {
                                                        dexp3 = ExpressionFactory.matchExp((String)"startDate", (Object)ddate);
                                                        temp = Database.query(EipTSchedule.class, (Expression)dexp1.andExp(dexp2).andExp(dexp3)).fetchList();
                                                        if (temp == null || temp.size() <= 0) {
                                                            existFacility = true;
                                                        }
                                                        break block100;
                                                    }
                                                    catch (Exception e) {
                                                        logger.error((Object)"[DuplicateFacilityCheck]: ", (Throwable)e);
                                                        existFacility = true;
                                                    }
                                                    break;
                                                }
                                            }
                                            cald.add(5, 1);
                                            ddate = cald.getTime();
                                        }
                                    } else {
                                        if (!repeat_pattern.startsWith("M")) continue;
                                        cald.setTime(dbStartDate);
                                        cald.set(14, 0);
                                        cald.set(13, 0);
                                        cald.set(12, 0);
                                        cald.set(11, 0);
                                        if (month_day <= 0) continue;
                                        cald.set(5, month_day);
                                        Date tmp_date = cald.getTime();
                                        while (tmp_date.before(ddate)) {
                                            cald.add(2, 1);
                                            while (month_day > cald.getActualMaximum(5)) {
                                                cald.add(2, 1);
                                                cald.set(5, month_day);
                                                if (!tmp_date.before(tmp_date)) continue;
                                            }
                                            tmp_date = cald.getTime();
                                        }
                                        ddate = tmp_date;
                                        while (!ddate.after(_end_date)) {
                                            block101: {
                                                if (ScheduleUtils.matchDay(cald, ptn)) {
                                                    try {
                                                        dexp3 = ExpressionFactory.matchExp((String)"startDate", (Object)ddate);
                                                        temp = Database.query(EipTSchedule.class, (Expression)dexp1.andExp(dexp2).andExp(dexp3)).fetchList();
                                                        if (temp == null || temp.size() <= 0) {
                                                            existFacility = true;
                                                        }
                                                        break block101;
                                                    }
                                                    catch (Exception e) {
                                                        logger.error((Object)"[DuplicateFacilityCheck]: ", (Throwable)e);
                                                        existFacility = true;
                                                    }
                                                    break;
                                                }
                                            }
                                            cald.add(2, 1);
                                            while (month_day > cald.getActualMaximum(5)) {
                                                cald.add(2, 1);
                                                cald.set(5, month_day);
                                                if (ddate.after(_end_date)) continue;
                                            }
                                            ddate = cald.getTime();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (existFacility) break;
                }
                if (existFacility) {
                    return existFacility;
                }
            }
        }
        return result;
    }

    public static boolean matchDay(Calendar cal, String repeat_ptn) {
        if (repeat_ptn == null || "".equals(repeat_ptn)) {
            return false;
        }
        if (repeat_ptn.startsWith("M")) {
            int ptn_day;
            int month_day = Integer.parseInt(repeat_ptn.substring(1, 3));
            return month_day == (ptn_day = cal.get(5));
        }
        if (repeat_ptn.startsWith("W")) {
            int dow = cal.get(7);
            if (dow == 1) {
                return repeat_ptn.matches("W1.......");
            }
            if (dow == 2) {
                return repeat_ptn.matches("W.1......");
            }
            if (dow == 3) {
                return repeat_ptn.matches("W..1.....");
            }
            if (dow == 4) {
                return repeat_ptn.matches("W...1....");
            }
            if (dow == 5) {
                return repeat_ptn.matches("W....1...");
            }
            if (dow == 6) {
                return repeat_ptn.matches("W.....1..");
            }
            if (dow == 7) {
                return repeat_ptn.matches("W......1.");
            }
            return false;
        }
        return true;
    }

    public static boolean hasAuthorityForOtherSchedule(RunData rundata, int type) {
        boolean acl_delete_other = false;
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        if (aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "schedule_other", type)) {
            acl_delete_other = true;
        }
        return acl_delete_other;
    }

    public static List<VEipTScheduleList> getScheduleList(int userId, List<Integer> users, List<Integer> facilities, String keyword, int page, int limit) {
        return ScheduleUtils.getScheduleList(userId, null, null, users, facilities, keyword, page, limit, true, true);
    }

    public static List<VEipTScheduleList> getScheduleList(int userId, Date viewStart, Date viewEnd, List<Integer> users, List<Integer> facilities, boolean isDetail) {
        return ScheduleUtils.getScheduleList(userId, viewStart, viewEnd, users, facilities, null, -1, -1, false, isDetail);
    }

    public static List<VEipTScheduleList> getScheduleList(int userId, Date viewStart, Date viewEnd, List<Integer> users, List<Integer> facilities) {
        return ScheduleUtils.getScheduleList(userId, viewStart, viewEnd, users, facilities, null, -1, -1, false, false);
    }

    protected static List<VEipTScheduleList> getScheduleList(int userId, Date viewStart, Date viewEnd, List<Integer> users, List<Integer> facilities, String keyword, int page, int limit, boolean isSearch, boolean isDetail) {
        boolean isFirst;
        boolean isMySQL = Database.isJdbcMySQL();
        StringBuilder select = new StringBuilder();
        select.append("select");
        if (!isSearch) {
            select.append(" t3.id, ");
            select.append(" t3.user_id, ");
            select.append(" t3.status, ");
            select.append(" t3.type, ");
            select.append(" t3.common_category_id, ");
        }
        select.append(" t4.schedule_id,");
        select.append(" t4.owner_id,");
        select.append(" t4.parent_id,");
        select.append(" t4.name,");
        select.append(" t4.place,");
        select.append(" t4.start_date,");
        select.append(" t4.end_date,");
        select.append(" t4.update_date,");
        select.append(" t4.public_flag,");
        select.append(" t4.repeat_pattern,");
        select.append(" t4.create_user_id,");
        select.append(" t4.edit_flag,");
        if (isDetail) {
            select.append(" t4.note,");
        }
        select.append(" (SELECT COUNT(*) FROM eip_t_schedule_map t0 WHERE (t0.schedule_id = t4.schedule_id) AND (t0.user_id = #bind($user_id))) AS is_member,");
        select.append(" (SELECT COUNT(*) FROM eip_t_schedule_map t1 WHERE (t1.schedule_id = t4.schedule_id) AND (t1.status <> 'R') AND (t1.type = 'F')) AS f_count,");
        select.append(" (SELECT COUNT(*) FROM eip_t_schedule_map t2 WHERE (t2.schedule_id = t4.schedule_id) AND (t2.status <> 'R') AND (t2.type <> 'F')) AS u_count");
        StringBuilder count = new StringBuilder();
        count.append("select count(t4.schedule_id) AS c ");
        boolean hasKeyword = false;
        StringBuilder body = new StringBuilder();
        if (isSearch) {
            body.append(" FROM eip_t_schedule t4 ");
            body.append(" WHERE ");
            body.append(" EXISTS ( ");
            body.append(" SELECT NULL FROM eip_t_schedule_map t3 WHERE t3.schedule_id = t4.schedule_id AND t3.status NOT IN('D', 'R') ");
            if (users != null && users.size() > 0 || facilities != null && facilities.size() > 0) {
                body.append(" AND (t3.type, t3.user_id) IN ( ");
                isFirst = true;
                if (users != null && users.size() > 0) {
                    for (Integer num : users) {
                        if (!isFirst) {
                            body.append(",");
                        }
                        body.append(" ('U', ");
                        body.append(num);
                        body.append(" ) ");
                        isFirst = false;
                    }
                }
                if (facilities != null && facilities.size() > 0) {
                    for (Integer num : facilities) {
                        if (!isFirst) {
                            body.append(",");
                        }
                        body.append(" ('F', ");
                        body.append(num);
                        body.append(" ) ");
                        isFirst = false;
                    }
                }
                body.append(" ) ");
            }
            if (keyword != null && keyword.length() > 0) {
                hasKeyword = true;
                body.append(" AND (");
                body.append(" t4.name LIKE #bind($keyword) OR t4.note LIKE #bind($keyword) OR t4.place LIKE #bind($keyword) ");
                body.append(" ) ");
            }
            body.append(" AND ( t4.public_flag = 'O' OR  ( t3.type = 'U' AND t3.user_id = #bind($user_id) ) OR  (t4.owner_id = #bind($user_id)) ) ");
            body.append(" ) ");
        } else {
            body.append(" FROM eip_t_schedule_map t3 ");
            if (isMySQL) {
                body.append(" FORCE INDEX (eip_t_schedule_map_schedule_id_index) ");
            }
            body.append(" , eip_t_schedule t4 ");
            body.append(" WHERE ");
            body.append(" t3.schedule_id = t4.schedule_id AND (t3.status <> 'R') ");
            if (users != null && users.size() > 0 || facilities != null && facilities.size() > 0) {
                body.append(" AND (t3.type, t3.user_id) IN ( ");
                isFirst = true;
                if (users != null && users.size() > 0) {
                    for (Integer num : users) {
                        if (!isFirst) {
                            body.append(",");
                        }
                        body.append(" ('U', ");
                        body.append(num);
                        body.append(" ) ");
                        isFirst = false;
                    }
                }
                if (facilities != null && facilities.size() > 0) {
                    for (Integer num : facilities) {
                        if (!isFirst) {
                            body.append(",");
                        }
                        body.append(" ('F', ");
                        body.append(num);
                        body.append(" ) ");
                        isFirst = false;
                    }
                }
                body.append(" ) ");
            }
            if (viewStart != null && viewEnd != null) {
                body.append(" AND ( ");
                body.append(" ( ");
                body.append(" t4.start_date <= '");
                body.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(viewEnd));
                body.append("' ");
                body.append(" AND t4.end_date >= '");
                body.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(viewStart));
                body.append("' ");
                body.append(" ) ");
                body.append(" OR  t4.repeat_pattern NOT IN ('N', 'S') ");
                body.append(" ) ");
            }
        }
        StringBuilder last = new StringBuilder();
        last.append(" ORDER BY t4.start_date DESC, t4.end_date DESC, t4.update_date DESC ");
        if (!isSearch) {
            last.append(" , t3.type DESC, t3.user_id ");
        }
        SQLTemplate countQuery = Database.sql(VEipTScheduleList.class, (String)(count.toString() + body.toString())).param("user_id", (Object)userId);
        if (hasKeyword) {
            countQuery.param(TARGET_KEYWORD, (Object)("%" + keyword + "%"));
        }
        int countValue = 0;
        if (page > 0 && limit > 0) {
            List fetchCount = countQuery.fetchListAsDataRow();
            for (DataRow row : fetchCount) {
                countValue = ((Long)row.get((Object)"c")).intValue();
            }
            int offset = 0;
            if (limit > 0) {
                int num = (int)Math.ceil((double)countValue / (double)limit);
                if (num > 0 && num < page) {
                    page = num;
                }
                offset = limit * (page - 1);
            } else {
                page = 1;
            }
            last.append(" LIMIT ");
            last.append(limit);
            last.append(" OFFSET ");
            last.append(offset);
        }
        SQLTemplate query = Database.sql(VEipTScheduleList.class, (String)(select.toString() + body.toString() + last.toString())).param("user_id", (Object)userId);
        if (hasKeyword) {
            query.param(TARGET_KEYWORD, (Object)("%" + keyword + "%"));
        }
        List fetchList = query.fetchListAsDataRow();
        ArrayList<VEipTScheduleList> list = new ArrayList<VEipTScheduleList>();
        for (DataRow row : fetchList) {
            Long is_member = (Long)row.get((Object)"is_member");
            Long u_count = (Long)row.get((Object)"u_count");
            Long f_count = (Long)row.get((Object)"f_count");
            VEipTScheduleList object = (VEipTScheduleList)Database.objectFromRowData((DataRow)row, VEipTScheduleList.class);
            object.setMember(is_member.intValue() > 0);
            object.setUserCount(u_count.intValue());
            object.setFacilityCount(f_count.intValue());
            list.add(object);
        }
        if (page > 0 && limit > 0) {
            return new ResultList(list, page, limit, countValue);
        }
        return new ResultList(list, -1, -1, list.size());
    }

    public static void createShareScheduleActivity(EipTSchedule schedule, String loginName, List<String> recipients, boolean isNew, int userid) {
        if (recipients != null && recipients.size() > 0) {
            ALActivity RecentActivity = ALActivity.getRecentActivity((String)SCHEDULE_PORTLET_NAME, (int)schedule.getScheduleId(), (float)1.0f);
            boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
            String title = ALLocalizationUtils.getl10n((String)"SCHEDULE_SCHEDULE_BRACKET") + schedule.getName() + (isNew ? ALLocalizationUtils.getl10n((String)"SCHEDULE_ADD_A_SCHEDULE") : ALLocalizationUtils.getl10n((String)"SCHEDULE_EDIT_A_SCHEDULE"));
            String portletParams = "?template=ScheduleDetailScreen" + "&entityid=" + schedule.getScheduleId() + "&view_date=" + ALDateUtil.format((Date)schedule.getStartDate(), (String)"yyyy-MM-dd-00-00");
            ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(SCHEDULE_PORTLET_NAME).withUserId(userid).withLoginName(loginName).withPortletParams(portletParams).withRecipients(recipients).withTitle(title).withPriority(1.0f).withExternalId(String.valueOf(schedule.getScheduleId())));
            if (isDeletePrev) {
                RecentActivity.delete();
            }
        }
    }

    public static void createNewScheduleActivity(EipTSchedule schedule, String loginName, boolean isNew, int userid) {
        ALActivity RecentActivity = ALActivity.getRecentActivity((String)SCHEDULE_PORTLET_NAME, (int)schedule.getScheduleId(), (float)0.0f);
        boolean isDeletePrev = RecentActivity != null && RecentActivity.isReplace(loginName);
        String title = ALLocalizationUtils.getl10n((String)"SCHEDULE_SCHEDULE_BRACKET") + schedule.getName() + (isNew ? ALLocalizationUtils.getl10n((String)"SCHEDULE_ADD_A_SCHEDULE") : ALLocalizationUtils.getl10n((String)"SCHEDULE_EDIT_A_SCHEDULE"));
        String portletParams = "?template=ScheduleDetailScreen" + "&entityid=" + schedule.getScheduleId() + "&view_date=" + ALDateUtil.format((Date)schedule.getStartDate(), (String)"yyyy-MM-dd-00-00");
        ALActivityService.create((ALActivityPutRequest)new ALActivityPutRequest().withAppId(SCHEDULE_PORTLET_NAME).withUserId(userid).withLoginName(loginName).withPortletParams(portletParams).withTitle(title).withPriority(0.0f).withExternalId(String.valueOf(schedule.getScheduleId())));
        if (isDeletePrev) {
            RecentActivity.delete();
        }
    }

    public static String getTargetKeyword(RunData rundata, Context context) {
        String target_keyword = null;
        String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
        target_keyword = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD);
        if (keywordParam == null && target_keyword == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)"");
            target_keyword = "";
        } else if (keywordParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_KEYWORD, (String)keywordParam.trim());
            target_keyword = keywordParam;
        }
        return target_keyword;
    }

    public static List<UserFacilityLiteBean> getUserFacilityLiteBeansFromGroup(RunData rundata, String groupname) {
        UserFacilityLiteBean user;
        List tmp_u_list = UserUtils.getUserLiteBeansFromGroup((RunData)rundata, (String)groupname, (boolean)true);
        int t_size = tmp_u_list.size();
        ArrayList<UserFacilityLiteBean> list = new ArrayList<UserFacilityLiteBean>();
        for (int i = 0; i < t_size; ++i) {
            UserLiteBean t_user = (UserLiteBean)tmp_u_list.get(i);
            user = new UserFacilityLiteBean();
            user.initField();
            user.setUserFacilityId(Integer.parseInt(t_user.getUserId()));
            user.setName(t_user.getUserId());
            user.setAliasName(t_user.getAliasName());
            user.setUserFacilityType("U");
            if (!user.getUserFacilityId().equals(String.valueOf(ALEipUtils.getUserId((RunData)rundata)))) continue;
            list.add(user);
        }
        List aList = Database.query(EipMFacility.class).orderAscending("sort").fetchList();
        for (EipMFacility record : aList) {
            user = new UserFacilityLiteBean();
            user.initField();
            user.setUserFacilityId(record.getFacilityId().intValue());
            user.setName(TARGET_FACILITY_ID + user.getUserFacilityId());
            user.setAliasName(record.getFacilityName());
            user.setUserFacilityType(SCHEDULEMAP_TYPE_FACILITY);
            list.add(user);
        }
        return list;
    }

    public static boolean isNumberValue(String string) {
        try {
            Integer.valueOf(string);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    static {
        tabToLayOut.put("calendar", "schedule-calendar");
        tabToLayOut.put("oneday", "schedule-oneday");
        tabToLayOut.put("weekly", "schedule-weekly");
        tabToLayOut.put("monthly", "schedule-monthly");
        tabToLayOut.put("oneday-group", "schedule-oneday-group");
        tabToLayOut.put("weekly-group", "schedule-weekly-group");
        tabToLayOut.put("list", "schedule-search-list");
        LayOutTotab = new HashMap<String, String>();
        LayOutTotab.put("schedule-calendar", "calendar");
        LayOutTotab.put("schedule-oneday", "oneday");
        LayOutTotab.put("schedule-weekly", "weekly");
        LayOutTotab.put("schedule-monthly", "monthly");
        LayOutTotab.put("schedule-oneday-group", "oneday-group");
        LayOutTotab.put("schedule-weekly-group", "weekly-group");
        LayOutTotab.put("schedule-search-list", "list");
    }
}

