/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gpdb;

import com.aimluck.eip.cayenne.om.portlet.EipTGpdb;
import com.aimluck.eip.cayenne.om.portlet.EipTGpdbRecord;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.gpdb.util.GpdbUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, List<String> values, List<String> msgList) {
        try {
            SelectQuery query = Database.query(EipTGpdb.class);
            Expression exp = ExpressionFactory.inDbExp((String)"GPDB_ID", values);
            query.setQualifier(exp);
            List list = query.fetchList();
            if (list == null || list.isEmpty()) {
                return false;
            }
            for (EipTGpdb gpdb : list) {
                List<EipTGpdbRecord> listRecord = GpdbUtils.getEipTGpdbRecord("" + gpdb.getGpdbId());
                if (listRecord == null || listRecord.isEmpty()) continue;
                msgList.add("\u30c7\u30fc\u30bf\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u3001\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3002");
                return false;
            }
            if (msgList.isEmpty()) {
                for (EipTGpdb gpdb : list) {
                    GpdbUtils.removeGpdbItem(gpdb);
                    Database.delete((Persistent)gpdb);
                    Database.commit();
                    ALEventlogFactoryService.getInstance().getEventlogHandler().log(gpdb.getGpdbId().intValue(), 340, "Web\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9 \u300c" + gpdb.getGpdbName() + "\u300d \u524a\u9664");
                }
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }
}

