/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.gpdb;

import com.aimluck.eip.gpdb.GpdbItemSelectData;
import com.aimluck.eip.gpdb.GpdbRecordSelectData;
import com.aimluck.eip.gpdb.GpdbSelectData;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class GpdbAction
extends ALBaseAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GpdbAction.class.getName());
    private static final String LIST_SORT_STR = new StringBuffer().append(GpdbRecordSelectData.class.getName()).append("sort").toString();
    private static final String LIST_SORT_TYPE_STR = new StringBuffer().append(GpdbRecordSelectData.class.getName()).append("sorttype").toString();
    private static final String LIST_FILTER_STR = new StringBuffer().append(GpdbRecordSelectData.class.getName()).append("filter").toString();
    private static final String LIST_FILTER_TYPE_STR = new StringBuffer().append(GpdbRecordSelectData.class.getName()).append("filtertype").toString();
    private static final String ITEM_LIST_SORT_STR = new StringBuffer().append(GpdbItemSelectData.class.getName()).append("sort").toString();
    private static final String ITEM_LIST_SORT_TYPE_STR = new StringBuffer().append(GpdbItemSelectData.class.getName()).append("sorttype").toString();

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        this.clearSession(rundata, context);
        if ("list".equals(this.getMode())) {
            this.doGpdb_list(rundata, context);
        } else if (this.getMode() == null) {
            this.doGpdb_list(rundata, context);
        }
    }

    public void doGpdb_list(RunData rundata, Context context) throws Exception {
        GpdbRecordSelectData listData = new GpdbRecordSelectData();
        listData.initField();
        listData.setGpdbId(context, rundata);
        listData.setRowsNum(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1a-rows")));
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "gpdb-top");
    }

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        try {
            if (this.getMode() == null) {
                String admintab = rundata.getParameters().getString("admintab");
                if (!StringUtils.isEmpty((String)admintab)) {
                    this.doGpdb_all_list(rundata, context);
                } else {
                    this.doGpdbRecord_list(rundata, context);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"GpdbAction.buildMaximizedContext", (Throwable)e);
        }
    }

    public void doGpdb_all_list(RunData rundata, Context context) throws Exception {
        GpdbSelectData listData = new GpdbSelectData();
        listData.initField();
        listData.setRowsNum(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1c-rows")));
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "gpdb");
    }

    public void doGpdbRecord_list(RunData rundata, Context context) throws Exception {
        GpdbRecordSelectData listData = new GpdbRecordSelectData();
        listData.initField();
        listData.setGpdbId(context, rundata);
        listData.setRowsNum(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1b-rows")));
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "gpdb-record");
    }

    private void clearSession(RunData rundata, Context context) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(LIST_SORT_STR);
        list.add(LIST_SORT_TYPE_STR);
        list.add(ITEM_LIST_SORT_STR);
        list.add(ITEM_LIST_SORT_TYPE_STR);
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, list);
    }
}

