/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gadgets;

import com.aimluck.eip.cayenne.om.account.JetspeedUserProfile;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.gadgets.GagetsPsmlFormData;
import com.aimluck.eip.gadgets.util.PsmlDBUtils;
import com.aimluck.eip.gadgets.util.PsmlUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.apache.jetspeed.util.PortletUtils;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.exolab.castor.mapping.Mapping;

public class AdvancedGagetsPsmlFormData
extends GagetsPsmlFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AdvancedGagetsPsmlFormData.class.getName());
    private static final String UPDATE_SUCCESS = "success";
    private static final String UPDATE_ERROR = "error";
    private static final String DEFAULT_VIEW_STATUS = "default_psml_status";
    public static final String DEFAULT_MAPPING = "${webappRoot}/WEB-INF/conf/psml-mapping.xml";

    public boolean doUpdate(ALAction action, RunData rundata, Context context) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 8);
            action.setMode("update");
            rundata.getParameters().add("mode", "update");
            ArrayList<String> msgList = new ArrayList<String>();
            this.setValidator();
            boolean res = false;
            if (this.isOverQuota()) {
                msgList.add(ALLocalizationUtils.getl10n((String)"GADGETS_ALERT_DISC_CAPACITY"));
            } else {
                boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList) && this.updateFormData(rundata, context, msgList);
            }
            if (!res) {
                action.setMode("edit_form");
                this.mode = action.getMode();
            }
            action.setResultData((Object)this);
            if (!msgList.isEmpty()) {
                action.addErrorMessages(msgList);
            }
            action.putData(rundata, context);
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    @Override
    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean success;
        if ("timeline".equals(rundata.getParameters().getString("mode")) || "schedule".equals(rundata.getParameters().getString("mode"))) {
            success = this.updateTemplateFormData(rundata, context, msgList);
        } else if (rundata.getParameters().getString("mode") == null || "".equals(rundata.getParameters().getString("mode"))) {
            success = false;
            msgList.add(ALLocalizationUtils.getl10n((String)"GADGETS_ALERT_SELECT_SETTING"));
        } else {
            success = super.updateFormData(rundata, context, msgList);
        }
        return success;
    }

    protected boolean updateTemplateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            Mapping mapping = PsmlUtils.getMapping(rundata);
            File psmlFile = "timeline".equals(rundata.getParameters().getString("mode")) ? PsmlUtils.getTemplateHtmlDefaultTimelinePsmlFile(rundata) : ("schedule".equals(rundata.getParameters().getString("mode")) ? PsmlUtils.getTemplateHtmlDefaultSchedulePsmlFile(rundata) : PsmlUtils.getTemplateHtmlDefaultPsmlFile(rundata));
            PSMLDocument doc = PsmlUtils.loadDocument(psmlFile, mapping);
            byte[] psmlByte = DBUtils.portletsToBytes((Portlets)doc.getPortlets(), (Mapping)PsmlUtils.getMapping(rundata));
            String psml = new String(psmlByte);
            psml = PsmlUtils.parsePsmlForAllUser(psml);
            psml = PsmlUtils.PSMLEncode(psml);
            PsmlDBUtils.checkAndFixInconsistency("template");
            JetspeedUserProfile profileTemplate = PsmlDBUtils.getTemplateHtmlProfile();
            profileTemplate.setProfile(psml.getBytes());
            Portlets portlets = DBUtils.bytesToPortlets((byte[])psml.getBytes(), (Mapping)mapping);
            List<JetspeedUserProfile> profiles = PsmlDBUtils.getAllUserHtmlProfile();
            for (JetspeedUserProfile profile : profiles) {
                String userName = profile.getUserName();
                PsmlDBUtils.checkAndFixInconsistency(profile.getUserName());
                ALEipUser alEipUser = ALEipUtils.getALEipUser((String)userName);
                if (alEipUser == null) continue;
                long userId = alEipUser.getUserId().getValue();
                boolean isAdmin = ALEipUtils.isAdmin((int)((int)userId));
                PortletUtils.regenerateIds((Portlets)portlets);
                Portlets myportlets = (Portlets)portlets.clone();
                Portlets[] portletList = myportlets.getPortletsArray();
                int length = portletList.length;
                for (int i = 0; i < length; ++i) {
                    Entry[] entries = portletList[i].getEntriesArray();
                    if (entries == null || entries.length <= 0) continue;
                    int ent_length = entries.length;
                    for (int j = 0; j < ent_length; ++j) {
                        Parameter webmailParameter;
                        Parameter scheduleParameter;
                        if ((entries[j].getParent().equals("Schedule") || entries[j].getParent().equals("AjaxScheduleWeekly")) && (scheduleParameter = entries[j].getParameter("p6a-uids")) != null) {
                            scheduleParameter.setValue("");
                            entries[j].setParameter(0, scheduleParameter);
                        }
                        if (!entries[j].getParent().equals("WebMail") || (webmailParameter = entries[j].getParameter("p3a-accounts")) == null) continue;
                        webmailParameter.setValue("");
                        entries[j].setParameter(0, webmailParameter);
                    }
                }
                profile.setProfile(DBUtils.portletsToBytes((Portlets)myportlets, (Mapping)mapping));
                if (!isAdmin) continue;
                ALEipUtils.addAdminPage((String)userName);
            }
            Database.commit();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)DEFAULT_VIEW_STATUS, (String)UPDATE_SUCCESS);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"gadgets", (Throwable)ex);
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)DEFAULT_VIEW_STATUS, (String)UPDATE_ERROR);
            return false;
        }
        return true;
    }
}

