/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.gadgets;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.JetspeedUserProfile;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.gadgets.util.PsmlDBUtils;
import com.aimluck.eip.gadgets.util.PsmlUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.PSMLDocument;
import org.apache.jetspeed.om.profile.Parameter;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.psmlmanager.db.DBUtils;
import org.apache.jetspeed.util.PortletUtils;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.exolab.castor.mapping.Mapping;
import org.xml.sax.InputSource;

public class GagetsPsmlFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)GagetsPsmlFormData.class.getName());
    private ALStringField note;
    private boolean adminUser;
    private String attach_status;
    private String default_status;
    private String all_user_status;
    private static final String UPDATE_SUCCESS = "success";
    private static final String UPDATE_ERROR = "error";
    private static final String ATTACH_VIEW_STATUS = "attach_psml_status";
    private static final String DEFAULT_VIEW_STATUS = "default_psml_status";
    private static final String ALL_USER_VIEW_STATUS = "all_user_psml_status";
    public static final String DEFAULT_MAPPING = "${webappRoot}/WEB-INF/conf/psml-mapping.xml";

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"entityid", (String)"profile");
        this.adminUser = ALEipUtils.isAdminUser((RunData)rundata);
        this.attach_status = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)ATTACH_VIEW_STATUS);
        this.default_status = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)DEFAULT_VIEW_STATUS);
        this.all_user_status = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)ALL_USER_VIEW_STATUS);
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)ATTACH_VIEW_STATUS);
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)DEFAULT_VIEW_STATUS);
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)ALL_USER_VIEW_STATUS);
        super.init(action, rundata, context);
    }

    public void initField() {
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"GADGETS_SETFIELDNAME_NOTE"));
        this.note.setTrim(false);
        this.adminUser = false;
    }

    protected void setValidator() {
    }

    protected boolean validate(List<String> msgList) {
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return true;
    }

    protected void setNote(String psml) {
        this.note.setValue(psml);
    }

    public ALStringField getNote() {
        return this.note;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean success = "default".equals(rundata.getParameters().getString("mode")) ? this.updateDefaultFormData(rundata, context, msgList) : ("all_user".equals(rundata.getParameters().getString("mode")) ? this.updateAllUserFormData(rundata, context, msgList) : this.updateAttachFormData(rundata, context, msgList));
        return success;
    }

    private boolean updateAttachFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            String psml = PsmlDBUtils.getMyHtmlPsml(rundata);
            psml = PsmlUtils.parsePsml(psml);
            if (psml == null) {
                return false;
            }
            psml = PsmlUtils.PSMLEncode(psml);
            PsmlDBUtils.checkAndFixInconsistency("template");
            JetspeedUserProfile profile = PsmlDBUtils.getTemplateHtmlProfile();
            profile.setProfile(psml.getBytes());
            Database.commit();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)ATTACH_VIEW_STATUS, (String)UPDATE_SUCCESS);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"gadgets", (Throwable)ex);
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)ATTACH_VIEW_STATUS, (String)UPDATE_ERROR);
            return false;
        }
        return true;
    }

    private boolean updateDefaultFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            Mapping mapping = PsmlUtils.getMapping(rundata);
            File psmlFile = PsmlUtils.getTemplateHtmlDefaultPsmlFile(rundata);
            PSMLDocument doc = PsmlUtils.loadDocument(psmlFile, mapping);
            byte[] psmlByte = DBUtils.portletsToBytes((Portlets)doc.getPortlets(), (Mapping)PsmlUtils.getMapping(rundata));
            String psml = new String(psmlByte);
            psml = PsmlUtils.parsePsml(psml);
            if (psml == null) {
                return false;
            }
            psml = PsmlUtils.PSMLEncode(psml);
            PsmlDBUtils.checkAndFixInconsistency("template");
            JetspeedUserProfile profile = PsmlDBUtils.getTemplateHtmlProfile();
            profile.setProfile(psml.getBytes());
            Database.commit();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)DEFAULT_VIEW_STATUS, (String)UPDATE_SUCCESS);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"gadgets", (Throwable)ex);
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)DEFAULT_VIEW_STATUS, (String)UPDATE_ERROR);
            return false;
        }
        return true;
    }

    private boolean updateAllUserFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            if (this.isAdminUser()) {
                return false;
            }
            String psml = PsmlDBUtils.getMyHtmlPsml(rundata);
            psml = PsmlUtils.parsePsmlForAllUser(psml);
            psml = PsmlUtils.PSMLEncode(psml);
            PsmlDBUtils.checkAndFixInconsistency("template");
            JetspeedUserProfile profileTemplate = PsmlDBUtils.getTemplateHtmlProfile();
            profileTemplate.setProfile(psml.getBytes());
            Mapping mapping = this.loadMapping();
            Portlets portlets = DBUtils.bytesToPortlets((byte[])psml.getBytes(), (Mapping)mapping);
            List<JetspeedUserProfile> profiles = PsmlDBUtils.getAllUserHtmlProfile();
            for (JetspeedUserProfile profile : profiles) {
                ALEipUser alEipUser;
                String userName = profile.getUserName();
                PsmlDBUtils.checkAndFixInconsistency(profile.getUserName());
                if (profile.getUserName().equals(ALEipUtils.getLoginName((RunData)rundata)) || (alEipUser = ALEipUtils.getALEipUser((String)userName)) == null) continue;
                long userId = alEipUser.getUserId().getValue();
                boolean isAdmin = ALEipUtils.isAdmin((int)((int)userId));
                PortletUtils.regenerateIds((Portlets)portlets);
                Portlets myportlets = (Portlets)portlets.clone();
                Portlets[] portletList = myportlets.getPortletsArray();
                int length = portletList.length;
                for (int i = 0; i < length; ++i) {
                    Entry[] entries = portletList[i].getEntriesArray();
                    if (entries == null || entries.length <= 0) continue;
                    int ent_length = entries.length;
                    for (int j = 0; j < ent_length; ++j) {
                        Parameter webmailParameter;
                        Parameter scheduleParameter;
                        if ((entries[j].getParent().equals("Schedule") || entries[j].getParent().equals("AjaxScheduleWeekly")) && (scheduleParameter = entries[j].getParameter("p6a-uids")) != null) {
                            scheduleParameter.setValue("");
                            entries[j].setParameter(0, scheduleParameter);
                        }
                        if (!entries[j].getParent().equals("WebMail") || (webmailParameter = entries[j].getParameter("p3a-accounts")) == null) continue;
                        webmailParameter.setValue("");
                        entries[j].setParameter(0, webmailParameter);
                    }
                }
                profile.setProfile(DBUtils.portletsToBytes((Portlets)myportlets, (Mapping)mapping));
                if (!isAdmin) continue;
                ALEipUtils.addAdminPage((String)userName);
            }
            Database.commit();
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)ALL_USER_VIEW_STATUS, (String)UPDATE_SUCCESS);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"gadgets", (Throwable)ex);
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)ALL_USER_VIEW_STATUS, (String)UPDATE_ERROR);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    private Mapping loadMapping() throws InitializationException {
        ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance()).getResources("PsmlManager");
        String mapFile = serviceConf.getString("mapping", DEFAULT_MAPPING);
        if ((mapFile = TurbineServlet.getRealPath((String)mapFile)) != null) {
            File map = new File(mapFile);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loading psml mapping file " + mapFile));
            }
            if (map.exists() && map.isFile() && map.canRead()) {
                try {
                    Mapping mapping = new Mapping();
                    InputSource is = new InputSource(new FileReader(map));
                    is.setSystemId(mapFile);
                    mapping.loadMapping(is);
                    return mapping;
                }
                catch (Exception e) {
                    logger.error((Object)"Error in psml mapping creation", (Throwable)e);
                    throw new InitializationException("Error in mapping", (Throwable)e);
                }
            }
            throw new InitializationException("PSML Mapping not found or not a file or unreadable: " + mapFile);
        }
        return null;
    }

    public boolean isAdminUser() {
        return this.adminUser;
    }

    public String getAttachStatus() {
        return this.attach_status;
    }

    public String getDefaultStatus() {
        return this.default_status;
    }

    public String getAllUserStatus() {
        return this.all_user_status;
    }
}

