/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.webmail;

import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.webmail.WebMailAccountSelectData;
import com.aimluck.eip.webmail.WebMailFilterSelectData;
import com.aimluck.eip.webmail.WebMailFolderSelectData;
import com.aimluck.eip.webmail.WebMailSelectData;
import com.aimluck.eip.webmail.util.WebMailUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WebMailAction
extends ALBaseAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)WebMailAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        this.clearWebMailSession(rundata, context);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"WebMail_Normal", (String)"true");
        WebMailSelectData listData = new WebMailSelectData();
        listData.initField();
        listData.loadMailAccountList(rundata, context);
        listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1a-rows")));
        listData.setStrLength(0);
        listData.setFiltersPSML(portlet, context, rundata);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "webmail");
    }

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        String mode = rundata.getParameters().getString("mode");
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"WebMail_Normal", (String)"false");
        try {
            if ("list".equals(mode) || this.getMode() == null) {
                String admintab = rundata.getParameters().getString("admintab");
                if (!StringUtils.isEmpty((String)admintab)) {
                    this.doWebmail_account_list(rundata, context);
                } else {
                    this.doWebmail_list(rundata, context);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"WebMailAction.buildMaximizedContext", (Throwable)e);
        }
    }

    public void doWebmail_list(RunData rundata, Context context) throws Exception {
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"WebMail_Normal", (String)"false");
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        WebMailSelectData listData = new WebMailSelectData();
        listData.initField();
        listData.loadMailAccountList(rundata, context);
        listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1b-rows")));
        listData.setStrLength(0);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "webmail-list");
    }

    public void doWebmail_receive_mails(RunData rundata, Context context) throws Exception {
        WebMailUtils.receiveMailsThread(rundata, context);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"receive");
        this.doWebmail_list(rundata, context);
    }

    public void doWebmail_account_list(RunData rundata, Context context) throws Exception {
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        WebMailAccountSelectData listData = new WebMailAccountSelectData();
        listData.initField();
        listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1c-rows")));
        listData.setStrLength(0);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "webmail-account-list");
    }

    public void doWebmail_filter_list(RunData rundata, Context context) throws Exception {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"unreadmailsummap");
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        WebMailFilterSelectData listData = new WebMailFilterSelectData();
        listData.initField();
        listData.loadMailAccountList(rundata, context);
        listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1d-rows")));
        listData.setStrLength(0);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "webmail-filter-list");
    }

    public void doWebmail_folder_list(RunData rundata, Context context) throws Exception {
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        WebMailFolderSelectData listData = new WebMailFolderSelectData();
        listData.initField();
        listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1d-rows")));
        listData.loadMailAccountList(rundata, context);
        listData.setStrLength(0);
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "webmail-folder-list");
    }

    private void clearWebMailSession(RunData rundata, Context context) {
        JetspeedRunData jdata = (JetspeedRunData)rundata;
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"tab");
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"unreadmailsummap");
        jdata.getUser().removeTemp("accountid");
        jdata.getUser().removeTemp("folderid");
        jdata.getUser().removeTemp("tr_pop3mail_recieve");
        jdata.getUser().removeTemp(new StringBuffer().append(portlet.getID()).append("com.aimluck.eip.webmail.WebMailAccountSelectDatasort").toString());
    }
}

