/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class ScreenLoader
extends GenericLoader {
    private static ScreenLoader instance = new ScreenLoader(TurbineResources.getInt("screen.cache.size", 50));

    private ScreenLoader() {
    }

    private ScreenLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Screen screen) {
        if (this.cache()) {
            this.put(name, screen);
        }
    }

    public ConcreteElement eval(RunData data, String name) throws Exception {
        return this.getInstance(name).build(data);
    }

    public void exec(RunData data, String name) throws Exception {
        this.eval(data, name);
    }

    public Screen getInstance(String name) throws Exception {
        Screen screen = null;
        if (this.cache() && this.containsKey(name)) {
            screen = (Screen)this.get(name);
        } else {
            AssemblerBrokerService ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
            try {
                screen = (Screen)ab.getAssembler("screen", name);
            }
            catch (ClassCastException cce) {
                screen = null;
            }
            if (screen == null) {
                Vector packages = TurbineResources.getVector("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Screen not found: " + name + "\n\tTurbine looked in the following " + "modules.packages path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, screen);
            }
        }
        return screen;
    }

    public static ScreenLoader getInstance() {
        return instance;
    }
}

