/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;

public class FloatField
extends Field {
    public FloatField(XmlField field, Group group) throws Exception {
        super(field, group);
    }

    protected void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        try {
            this.defaultValue = new Float(prop);
        }
        catch (Exception e) {
            Log.error("Could not convert " + prop + " into an Float. (" + this.name + ")");
        }
    }

    protected String getDefaultValidator() {
        return "org.apache.turbine.services.intake.validator.NumberValidator";
    }

    protected void doSetValue(ParameterParser pp) {
        if (this.isMultiValued) {
            String[] ss = pp.getStrings(this.getKey());
            float[] ival = new float[ss.length];
            int i = 0;
            while (i < ss.length) {
                ival[i] = Float.parseFloat(ss[i]);
                ++i;
            }
            this.setTestValue(ival);
        } else {
            this.setTestValue(new Float(pp.getString(this.getKey())));
        }
    }
}

