/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.ldap;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.services.security.ldap.LDAPSecurityConstants;
import org.apache.turbine.services.security.ldap.LDAPUser;
import org.apache.turbine.services.security.ldap.util.ParseExceptionMessage;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.PasswordMismatchException;
import org.apache.turbine.util.security.UnknownEntityException;

public class LDAPUserManager
implements UserManager,
LDAPSecurityConstants {
    public boolean accountExists(User user) throws DataBackendException {
        return this.accountExists(user.getUserName());
    }

    public boolean accountExists(String username) throws DataBackendException {
        try {
            User ldapUser = this.retrieve(username);
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to check account's presence", e);
        }
        return true;
    }

    public User retrieve(String username) throws UnknownEntityException, DataBackendException {
        String dNAttribute = TurbineResources.getString("ldap.dn.attribute");
        String filter = TurbineResources.getString("ldap.user.search.filter");
        String userBaseSearch = TurbineResources.getString("ldap.user.basesearch");
        String dN = null;
        String adminUser = TurbineResources.getString("ldap.admin.username");
        String adminPassword = TurbineResources.getString("ldap.admin.password");
        adminUser = adminUser.replace('/', '=');
        adminUser = adminUser.replace('%', ',');
        LDAPUser ldapUser = null;
        userBaseSearch = userBaseSearch.replace('/', '=');
        userBaseSearch = userBaseSearch.replace('%', ',');
        try {
            DirContext ctx = this.bind(adminUser, adminPassword);
            SearchControls ctls = new SearchControls();
            filter = "(" + filter + "=" + username + ")";
            NamingEnumeration<SearchResult> answer = ctx.search(userBaseSearch, filter, ctls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attribs = sr.getAttributes();
                Log.debug("attribs:  " + attribs.get(dNAttribute));
                dN = attribs.get(dNAttribute).toString();
                Log.debug("dN:  " + dN);
            }
            if (dN == null) {
                throw new UnknownEntityException("The given user: " + username + "\n does not exist.");
            }
            StringTokenizer sT = new StringTokenizer(dN, ":");
            while (sT.hasMoreElements()) {
                dN = sT.nextToken();
            }
            dN = dN.trim();
            ldapUser = new LDAPUser();
            ldapUser.setUserName(dN);
            ldapUser.setTemp("turbine.user", ldapUser);
        }
        catch (NamingException nameEx) {
            throw new DataBackendException("The LDAP server specified is unavailable");
        }
        return ldapUser;
    }

    public User[] retrieve(Criteria criteria) throws DataBackendException {
        Vector users = new Vector(0);
        return users.toArray(new User[0]);
    }

    public User retrieve(String username, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        User user = this.retrieve(username);
        this.authenticate(user, password);
        return user;
    }

    public void store(User user) throws UnknownEntityException, DataBackendException {
        if (!this.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getUserName() + "' does not exist");
        }
    }

    public void authenticate(User user, String password) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        try {
            this.bind(user.getUserName(), password);
        }
        catch (NamingException authEx) {
            throw new PasswordMismatchException("The given password for: " + user.getUserName() + " is invalid\n");
        }
    }

    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        throw new DataBackendException("The method changePassword has no implementation.");
    }

    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        throw new DataBackendException("The method forcePassword has no implementation.");
    }

    public void createAccount(User user, String initialPassword) throws EntityExistsException, DataBackendException {
        throw new DataBackendException("The method createAccount has no implementation.");
    }

    public void removeAccount(User user) throws UnknownEntityException, DataBackendException {
        throw new DataBackendException("The method removeAccount has no implementation.");
    }

    public DirContext bind(String username, String password) throws NamingException, DataBackendException, UnknownEntityException {
        InitialDirContext ctx = null;
        try {
            String host = TurbineResources.getString("ldap.host");
            String port = TurbineResources.getString("ldap.port");
            String providerURL = new String("ldap://" + host + ":" + port);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "ldap.provider");
            env.put("java.naming.provider.url", providerURL);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", username);
            env.put("java.naming.security.credentials", password);
            ctx = new InitialDirContext(env);
            Log.debug("CTX: " + ctx.toString());
        }
        catch (NamingException ne) {
            String errno = ParseExceptionMessage.findErrno(ne.getExplanation());
            if (errno.equals("49")) {
                throw new UnknownEntityException("The given credentials for the administrator are invalid");
            }
            if (errno.equals("22")) {
                throw new DataBackendException("The LDAP server specified is unavailable");
            }
            throw ne;
        }
        catch (Exception e) {
            Log.error(e);
        }
        return ctx;
    }
}

