/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogComment;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.mail.ALAdminMailContext;
import com.aimluck.eip.mail.ALAdminMailMessage;
import com.aimluck.eip.mail.ALMailService;
import com.aimluck.eip.mail.util.ALEipUserAddr;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.blog.BlogAction;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.BlogDetailScreen;
import com.aimluck.eip.modules.screens.BlogEntryFormJSONScreen;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.velocity.VelocityService;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogEntryCommentFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogEntryCommentFormData.class.getName());
    private ALStringField comment;
    private boolean sendEmailToPC = false;
    private boolean sendEmailToCellular = false;
    private int MsgTypeBlog = 0;
    private ALEipUser login_user;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        try {
            this.MsgTypeBlog = ALMailUtils.getSendDestType((int)22);
            this.sendEmailToPC = (this.MsgTypeBlog & 1) > 0;
            this.sendEmailToCellular = (this.MsgTypeBlog & 2) > 0;
        }
        catch (Throwable t) {
            this.sendEmailToPC = false;
            this.sendEmailToCellular = false;
        }
        this.login_user = ALEipUtils.getALEipUser((RunData)rundata);
        int uid = ALEipUtils.getUserId((RunData)rundata);
        if ("commentdel".equals(action.getMode())) {
            String commentid = rundata.getParameters().getString("comment_id");
            int comment_view_uid = BlogUtils.getCommentViewId(rundata, context, uid, commentid);
            this.aclPortletFeature = uid == comment_view_uid ? "blog_entry_reply" : "blog_entry_other_reply";
        }
    }

    public void initField() {
        this.comment = new ALStringField();
        this.comment.setFieldName(ALLocalizationUtils.getl10n((String)"BLOG_COMMENT"));
        this.comment.setTrim(false);
    }

    protected void setValidator() {
        this.comment.setNotNull(true);
        this.comment.limitMaxLength(1000);
    }

    protected boolean validate(List<String> msgList) {
        this.comment.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            String commentid = rundata.getParameters().getString("comment_id");
            EipTBlogComment comment = BlogUtils.getEipTBlogComment(rundata, context, commentid);
            if (comment == null) {
                logger.debug((Object)"[BlogEntryCommentFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            Database.delete((Persistent)comment);
            Database.commit();
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"BlogEntryCommentFormData.deleteFormData", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTBlogEntry parententry = BlogUtils.getEipTBlogParentEntry(rundata, context);
            if (parententry == null) {
                logger.debug((Object)"[BlogEntryCommentFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            int uid = ALEipUtils.getUserId((RunData)rundata);
            Date updateDate = Calendar.getInstance().getTime();
            EipTBlogEntry entry = (EipTBlogEntry)Database.get(EipTBlogEntry.class, (Object)parententry.getEntryId());
            EipTBlogComment blogcomment = (EipTBlogComment)Database.create(EipTBlogComment.class);
            blogcomment.setOwnerId(Integer.valueOf(uid));
            blogcomment.setComment(this.comment.getValue());
            blogcomment.setEipTBlogEntry(entry);
            blogcomment.setCreateDate(Calendar.getInstance().getTime());
            blogcomment.setUpdateDate(updateDate);
            Database.commit();
            List<ALEipUser> recipientList = this.getRecipientList(rundata, context);
            ALEipUser loginName = ALEipUtils.getALEipUser((int)uid);
            BlogUtils.createNewCommentActivity(entry, loginName.getName().getValue(), blogcomment);
            ArrayList<String> recipientNameList = new ArrayList<String>();
            for (ALEipUser recipient : recipientList) {
                recipientNameList.add(recipient.getName().toString());
            }
            BlogUtils.createNewBlogTopicActivity(entry, loginName.getName().toString(), recipientNameList, blogcomment);
            if (this.sendEmailToPC || this.sendEmailToCellular) {
                List destMemberList = ALMailUtils.getALEipUserAddrs(recipientList, (int)ALEipUtils.getUserId((RunData)rundata), (boolean)false);
                String orgId = Database.getDomainName();
                String subject = "[" + JetspeedResources.getString((String)"aipo.alias") + "]\u30d6\u30ed\u30b0\u30b3\u30e1\u30f3\u30c8";
                ArrayList<ALAdminMailMessage> messageList = new ArrayList<ALAdminMailMessage>();
                for (ALEipUserAddr destMember : destMemberList) {
                    ALAdminMailMessage message = new ALAdminMailMessage(destMember);
                    if (this.sendEmailToPC) {
                        message.setPcSubject(subject);
                        message.setPcBody(this.createMsgForPc(rundata));
                    }
                    if (this.sendEmailToCellular) {
                        message.setCellularSubject(subject);
                        message.setCellularBody(this.createMsgForCellPhone(rundata, destMember.getUserId()));
                    }
                    messageList.add(message);
                }
                ALMailService.sendAdminMailAsync((ALAdminMailContext)new ALAdminMailContext(orgId, (int)this.login_user.getUserId().getValue(), messageList, ALMailUtils.getSendDestType((int)22)));
            }
        }
        catch (Exception e) {
            Database.rollback();
            logger.error((Object)"BlogEntryCommentFormData.insertFormData", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    private List<ALEipUser> getRecipientList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        Integer loginUserId = ALEipUtils.getUserId((RunData)rundata);
        EipTBlogEntry parenttopic = BlogUtils.getEipTBlogParentEntry(rundata, context);
        SelectQuery topicQuery = Database.query(EipTBlogComment.class);
        Expression topicExp = ExpressionFactory.matchDbExp((String)"ENTRY_ID", (Object)parenttopic.getEntryId());
        topicQuery.setQualifier(topicExp);
        ArrayList<Integer> userIdList = new ArrayList<Integer>();
        Integer userId = parenttopic.getOwnerId();
        if (!loginUserId.equals(userId)) {
            userIdList.add(userId);
        }
        List topicList = topicQuery.fetchList();
        for (EipTBlogComment topic : topicList) {
            userId = topic.getOwnerId();
            if (userId.equals(loginUserId) || userIdList.contains(userId)) continue;
            userIdList.add(userId);
        }
        if (userIdList.isEmpty()) {
            return new ArrayList<ALEipUser>(0);
        }
        SelectQuery userQuery = Database.query(TurbineUser.class);
        Expression userExp = ExpressionFactory.inDbExp((String)"USER_ID", userIdList);
        userQuery.setQualifier(userExp);
        return ALEipUtils.getUsersFromSelectQuery((SelectQuery)userQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createMsgForPc(RunData rundata) {
        ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
        boolean enableAsp = JetspeedResources.getBoolean((String)"aipo.asp", (boolean)false);
        ALBaseUser user2 = null;
        try {
            user2 = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(user.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        StringWriter out = null;
        String e_mail_addr = user2.getEmail();
        try {
            VelocityService service = (VelocityService)((TurbineServices)TurbineServices.getInstance()).getService("VelocityService");
            Context context = service.getContext();
            context.put("userLastName", (Object)user2.getLastName());
            context.put("userFirstName", (Object)user2.getFirstName());
            if (!e_mail_addr.equals("")) {
                context.put("mailAddress", (Object)("(" + e_mail_addr + ")"));
            }
            context.put("mailNoticeMSG", (Object)ALLocalizationUtils.getl10n((String)"BLOG_YOU_GOT_MAIL_NOTICE"));
            context.put("comment", (Object)ALLocalizationUtils.getl10n((String)"BLOG_MAIL_NOTICE_COMMENT"));
            context.put("commentValue", (Object)this.comment.getValue());
            context.put("accessToAlias", (Object)("[" + ALOrgUtilsService.getAlias() + ALLocalizationUtils.getl10n((String)"BLOG_MAIL_NOTICE_ACCESS_TO") + "]"));
            if (enableAsp) {
                context.put("globalUrl1", (Object)ALMailUtils.getGlobalurl());
            } else {
                context.put("outsideOffice", (Object)ALLocalizationUtils.getl10n((String)"BLOG_MAIL_NOTICE_OUTSIDE_OFFICE"));
                context.put("globalurl2", (Object)ALMailUtils.getGlobalurl());
                context.put("insideOffice", (Object)ALLocalizationUtils.getl10n((String)"BLOG_MAIL_NOTICE_INSIDE_OFFICE"));
                context.put("globalUrl3", (Object)ALMailUtils.getLocalurl());
            }
            context.put("Alias", (Object)ALOrgUtilsService.getAlias());
            out = new StringWriter();
            service.handleRequest(context, "mail/getBlogNotice.vm", (Writer)out);
            out.flush();
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            StringBuffer trace = new StringBuffer();
            String message = e.getMessage();
            logger.warn((Object)message, (Throwable)e);
            e.printStackTrace();
            trace.append("\n").append(message).append("\n").append(e.toString());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createMsgForCellPhone(RunData rundata, int destUserID) {
        ALEipUser user = ALEipUtils.getALEipUser((RunData)rundata);
        ALBaseUser user2 = null;
        try {
            user2 = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(user.getUserId().toString()));
        }
        catch (Exception e) {
            return "";
        }
        StringWriter out = null;
        String e_mail_addr = user2.getEmail();
        try {
            ALEipUser destUser;
            VelocityService service = (VelocityService)((TurbineServices)TurbineServices.getInstance()).getService("VelocityService");
            Context context = service.getContext();
            context.put("userLastName", (Object)user2.getLastName());
            context.put("userFirstName", (Object)user2.getFirstName());
            if (!e_mail_addr.equals("")) {
                context.put("mailAddress", (Object)("(" + e_mail_addr + ")"));
            }
            context.put("mailNoticeMSG", (Object)ALLocalizationUtils.getl10n((String)"BLOG_YOU_GOT_MAIL_NOTICE"));
            context.put("comment", (Object)ALLocalizationUtils.getl10n((String)"BLOG_MAIL_NOTICE_COMMENT"));
            context.put("commentValue", (Object)this.comment.getValue());
            try {
                destUser = ALEipUtils.getALEipUser((int)destUserID);
            }
            catch (ALDBErrorException ex) {
                logger.error((Object)"BlogEntryCommentFormData.createMsgForCellPhone", (Throwable)ex);
                String string = "";
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                return string;
            }
            context.put("accessToAlias", (Object)("[" + ALOrgUtilsService.getAlias() + ALLocalizationUtils.getl10n((String)"BLOG_MAIL_NOTICE_ACCESS_TO") + "]"));
            context.put("globalUrl1", (Object)(ALMailUtils.getGlobalurl() + "?key=" + ALCellularUtils.getCellularKey((ALEipUser)destUser)));
            context.put("Alias", (Object)ALOrgUtilsService.getAlias());
            out = new StringWriter();
            service.handleRequest(context, "mail/getBlogNotice.vm", (Writer)out);
            out.flush();
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            StringBuffer trace = new StringBuffer();
            String message = e.getMessage();
            logger.warn((Object)message, (Throwable)e);
            e.printStackTrace();
            trace.append("\n").append(message).append("\n").append(e.toString());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        try {
            if (!this.doCheckSecurity(rundata, context)) {
                return false;
            }
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 4);
            action.setMode("insert");
            ArrayList<String> msgList = new ArrayList<String>();
            this.setValidator();
            boolean res = false;
            if (this.isOverQuota()) {
                msgList.add(ALLocalizationUtils.getl10n((String)"COMMON_FULL_DISK_DELETE_DETA_OR_CHANGE_PLAN"));
            } else {
                boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList) && this.insertFormData(rundata, context, msgList);
            }
            if (!res) {
                action.setMode("new_form");
                this.setMode(action.getMode());
            }
            if (action instanceof BlogEntryFormJSONScreen) {
                action.setResultData((Object)this);
                action.addErrorMessages(msgList);
                action.putData(rundata, context);
            } else {
                BlogAction blogAction = (BlogAction)action;
                blogAction.setResultDataOnCommentDetail((Object)this);
                blogAction.addErrorMessagesOnCommentDetail(msgList);
                blogAction.putDataOnCommentDetail(rundata, context);
            }
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            ArrayList<String> msgList = new ArrayList<String>();
            boolean res = this.setFormData(rundata, context, msgList);
            if (action instanceof BlogDetailScreen) {
                BlogDetailScreen blogAction = (BlogDetailScreen)action;
                blogAction.setResultDataOnCommentDetail((Object)this);
                blogAction.addErrorMessagesOnCommentDetail(msgList);
                blogAction.putDataOnCommentDetail(rundata, context);
            } else {
                BlogAction blogAction = (BlogAction)action;
                blogAction.setResultDataOnCommentDetail((Object)this);
                blogAction.addErrorMessagesOnCommentDetail(msgList);
                blogAction.putDataOnCommentDetail(rundata, context);
            }
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        return res;
    }

    public ALStringField getComment() {
        return this.comment;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

