/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.BlogThemaFormData;
import com.aimluck.eip.blog.BlogThemaResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlog;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogFile;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogThema;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALFileNotRemovedException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogEntryFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogEntryFormData.class.getName());
    private ALStringField title;
    private ALStringField note;
    private ALNumberField blog_id;
    private ALNumberField thema_id;
    private ALStringField allow_comments;
    private ALDateTimeField create_date;
    private List<BlogThemaResultData> themaList;
    private boolean is_new_thema;
    private List<FileuploadLiteBean> fileuploadList = null;
    private String folderName = null;
    private int uid;
    private String user_name;
    private boolean has_photo;
    private EipTBlog blog;
    private EipTBlogThema thema;
    private BlogThemaFormData blogthema;
    private String orgId;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.is_new_thema = rundata.getParameters().getBoolean("is_new_thema");
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.orgId = Database.getDomainName();
        this.folderName = rundata.getParameters().getString("folderName");
        ALEipUser user = ALEipManager.getInstance().getUser(Integer.valueOf(this.uid));
        this.user_name = user.getAliasName().getValue();
        this.has_photo = user.hasPhoto();
        int view_uid = BlogUtils.getViewId(rundata, context, this.uid);
        this.aclPortletFeature = view_uid == this.uid ? "blog_entry_self" : "blog_entry_other";
    }

    public void initField() {
        this.create_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.create_date.setFieldName(ALLocalizationUtils.getl10n((String)"BLOG_DAY_HOUR"));
        this.title = new ALStringField();
        this.title.setFieldName(ALLocalizationUtils.getl10n((String)"BLOG_TITLE"));
        this.title.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"BLOG_ENTRY"));
        this.note.setTrim(false);
        this.blog_id = new ALNumberField();
        this.blog_id.setFieldName(ALLocalizationUtils.getl10n((String)"BLOG_BLOG"));
        this.thema_id = new ALNumberField();
        this.thema_id.setFieldName(ALLocalizationUtils.getl10n((String)"BLOG_THEME"));
        this.allow_comments = new ALStringField();
        this.allow_comments.setFieldName(ALLocalizationUtils.getl10n((String)"BLOG_ALLOW_COMMENT"));
        this.allow_comments.setValue("T");
        this.allow_comments.setTrim(true);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
        this.blogthema = new BlogThemaFormData();
        this.blogthema.initField();
    }

    public void loadThemaList(RunData rundata, Context context) {
        this.themaList = BlogUtils.getThemaList(rundata, context);
    }

    protected void setValidator() {
        this.create_date.setNotNull(true);
        this.title.setNotNull(true);
        this.title.limitMaxLength(50);
        this.note.limitMaxLength(10000);
        this.blogthema.setValidator();
    }

    protected boolean validate(List<String> msgList) {
        this.create_date.validate(msgList);
        this.title.validate(msgList);
        this.note.validate(msgList);
        if (this.is_new_thema) {
            this.blogthema.setMode("insert");
            this.blogthema.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTBlogEntry entry = BlogUtils.getEipTBlogEntry(rundata, context);
            if (entry == null) {
                return false;
            }
            this.create_date.setValue(entry.getCreateDate());
            this.title.setValue(entry.getTitle());
            this.note.setValue(entry.getNote());
            this.thema_id.setValue(entry.getEipTBlogThema().getThemaId().longValue());
            this.allow_comments.setValue(entry.getAllowComments());
            SelectQuery filequery = Database.query(EipTBlogFile.class);
            Expression fileexp = ExpressionFactory.matchDbExp((String)"eipTBlogEntry.ENTRY_ID", (Object)entry.getEntryId());
            filequery.setQualifier(fileexp);
            List files = filequery.fetchList();
            FileuploadLiteBean filebean = null;
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                EipTBlogFile file = (EipTBlogFile)files.get(i);
                filebean = new FileuploadLiteBean();
                filebean.initField();
                filebean.setFolderName("DBF" + Integer.toString(file.getFileId()));
                filebean.setFileName(file.getTitle());
                filebean.setFileId(file.getFileId().intValue());
                this.fileuploadList.add(filebean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"BlogEntryFormData.loadFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTBlogEntry entry = BlogUtils.getEipTBlogEntry(rundata, context);
            if (entry == null) {
                return false;
            }
            int entityId = entry.getEntryId();
            String todoName = entry.getTitle();
            int userId = ALEipUtils.getTurbineUser((int)entry.getOwnerId()).getUserId();
            ArrayList<String> fpaths = new ArrayList<String>();
            List files = entry.getEipTBlogFiles();
            if (files != null && files.size() > 0) {
                int size = files.size();
                for (int i = 0; i < size; ++i) {
                    fpaths.add(((EipTBlogFile)files.get(i)).getFilePath());
                }
                BlogUtils.deleteFiles(entityId, this.orgId, userId, fpaths);
            }
            Database.delete((Persistent)entry);
            Database.commit();
            TimelineUtils.deleteTimelineActivity((RunData)rundata, (Context)context, (String)"blog", (String)entry.getEntryId().toString());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 110, todoName);
        }
        catch (ALFileNotRemovedException fe) {
            Database.rollback();
            logger.error((Object)"BlogEntryFormData.deleteFormData", (Throwable)fe);
            msgList.add(ALLocalizationUtils.getl10n((String)"ERROR_FILE_DETELE_FAILURE"));
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"BlogEntryFormData.deleteFormData", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = true;
        try {
            if (this.is_new_thema && (res = this.blogthema.insertFormData(rundata, context, msgList))) {
                this.thema_id.setValue((long)this.blogthema.getThemaId());
            }
            if (res) {
                this.thema = (EipTBlogThema)Database.get(EipTBlogThema.class, (Object)((int)this.thema_id.getValue()));
                this.blog = BlogUtils.getEipTBlog(rundata, context);
                if (this.blog == null) {
                    if (!this.insertBlogData(rundata, context)) {
                        // empty if block
                    }
                } else {
                    this.blog_id.setValue(this.blog.getBlogId().longValue());
                }
                EipTBlogEntry entry = (EipTBlogEntry)Database.create(EipTBlogEntry.class);
                entry.setOwnerId(Integer.valueOf(this.uid));
                entry.setTitle(this.title.getValue());
                entry.setNote(this.note.getValue());
                entry.setEipTBlog(this.blog);
                entry.setEipTBlogThema(this.thema);
                entry.setAllowComments("T");
                entry.setCreateDate(this.create_date.getValue());
                entry.setUpdateDate(Calendar.getInstance().getTime());
                this.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, entry, msgList);
                Database.commit();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.blog.getBlogId().intValue(), 110, this.title.getValue());
                String loginName = ALEipUtils.getALEipUser((int)this.uid).getName().getValue();
                BlogUtils.createNewBlogActivity(entry, loginName, true);
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"BlogEntryFormData.insertFormData", (Throwable)ex);
            return false;
        }
        return res;
    }

    private List<Integer> getRequestedHasFileIdList(List<FileuploadLiteBean> attachmentFileNameList) {
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        FileuploadLiteBean filebean = null;
        if (attachmentFileNameList != null) {
            int size = attachmentFileNameList.size();
            for (int i = 0; i < size; ++i) {
                filebean = attachmentFileNameList.get(i);
                if (filebean.isNewFile()) continue;
                int index = filebean.getFileId();
                idlist.add(index);
            }
        }
        return idlist;
    }

    private boolean insertAttachmentFiles(List<FileuploadLiteBean> fileuploadList, String folderName, int uid, EipTBlogEntry entry, List<String> msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        try {
            int length = fileuploadList.size();
            ArrayList<FileuploadLiteBean> newfilebeans = new ArrayList<FileuploadLiteBean>();
            FileuploadLiteBean filebean = null;
            for (int i = 0; i < length; ++i) {
                filebean = fileuploadList.get(i);
                if (!filebean.isNewFile()) continue;
                newfilebeans.add(filebean);
            }
            int newfilebeansSize = newfilebeans.size();
            if (newfilebeansSize > 0) {
                FileuploadLiteBean newfilebean = null;
                for (int j = 0; j < newfilebeansSize; ++j) {
                    newfilebean = (FileuploadLiteBean)newfilebeans.get(j);
                    String[] acceptExts = ImageIO.getWriterFormatNames();
                    FileuploadUtils.ShrinkImageSet shrinkImageSet = FileuploadUtils.getBytesShrinkFilebean((String)this.orgId, (String)folderName, (int)uid, (FileuploadLiteBean)newfilebean, (String[])acceptExts, (int)86, (int)86, msgList, (boolean)true);
                    String filename = j + "_" + String.valueOf(System.nanoTime());
                    EipTBlogFile file = (EipTBlogFile)Database.create(EipTBlogFile.class);
                    file.setOwnerId(Integer.valueOf(uid));
                    file.setTitle(newfilebean.getFileName());
                    file.setFilePath(BlogUtils.getRelativePath(filename));
                    if (shrinkImageSet != null && shrinkImageSet.getShrinkImage() != null) {
                        file.setFileThumbnail(shrinkImageSet.getShrinkImage());
                    }
                    file.setEipTBlogEntry(entry);
                    file.setCreateDate(Calendar.getInstance().getTime());
                    file.setUpdateDate(Calendar.getInstance().getTime());
                    if (shrinkImageSet != null && shrinkImageSet.getFixImage() != null) {
                        ALStorageService.createNewFile((InputStream)new ByteArrayInputStream(shrinkImageSet.getFixImage()), (String)(BlogUtils.FOLDER_FILEDIR_BLOG + ALStorageService.separator() + Database.getDomainName() + ALStorageService.separator() + BlogUtils.CATEGORY_KEY + ALStorageService.separator() + uid + ALStorageService.separator() + filename));
                        continue;
                    }
                    ALStorageService.copyTmpFile((int)uid, (String)folderName, (String)String.valueOf(newfilebean.getFileId()), (String)BlogUtils.FOLDER_FILEDIR_BLOG, (String)(BlogUtils.CATEGORY_KEY + ALStorageService.separator() + uid), (String)filename);
                }
                ALStorageService.deleteTmpFolder((int)uid, (String)folderName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"BlogEntryFormData.insertAttachmentFiles", (Throwable)e);
        }
        return true;
    }

    private boolean insertBlogData(RunData rundata, Context context) {
        try {
            this.blog = (EipTBlog)Database.create(EipTBlog.class);
            this.blog.setOwnerId(Integer.valueOf(this.uid));
            this.blog.setCreateDate(Calendar.getInstance().getTime());
            this.blog.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            this.blog_id.setValue(this.blog.getBlogId().longValue());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"BlogEntryFormData.", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = false;
        try {
            EipTBlogEntry entry = BlogUtils.getEipTBlogEntry(rundata, context);
            if (entry == null) {
                return false;
            }
            if (this.is_new_thema) {
                res = this.blogthema.insertFormData(rundata, context, msgList);
                if (res) {
                    this.thema = BlogUtils.getEipTBlogThema(Long.valueOf(this.blogthema.getThemaId()));
                    this.thema_id.setValue(this.thema.getThemaId().longValue());
                }
            } else {
                this.thema = (EipTBlogThema)Database.get(EipTBlogThema.class, (Object)((int)this.thema_id.getValue()));
                res = true;
            }
            if (res) {
                entry.setTitle(this.title.getValue());
                entry.setNote(this.note.getValue());
                entry.setEipTBlogThema(this.thema);
                entry.setAllowComments("T");
                entry.setCreateDate(this.create_date.getValue());
                entry.setUpdateDate(Calendar.getInstance().getTime());
                List<Integer> attIdList = this.getRequestedHasFileIdList(this.fileuploadList);
                List<EipTBlogFile> files = BlogUtils.getEipTBlogFileList(entry.getEntryId());
                if (files != null) {
                    int size = files.size();
                    for (int i = 0; i < size; ++i) {
                        EipTBlogFile file = files.get(i);
                        if (attIdList.contains(file.getFileId())) continue;
                        ALStorageService.deleteFile((String)(BlogUtils.getSaveDirPath(this.orgId, this.uid) + file.getFilePath()));
                        Database.delete((Persistent)file);
                    }
                }
                this.insertAttachmentFiles(this.fileuploadList, this.folderName, this.uid, entry, msgList);
                Database.commit();
                String loginName = ALEipUtils.getALEipUser((int)this.uid).getName().getValue();
                BlogUtils.createNewBlogActivity(entry, loginName, false);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entry.getEntryId().intValue(), 110, this.title.getValue());
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"BlogEntryFormData.", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res;
        if (this.create_date.toString().equals("")) {
            this.create_date.setValue(Calendar.getInstance().getTime());
        }
        if (res = super.setFormData(rundata, context, msgList)) {
            try {
                this.blogthema.setFormData(rundata, context, msgList);
                this.fileuploadList = BlogUtils.getFileuploadList(rundata);
            }
            catch (Exception ex) {
                logger.error((Object)"BlogEntryFormData.", (Throwable)ex);
            }
        }
        return res;
    }

    public ALNumberField getThemaId() {
        return this.thema_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getTitle() {
        return this.title;
    }

    public ALDateTimeField getCreateDate() {
        return this.create_date;
    }

    public List<BlogThemaResultData> getThemaList() {
        return this.themaList;
    }

    public boolean isNewThema() {
        return this.is_new_thema;
    }

    public BlogThemaFormData getBlogThema() {
        return this.blogthema;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public int getUserId() {
        return this.uid;
    }

    public String getUserName() {
        return this.user_name;
    }

    public boolean hasPhoto() {
        return this.has_photo;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public void setThemaId(long i) {
        this.thema_id.setValue(i);
    }
}

