/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BlogEntryResultData
implements ALData {
    private ALNumberField entry_id;
    private ALNumberField owner_id;
    private ALStringField title;
    private ALStringField note;
    private ALNumberField blog_id;
    private ALNumberField thema_id;
    private ALStringField thema_name;
    private boolean allow_comments;
    private ALDateTimeField title_date;
    private ALStringField create_date;
    private ALDateTimeField create_date_alternative;
    private ALDateTimeField update_date;
    private List<FileuploadBean> attachmentFileList = null;
    private int comments_num;
    private int day;
    private ALEipUser user = null;

    public void initField() {
        this.entry_id = new ALNumberField();
        this.owner_id = new ALNumberField();
        this.title = new ALStringField();
        this.note = new ALStringField();
        this.blog_id = new ALNumberField();
        this.thema_id = new ALNumberField();
        this.thema_name = new ALStringField();
        this.allow_comments = true;
        this.title_date = new ALDateTimeField();
        this.create_date = new ALStringField();
        this.create_date_alternative = new ALDateTimeField();
        this.update_date = new ALDateTimeField();
        this.attachmentFileList = new ArrayList<FileuploadBean>();
        this.day = 0;
        this.comments_num = 0;
    }

    public ALNumberField getThemaId() {
        return this.thema_id;
    }

    public String getThemaName() {
        return this.thema_name.toString();
    }

    public String getThemaNameHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.thema_name.toString());
    }

    public ALNumberField getEntryId() {
        return this.entry_id;
    }

    public String getTitle() {
        return this.title.toString();
    }

    public String getTitleHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.title.toString());
    }

    public void setThemaId(long i) {
        this.thema_id.setValue(i);
    }

    public void setThemaName(String string) {
        this.thema_name.setValue(string);
    }

    public void setEntryId(long i) {
        this.entry_id.setValue(i);
    }

    public void setTitle(String string) {
        this.title.setValue(string);
    }

    public String getNote() {
        return ALEipUtils.getMessageList((String)this.note.getValue());
    }

    public String getCompressedNote() {
        return BlogUtils.compressString(this.getNote());
    }

    public boolean allowComments() {
        return this.allow_comments;
    }

    public void setNote(String string) {
        this.note.setValue(string);
    }

    public void setAllowComments(boolean bool) {
        this.allow_comments = bool;
    }

    public ALDateTimeField getTitleDate() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.title_date);
    }

    public void setTitleDate(Date date) {
        if (date == null) {
            return;
        }
        this.title_date.setValue(date);
    }

    public ALStringField getCreateDate() {
        return this.create_date;
    }

    public ALDateTimeField getCreateDateAlternative() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.create_date_alternative);
    }

    public ALDateTimeField getUpdateDate() {
        return ALEipUtils.getFormattedTime((ALDateTimeField)this.update_date);
    }

    public void setCreateDate(String string) {
        this.create_date.setValue(string);
    }

    public void setCreateDateAlternative(Date date) {
        this.create_date_alternative.setValue(date);
    }

    public void setUpdateDate(Date date) {
        this.update_date.setValue(date);
    }

    public ALNumberField getOwnerId() {
        return this.owner_id;
    }

    public void setOwnerId(long i) {
        this.owner_id.setValue(i);
    }

    public ALStringField getOwnerName() {
        ALStringField field = new ALStringField();
        ALEipUser user = this.getUser();
        if (user != null) {
            field.setValue(user.getAliasName().getValue());
        }
        return field;
    }

    public ALNumberField getBlogId() {
        return this.blog_id;
    }

    public void setBlogId(long i) {
        this.blog_id.setValue(i);
    }

    public List<FileuploadBean> getAttachmentFileList() {
        return this.attachmentFileList;
    }

    public void setAttachmentFiles(List<FileuploadBean> list) {
        this.attachmentFileList = list;
    }

    public int getCommentsNum() {
        return this.comments_num;
    }

    public void setCommentsNum(int i) {
        this.comments_num = i < 0 ? 0 : i;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int i) {
        this.day = i;
    }

    public boolean hasPhoto() {
        ALEipUser user = this.getUser();
        if (user != null) {
            return user.hasPhoto();
        }
        return false;
    }

    public long getPhotoModified() {
        ALEipUser user = this.getUser();
        if (user != null) {
            return user.getPhotoModified();
        }
        return 0L;
    }

    public ALEipUser getUser() {
        if (this.user == null) {
            this.user = ALEipManager.getInstance().getUser(Integer.valueOf((int)this.owner_id.getValue()));
        }
        return this.user;
    }
}

