/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.blog;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.blog.BlogUserResultData;
import com.aimluck.eip.blog.util.BlogUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTBlogEntry;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class BlogUserSelectData
extends ALAbstractSelectData<BlogUserResultData, BlogUserResultData>
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)BlogUserSelectData.class.getName());
    private String target_group_name;
    private List<ALEipGroup> myGroupList = null;
    private int login_uid = -1;
    private List<Integer> latestBlogerIds = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.target_group_name = BlogUtils.getTargetGroupName(rundata, context);
        this.login_uid = ALEipUtils.getUserId((RunData)rundata);
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList<ALEipGroup>();
        int length = myGroups.size();
        for (int i = 0; i < length; ++i) {
            this.myGroupList.add((ALEipGroup)myGroups.get(i));
        }
        super.init(action, rundata, context);
    }

    public ResultList<BlogUserResultData> selectList(RunData rundata, Context context) {
        try {
            this.latestBlogerIds = this.getLatestBlogerIds();
            String groupname = null;
            groupname = this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all") ? this.target_group_name : "LoginUser";
            List<BlogUserResultData> list2 = BlogUtils.getBlogUserResultDataList(groupname);
            return new ResultList(list2, this.getCurrentPage(), list2.size(), list2.size());
        }
        catch (Exception ex) {
            logger.error((Object)"blog", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultData(BlogUserResultData rd) {
        if (this.latestBlogerIds != null && this.latestBlogerIds.contains((int)rd.getUserId().getValue())) {
            rd.setNewlyCreateEntry(true);
        } else {
            rd.setNewlyCreateEntry(false);
        }
        return rd;
    }

    private List<Integer> getLatestBlogerIds() {
        try {
            ALDateTimeField field = new ALDateTimeField("yyyy-MM-dd");
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1);
            field.setValue(cal.getTime());
            SelectQuery query = Database.query(EipTBlogEntry.class);
            Expression exp = ExpressionFactory.greaterOrEqualExp((String)"createDate", (Object)field.getValue());
            query.setQualifier(exp);
            List list = query.fetchList();
            if (list == null || list.size() <= 0) {
                return null;
            }
            ArrayList<Integer> blogerids = new ArrayList<Integer>();
            Integer id = null;
            EipTBlogEntry entry = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                entry = (EipTBlogEntry)list.get(i);
                id = entry.getOwnerId();
                if (blogerids.contains(id)) continue;
                blogerids.add(id);
            }
            return blogerids;
        }
        catch (Exception e) {
            return null;
        }
    }

    public BlogUserResultData selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultDataDetail(BlogUserResultData obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public Map<Integer, ALEipPost> getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List<ALEipGroup> getMyGroupList() {
        return this.myGroupList;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public int getLoginUid() {
        return this.login_uid;
    }

    public String getAclPortletFeature() {
        return "blog_entry_other";
    }
}

