/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.screens;

import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.screens.ALXlsScreen;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.timecard.TimecardListResultData;
import com.aimluck.eip.timecard.TimecardResultData;
import com.aimluck.eip.timecard.TimecardSelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimecardXlsExportScreen
extends ALXlsScreen {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimecardXlsExportScreen.class.getName());
    public static final String FILE_NAME = "timecard.xls";
    private String userid;
    private String aclPortletFeature = null;

    public void init(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String target_user_id = rundata.getParameters().getString("target_user_id");
        this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.aclPortletFeature = target_user_id == null || "".equals(target_user_id) || this.userid.equals(target_user_id) ? "timecard_timecard_self" : "timecard_timecard_other";
        super.init(rundata, context);
    }

    protected boolean createHSSFWorkbook(RunData rundata, Context context, HSSFWorkbook wb) {
        try {
            this.setupTimecardSheet(rundata, context, wb);
        }
        catch (Exception e) {
            logger.error((Object)"TimecardCsvExportScreen", (Throwable)e);
            return false;
        }
        return true;
    }

    private void setupTimecardSheet(RunData rundata, Context context, HSSFWorkbook wb) throws Exception {
        TimecardSelectData listData = new TimecardSelectData();
        listData.initField();
        listData.setRowsNum(1000);
        listData.doViewList((ALAction)this, rundata, context);
        String sheet_name = "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9";
        String[] headers = new String[]{"\u65e5\u4ed8", "\u5408\u8a08", "\u72b6\u614b", "\u52e4\u6020\u6642\u9593", "\u4fee\u6b63\u7406\u7531"};
        short[] cell_enc_types = new short[]{1, 0, 1, 1, 1};
        HSSFSheet sheet = this.createHSSFSheet(wb, sheet_name, headers, cell_enc_types);
        int rowcount = 0;
        HSSFCellStyle style_col = wb.createCellStyle();
        style_col.setVerticalAlignment((short)1);
        style_col.setAlignment((short)5);
        TimecardListResultData tclistrd = null;
        List<String> daykeys = listData.getDateListKeys();
        int daykeysize = daykeys.size();
        for (int i = 0; i < daykeysize; ++i) {
            tclistrd = listData.getDateListValue(daykeys.get(i));
            List<TimecardResultData> viewlist = tclistrd.getViewList();
            int viewlistsize = viewlist.size();
            for (int j = 0; j < viewlistsize; ++j) {
                TimecardResultData rd = viewlist.get(j);
                String workStr = null;
                workStr = "0".equals(rd.getWorkFlag().toString()) ? "\u9000\u52e4" : "\u51fa\u52e4";
                String[] rows = new String[]{tclistrd.getDateStr(), tclistrd.getSummayTimes(), workStr, rd.getWorkDateStr(), rd.getReason().toString()};
                this.addRow(sheet.createRow(++rowcount), cell_enc_types, rows);
            }
            sheet.addMergedRegion(new Region(rowcount - viewlistsize + 1, 0, rowcount, 0));
            HSSFRow row = sheet.getRow(rowcount - viewlistsize + 1);
            HSSFCell cell1 = row.getCell((short)0);
            cell1.setCellStyle(style_col);
            sheet.addMergedRegion(new Region(rowcount - viewlistsize + 1, 1, rowcount, 1));
            HSSFCell cell2 = row.getCell((short)1);
            cell2.setCellStyle(style_col);
        }
        int uid = ALEipUtils.getUserId((RunData)rundata);
        ALEventlogFactoryService.getInstance().getEventlogHandler().logXlsScreen(uid, "\u30bf\u30a4\u30e0\u30ab\u30fc\u30c9\u51fa\u529b", 151);
    }

    protected String getFileName() {
        return FILE_NAME;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

