/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timecard;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecard;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.timecard.util.TimecardUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimecardFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimecardFormData.class.getName());
    private ALNumberField timecard_id;
    private ALNumberField user_id;
    private ALStringField work_flag;
    private ALDateTimeField work_date;
    private ALStringField reason;
    private ALDateField create_date;
    private ALDateField update_date;
    private int entity_id;
    private int login_uid;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.login_uid = ALEipUtils.getUserId((RunData)rundata);
    }

    public void initField() {
        this.timecard_id = new ALNumberField();
        this.user_id = new ALNumberField();
        this.work_flag = new ALStringField();
        this.work_flag.setValue("0");
        this.work_date = new ALDateTimeField();
        this.work_date.setValue(new Date());
        this.work_date.setFieldName("\u52e4\u6020\u6642\u9593");
        this.reason = new ALStringField();
        this.reason.setFieldName("\u4fee\u6b63\u7406\u7531");
        this.create_date = new ALDateField();
        this.create_date.setValue(new Date());
        this.update_date = new ALDateField();
        this.update_date.setValue(new Date());
    }

    protected void setValidator() {
        this.reason.setNotNull(true);
        this.reason.limitMaxLength(1000);
        this.work_date.setNotNull(true);
    }

    protected boolean validate(List<String> msgList) {
        try {
            if (this.getMode() == "insert") {
                SelectQuery workflg_query = Database.query(EipTTimecard.class);
                Expression workflg_exp = ExpressionFactory.matchExp((String)"userId", (Object)this.login_uid);
                workflg_query.setQualifier(workflg_exp);
                workflg_query.orderDesending("workDate");
                List workflg_list = workflg_query.fetchList();
                if (workflg_list != null && workflg_list.size() > 0) {
                    EipTTimecard record = (EipTTimecard)workflg_list.get(0);
                    return !record.getWorkFlag().equals(this.work_flag.getValue());
                }
                return true;
            }
            Calendar cal = Calendar.getInstance();
            if (cal.getTime().before(this.work_date.getValue())) {
                msgList.add("\u300e <span class='em'>\u52e4\u6020\u6642\u9593</span> \u300f\u306f\u300e <span class='em'>\u73fe\u5728\u306e\u6642\u523b</span> \u300f\u4ee5\u524d\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                return false;
            }
            cal.setTime(this.work_date.getValue());
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(14, 0);
            SelectQuery query = Database.query(EipTTimecard.class);
            Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"workDate", (Object)cal.getTime());
            cal.add(2, 1);
            Expression exp12 = ExpressionFactory.lessExp((String)"workDate", (Object)cal.getTime());
            query.setQualifier(exp11.andExp(exp12));
            Expression exp21 = ExpressionFactory.matchExp((String)"userId", (Object)this.login_uid);
            query.andQualifier(exp21);
            query.orderAscending("workDate");
            List list = query.fetchList();
            if (list != null && list.size() > 0) {
                EipTTimecard timecard0 = this.getNearlyAboveRecord(list, this.entity_id);
                EipTTimecard timecard1 = this.getNearlyBelowRecord(list, this.entity_id);
                if (timecard1 != null) {
                    if (this.compareToDate(timecard1.getWorkDate(), this.work_date.getValue()) == 2) {
                        if (timecard0 != null && this.compareToDate(timecard0.getWorkDate(), this.work_date.getValue()) != 1) {
                            msgList.add("\u300e <span class='em'>\u52e4\u6020\u6642\u9593</span> \u300f\u306f\u300e <span class='em'>\u524d\u306e\u52e4\u6020\u6642\u9593</span> \u300f\u4ee5\u964d\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                        }
                    } else {
                        msgList.add("\u300e <span class='em'>\u52e4\u6020\u6642\u9593</span> \u300f\u306f\u300e <span class='em'>\u5f8c\u306e\u52e4\u6020\u6642\u9593</span> \u300f\u4ee5\u524d\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                    }
                } else if (timecard0 != null && this.compareToDate(timecard0.getWorkDate(), this.work_date.getValue()) != 1) {
                    msgList.add("\u300e <span class='em'>\u52e4\u6020\u6642\u9593</span> \u300f\u306f\u300e <span class='em'>\u524d\u306e\u52e4\u6020\u6642\u9593</span> \u300f\u4ee5\u964d\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"timecard", (Throwable)ex);
            return false;
        }
        this.reason.validate(msgList);
        this.work_date.validate(msgList);
        return msgList.size() == 0;
    }

    private EipTTimecard getNearlyAboveRecord(List<EipTTimecard> list, int timecard_id) {
        EipTTimecard result = null;
        EipTTimecard record = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            record = list.get(i);
            if (record.getTimecardId() >= timecard_id) {
                return result;
            }
            result = record;
        }
        return null;
    }

    private EipTTimecard getNearlyBelowRecord(List<EipTTimecard> list, int timecard_id) {
        EipTTimecard record = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            record = list.get(i);
            if (record.getTimecardId() <= timecard_id) continue;
            return record;
        }
        return null;
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res && this.getMode() == "update") {
            try {
                this.entity_id = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return res;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTTimecard timecard = TimecardUtils.getEipTTimecard(rundata, context);
            if (timecard == null) {
                return false;
            }
            this.timecard_id.setValue(timecard.getTimecardId().longValue());
            this.user_id.setValue((long)timecard.getUserId().intValue());
            this.work_flag.setValue(timecard.getWorkFlag());
            this.work_date.setValue(timecard.getWorkDate());
            this.reason.setValue(timecard.getReason());
            this.create_date.setValue(timecard.getCreateDate());
            this.update_date.setValue(timecard.getUpdateDate());
        }
        catch (Exception ex) {
            logger.error((Object)"timecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTTimecard timecard = TimecardUtils.getEipTTimecard(rundata, context);
            if (timecard == null) {
                return false;
            }
            Database.delete((Persistent)timecard);
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(timecard.getTimecardId().intValue(), 150, this.reason.getValue());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"timecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTTimecard timecard = (EipTTimecard)Database.create(EipTTimecard.class);
            timecard.setUserId(Integer.valueOf(ALEipUtils.getUserId((RunData)rundata)));
            timecard.setWorkFlag(this.work_flag.getValue());
            timecard.setWorkDate(Calendar.getInstance().getTime());
            timecard.setReason(this.reason.getValue());
            timecard.setCreateDate(Calendar.getInstance().getTime());
            timecard.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(timecard.getTimecardId().intValue(), 150, null);
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"timecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTTimecard timecard = TimecardUtils.getEipTTimecard(rundata, context);
            if (timecard == null) {
                return false;
            }
            timecard.setWorkDate(this.work_date.getValue());
            timecard.setReason(this.reason.getValue());
            timecard.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(timecard.getTimecardId().intValue(), 150, this.reason.getValue());
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"timecard", (Throwable)ex);
            return false;
        }
        return true;
    }

    public void setWorkFlag(String str) {
        this.work_flag.setValue(str);
    }

    public ALDateTimeField getWorkDate() {
        return this.work_date;
    }

    public ALStringField getReason() {
        return this.reason;
    }

    private int compareToDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date1Hour = cal1.get(10);
        int date1Minute = cal1.get(12);
        int date1Second = cal1.get(13);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        int date2Hour = cal2.get(10);
        int date2Minute = cal2.get(12);
        int date2Second = cal2.get(13);
        if (date1Year == date2Year && date1Month == date2Month && date1Day == date2Day && date1Hour == date2Hour && date1Minute == date2Minute && date1Second == date2Second) {
            return 0;
        }
        if (cal1.after(cal2)) {
            return 2;
        }
        return 1;
    }

    public String getAclPortletFeature() {
        return "timecard_timecard_self";
    }
}

