/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.system;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.account.EipMCompany;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.system.util.SystemUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SystemCompanyFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)SystemCompanyFormData.class.getName());
    private ALStringField company_name;
    private ALStringField zipcode1;
    private ALStringField zipcode2;
    private ALStringField address;
    private ALStringField telephone1;
    private ALStringField telephone2;
    private ALStringField telephone3;
    private ALStringField fax_number1;
    private ALStringField fax_number2;
    private ALStringField fax_number3;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
    }

    public void initField() {
        this.company_name = new ALStringField();
        this.company_name.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_COMPANY_NAME"));
        this.company_name.setTrim(true);
        this.zipcode1 = new ALStringField();
        this.zipcode1.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_ZIPCODE"));
        this.zipcode1.setTrim(true);
        this.zipcode2 = new ALStringField();
        this.zipcode2.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_ZIPCODE"));
        this.zipcode2.setTrim(true);
        this.address = new ALStringField();
        this.address.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_ADDRESS"));
        this.address.setTrim(true);
        this.telephone1 = new ALStringField();
        this.telephone1.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_TELEPHONE"));
        this.telephone1.setTrim(true);
        this.telephone2 = new ALStringField();
        this.telephone2.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_TELEPHONE"));
        this.telephone2.setTrim(true);
        this.telephone3 = new ALStringField();
        this.telephone3.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_TELEPHONE"));
        this.telephone3.setTrim(true);
        this.fax_number1 = new ALStringField();
        this.fax_number1.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_FAX_NUMBER"));
        this.fax_number1.setTrim(true);
        this.fax_number2 = new ALStringField();
        this.fax_number2.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_FAX_NUMBER"));
        this.fax_number2.setTrim(true);
        this.fax_number3 = new ALStringField();
        this.fax_number3.setFieldName(ALLocalizationUtils.getl10n((String)"SYSTEM_SETFIELDNAME_FAX_NUMBER"));
        this.fax_number3.setTrim(true);
    }

    protected void setValidator() {
        this.company_name.setNotNull(true);
        this.company_name.limitMaxLength(50);
        this.address.limitMaxLength(60);
        this.zipcode1.setCharacterType(2);
        this.zipcode1.limitLength(3, 3);
        this.zipcode2.setCharacterType(2);
        this.zipcode2.limitLength(4, 4);
        this.telephone1.setCharacterType(2);
        this.telephone1.limitMaxLength(5);
        this.telephone2.setCharacterType(2);
        this.telephone2.limitMaxLength(4);
        this.telephone3.setCharacterType(2);
        this.telephone3.limitMaxLength(4);
        this.fax_number1.setCharacterType(2);
        this.fax_number1.limitMaxLength(5);
        this.fax_number2.setCharacterType(2);
        this.fax_number2.limitMaxLength(4);
        this.fax_number3.setCharacterType(2);
        this.fax_number3.limitMaxLength(4);
    }

    protected boolean validate(List<String> msgList) {
        ArrayList dummy = new ArrayList();
        this.company_name.validate(msgList);
        this.address.validate(msgList);
        if (!(this.zipcode1.getValue().equals("") && this.zipcode2.getValue().equals("") || this.zipcode1.validate(dummy) && this.zipcode2.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SYSTEM_ALERT_SET_ZIPCODE"));
        }
        if (!(this.telephone1.getValue().equals("") && this.telephone2.getValue().equals("") && this.telephone3.getValue().equals("") || this.telephone1.validate(dummy) && this.telephone2.validate(dummy) && this.telephone3.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SYSTEM_ALERT_SET_TELEPHONE"));
        }
        if (!(this.fax_number1.getValue().equals("") && this.fax_number2.getValue().equals("") && this.fax_number3.getValue().equals("") || this.fax_number1.validate(dummy) && this.fax_number2.validate(dummy) && this.fax_number3.validate(dummy))) {
            msgList.add(ALLocalizationUtils.getl10n((String)"SYSTEM_ALERT_SET_FAX_NUMBER"));
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            StringTokenizer token;
            EipMCompany record = SystemUtils.getEipMCompany(rundata, context);
            if (record == null) {
                return false;
            }
            this.company_name.setValue(record.getCompanyName());
            if (record.getZipcode() != null && (token = new StringTokenizer(record.getZipcode(), "-")).countTokens() == 2) {
                this.zipcode1.setValue(token.nextToken());
                this.zipcode2.setValue(token.nextToken());
            }
            this.address.setValue(record.getAddress());
            if (record.getTelephone() != null && (token = new StringTokenizer(record.getTelephone(), "-")).countTokens() == 3) {
                this.telephone1.setValue(token.nextToken());
                this.telephone2.setValue(token.nextToken());
                this.telephone3.setValue(token.nextToken());
            }
            if (record.getFaxNumber() != null && (token = new StringTokenizer(record.getFaxNumber(), "-")).countTokens() == 3) {
                this.fax_number1.setValue(token.nextToken());
                this.fax_number2.setValue(token.nextToken());
                this.fax_number3.setValue(token.nextToken());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"system", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipMCompany record = SystemUtils.getEipMCompany(rundata, context);
            if (record == null) {
                return false;
            }
            record.setCompanyName(this.company_name.getValue());
            if (!this.zipcode1.getValue().equals("") && !this.zipcode2.getValue().equals("")) {
                record.setZipcode(new StringBuffer().append(this.zipcode1.getValue()).append("-").append(this.zipcode2.getValue()).toString());
            } else {
                record.setZipcode("");
            }
            record.setAddress(this.address.getValue());
            if (!(this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
                record.setTelephone(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            } else {
                record.setTelephone("");
            }
            if (!(this.fax_number1.getValue().equals("") || this.fax_number2.getValue().equals("") || this.fax_number3.getValue().equals(""))) {
                record.setFaxNumber(new StringBuffer().append(this.fax_number1.getValue()).append("-").append(this.fax_number2.getValue()).append("-").append(this.fax_number3.getValue()).toString());
            } else {
                record.setFaxNumber("");
            }
            record.setUpdateDate(new Date());
            Database.commit();
            ALEipManager.getInstance().reloadCompany();
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"system", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        return false;
    }

    public ALStringField getAddress() {
        return this.address;
    }

    public ALStringField getCompanyName() {
        return this.company_name;
    }

    public ALStringField getFaxNumber1() {
        return this.fax_number1;
    }

    public ALStringField getFaxNumber2() {
        return this.fax_number2;
    }

    public ALStringField getFaxNumber3() {
        return this.fax_number3;
    }

    public ALStringField getTelephone1() {
        return this.telephone1;
    }

    public ALStringField getTelephone2() {
        return this.telephone2;
    }

    public ALStringField getTelephone3() {
        return this.telephone3;
    }

    public ALStringField getZipcode1() {
        return this.zipcode1;
    }

    public ALStringField getZipcode2() {
        return this.zipcode2;
    }
}

