/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.cabinet;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cabinet.FolderInfo;
import com.aimluck.eip.cabinet.util.CabinetUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFile;
import com.aimluck.eip.cayenne.om.portlet.EipTCabinetFolder;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.timeline.util.TimelineUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.util.ALLocalizationUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CabinetFileFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CabinetFileFormData.class.getName());
    private ALNumberField folder_id;
    private ALStringField file_title;
    private ALStringField file_name;
    private ALNumberField file_size;
    private ALStringField note;
    private List<FolderInfo> folder_hierarchy_list;
    private FolderInfo selected_folderinfo = null;
    private String folderName = null;
    private String fileid = null;
    private String orgId = null;
    private List<FileuploadLiteBean> fileuploadList = null;
    private String[] fileids;
    private RunData rundata;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context) && rundata.getParameters().containsKey((Object)"folder_id")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"folder_id", (String)rundata.getParameters().getString("folder_id"));
        }
        this.orgId = Database.getDomainName();
        this.rundata = rundata;
        String tmpfid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"folder_id");
        int fid = 1;
        if (tmpfid != null && !"".equals(tmpfid)) {
            try {
                fid = Integer.parseInt(tmpfid);
            }
            catch (Exception e) {
                fid = 1;
            }
        }
        this.folder_hierarchy_list = CabinetUtils.getFolderList();
        CabinetUtils.setFolderVisibleForForm(this.folder_hierarchy_list, rundata);
        int size = this.folder_hierarchy_list.size();
        for (int i = 0; i < size; ++i) {
            FolderInfo info = this.folder_hierarchy_list.get(i);
            if (info.getFolderId() != fid) continue;
            this.selected_folderinfo = info;
        }
        this.folderName = rundata.getParameters().getString("folderName");
        this.fileids = rundata.getParameters().getStrings("attachments");
    }

    public void initField() {
        this.folder_id = new ALNumberField();
        this.folder_id.setFieldName(ALLocalizationUtils.getl10n((String)"MSGBOARD_ADD_TOPIC"));
        this.folder_id.setNotNull(true);
        this.folder_id.setValue(0L);
        this.file_title = new ALStringField();
        this.file_title.setFieldName(ALLocalizationUtils.getl10n((String)"CABINET_TITLE"));
        this.file_title.setTrim(true);
        this.file_name = new ALStringField();
        this.file_name.setFieldName(ALLocalizationUtils.getl10n((String)"CABINET_FILE"));
        this.file_name.setTrim(true);
        this.file_size = new ALNumberField();
        this.file_size.setFieldName(ALLocalizationUtils.getl10n((String)"CABINET_FILE_SIZE"));
        this.note = new ALStringField();
        this.note.setFieldName(ALLocalizationUtils.getl10n((String)"CABINET_MEMO"));
        this.note.setTrim(true);
        this.fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    protected boolean setFormData(RunData rundata, Context context, List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        if (res) {
            if (!rundata.getParameters().containsKey((Object)"folder_id")) {
                try {
                    this.folder_id.setValue((long)this.selected_folderinfo.getFolderId());
                }
                catch (Exception e) {
                    this.folder_id.setValue(1L);
                }
            }
            if ("update".equals(this.getMode())) {
                this.fileid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            }
        }
        try {
            this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
            FileuploadLiteBean filebean = null;
            if (this.fileuploadList != null && !this.fileuploadList.isEmpty()) {
                filebean = this.fileuploadList.get(0);
                this.file_name.setValue(filebean.getFileName());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
        }
        return res;
    }

    protected void setValidator() {
        this.file_title.setNotNull(true);
        this.file_title.limitMaxLength(128);
        this.file_name.setNotNull(true);
        this.file_name.limitMaxLength(128);
        this.note.limitMaxLength(1000);
    }

    protected boolean validate(List<String> msgList) {
        this.file_title.validate(msgList);
        if ("insert".equals(this.getMode())) {
            this.file_name.validate(msgList);
        } else if (this.fileuploadList != null && this.fileuploadList.size() > 0) {
            this.file_name.validate(msgList);
        }
        if (this.fileuploadList != null && this.fileids.length > 1) {
            msgList.add(ALLocalizationUtils.getl10n((String)"CABINET_DONOT_LAUNCH_MORE"));
        }
        if ("update".equals(this.getMode()) && this.fileids == null) {
            msgList.add(ALLocalizationUtils.getl10n((String)"CABINET_KAKKO") + " <span class='em'>" + ALLocalizationUtils.getl10n((String)"CABINET_FILE") + "</span> " + ALLocalizationUtils.getl10n((String)"CABINET_SELECT"));
        }
        this.note.validate(msgList);
        if (!CabinetUtils.isEditableFolder((int)this.folder_id.getValue(), this.rundata)) {
            msgList.add(ALLocalizationUtils.getl10n((String)"CABINET_DONOT_AUTHORITY"));
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTCabinetFile file = CabinetUtils.getEipTCabinetFile(rundata, context);
            if (file == null) {
                return false;
            }
            this.folder_id.setValue((long)file.getFolderId().intValue());
            this.file_title.setValue(file.getFileTitle());
            this.file_name.setValue(file.getFileName());
            this.file_size.setValue(file.getFileSize().longValue());
            this.note.setValue(file.getNote());
            this.folderName = Integer.toString(file.getFolderId());
        }
        catch (Exception ex) {
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            EipTCabinetFile file = CabinetUtils.getEipTCabinetFile(rundata, context);
            if (file == null) {
                return false;
            }
            String local_file_pass = file.getFilePath();
            int entityId = file.getFileId();
            String fileName = file.getFileTitle();
            Database.delete((Persistent)file);
            Database.commit();
            TimelineUtils.deleteTimelineActivity((RunData)rundata, (Context)context, (String)"Cabinet", (String)file.getFileId().toString());
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId, 220, fileName);
            if (local_file_pass != null && !"".equals(local_file_pass)) {
                ALStorageService.deleteFile((String)(CabinetUtils.getSaveDirPath(this.orgId) + local_file_pass));
            }
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, List<String> msgList) {
        boolean res = false;
        try {
            EipTCabinetFolder parentFolder;
            int uid = ALEipUtils.getUserId((RunData)rundata);
            FileuploadLiteBean filebean = this.fileuploadList.get(0);
            String filename = "0_" + String.valueOf(System.nanoTime());
            ALStorageService.copyTmpFile((int)uid, (String)this.folderName, (String)String.valueOf(filebean.getFileId()), (String)CabinetUtils.FOLDER_FILEDIR_CABINET, (String)CabinetUtils.CATEGORY_KEY, (String)filename);
            double fileSize = ALStorageService.getFileSize((String)CabinetUtils.FOLDER_FILEDIR_CABINET, (String)CabinetUtils.CATEGORY_KEY, (String)filename);
            EipTCabinetFolder folder = (EipTCabinetFolder)Database.get(EipTCabinetFolder.class, (Object)((int)this.folder_id.getValue()));
            EipTCabinetFile file = (EipTCabinetFile)Database.create(EipTCabinetFile.class);
            file.setEipTCabinetFolder(folder);
            file.setFileTitle(this.file_title.getValue());
            file.setFileName(this.file_name.getValue());
            file.setFileSize(Long.valueOf((long)fileSize));
            file.setCounter(Integer.valueOf(0));
            file.setFilePath(CabinetUtils.getRelativePath(filename));
            file.setNote(this.note.getValue());
            file.setCreateUserId(Integer.valueOf(uid));
            file.setUpdateUserId(Integer.valueOf(uid));
            file.setCreateDate(Calendar.getInstance().getTime());
            file.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(file.getFileId().intValue(), 220, this.file_title.getValue());
            if (Integer.valueOf(folder.getPublicFlag()) == 0) {
                Integer parentFolderId = CabinetUtils.getAccessControlFolderId(folder.getFolderId());
                parentFolder = (EipTCabinetFolder)Database.get(EipTCabinetFolder.class, (Object)parentFolderId);
            } else {
                parentFolder = folder;
            }
            List<Integer> userIds = CabinetUtils.getWhatsNewInsertList(rundata, parentFolder.getFolderId(), parentFolder.getPublicFlag());
            if (userIds != null) {
                ArrayList<String> recipients = new ArrayList<String>();
                int u_size = userIds.size();
                for (int i = 0; i < u_size; ++i) {
                    Integer _id = userIds.get(i);
                    ALEipUser user = ALEipUtils.getALEipUser((int)_id);
                    if (user == null) continue;
                    recipients.add(user.getName().getValue());
                }
                if (recipients.size() > 0) {
                    ALEipUser user = ALEipUtils.getALEipUser((int)uid);
                    CabinetUtils.createCabinetActivity(file, user.getName().getValue(), recipients, true);
                }
            }
            ALStorageService.deleteTmpFolder((int)uid, (String)this.folderName);
            res = true;
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return res;
    }

    protected boolean updateFormData(RunData rundata, Context context, List<String> msgList) {
        try {
            int uid = ALEipUtils.getUserId((RunData)rundata);
            EipTCabinetFile file = CabinetUtils.getEipTCabinetFile(rundata, context);
            if (file == null) {
                return false;
            }
            String local_file_pass = file.getFilePath();
            boolean is_upload = true;
            if (this.fileuploadList == null || this.fileuploadList.isEmpty()) {
                is_upload = false;
            }
            if (is_upload) {
                FileuploadLiteBean filebean = this.fileuploadList.get(0);
                String filename = "0_" + String.valueOf(System.nanoTime());
                ALStorageService.copyTmpFile((int)uid, (String)this.folderName, (String)String.valueOf(filebean.getFileId()), (String)CabinetUtils.FOLDER_FILEDIR_CABINET, (String)CabinetUtils.CATEGORY_KEY, (String)filename);
                if (local_file_pass != null && !"".equals(local_file_pass)) {
                    ALStorageService.deleteFile((String)(CabinetUtils.getSaveDirPath(this.orgId) + local_file_pass));
                }
                file.setFileName(this.file_name.getValue());
                double fileSize = ALStorageService.getFileSize((String)CabinetUtils.FOLDER_FILEDIR_CABINET, (String)CabinetUtils.CATEGORY_KEY, (String)filename);
                file.setFileSize(Long.valueOf((long)fileSize));
                file.setCounter(Integer.valueOf(0));
                file.setFilePath(CabinetUtils.getRelativePath(filename));
                file.setCreateUserId(Integer.valueOf(uid));
                file.setCreateDate(Calendar.getInstance().getTime());
            }
            EipTCabinetFolder folder = (EipTCabinetFolder)Database.get(EipTCabinetFolder.class, (Object)((int)this.folder_id.getValue()));
            file.setEipTCabinetFolder(folder);
            file.setFileTitle(this.file_title.getValue());
            file.setNote(this.note.getValue());
            file.setUpdateUserId(Integer.valueOf(uid));
            file.setUpdateDate(Calendar.getInstance().getTime());
            Database.commit();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(file.getFileId().intValue(), 220, this.file_title.getValue());
            List<Integer> userIds = CabinetUtils.getWhatsNewInsertList(rundata, folder.getFolderId(), folder.getPublicFlag());
            if (userIds != null) {
                ArrayList<String> recipients = new ArrayList<String>();
                int u_size = userIds.size();
                for (int i = 0; i < u_size; ++i) {
                    Integer _id = userIds.get(i);
                    ALEipUser user = ALEipUtils.getALEipUser((int)_id);
                    if (user == null) continue;
                    recipients.add(user.getName().getValue());
                }
                if (recipients.size() > 0) {
                    ALEipUser user = ALEipUtils.getALEipUser((int)uid);
                    CabinetUtils.createCabinetActivity(file, user.getName().getValue(), recipients, false);
                }
            }
        }
        catch (RuntimeException ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            Database.rollback();
            logger.error((Object)"cabinet", (Throwable)ex);
            return false;
        }
        return true;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public ALNumberField getFolderId() {
        return this.folder_id;
    }

    public ALStringField getFileTitle() {
        return this.file_title;
    }

    public ALStringField getFileName() {
        return this.file_name;
    }

    public String getFileNameHtml() {
        return ALCommonUtils.replaceToAutoCR((String)this.file_name.toString());
    }

    public ALNumberField getFileSize() {
        return this.file_size;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public List<FolderInfo> getFolderHierarchyList() {
        return this.folder_hierarchy_list;
    }

    public FolderInfo getSelectedFolderInfo() {
        return this.selected_folderinfo;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List<FileuploadLiteBean> getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getAclPortletFeature() {
        return "cabinet_file";
    }
}

