/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.text.html;

import com.sk_jp.text.AttributeMap;
import com.sk_jp.text.EntityRefEncoder;
import com.sk_jp.text.Translator;
import com.sk_jp.text.html.ATagProcessor;
import com.sk_jp.text.html.BRTagProcessor;
import com.sk_jp.text.html.HTMLHandler;
import com.sk_jp.text.html.HTMLLayoutTranslator;
import com.sk_jp.text.html.HTMLLex;
import com.sk_jp.text.html.TagProcessor;
import com.sk_jp.text.regex.RegexTranslator;
import com.sk_jp.text.regex.Substitute;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class TagReformatter
implements Translator {
    public static final int DEFAULT_TAG_ENABLED = 1;
    public static final int URI_TO_LINK = 2;
    public static final int HOLD_LAYOUT = 4;
    private RegexTranslator linkTranslator = new RegexTranslator();
    private final Map tagProcessors = new HashMap();
    private Translator commonTranslator = null;

    public TagReformatter() {
        this(7);
    }

    public TagReformatter(int n) {
        if ((n & 1) != 0) {
            this.addTagProcessor("a", new ATagProcessor());
            this.addTagProcessor("br", new BRTagProcessor());
        }
        if ((n & 4) != 0) {
            this.setCommonTranslator(new HTMLLayoutTranslator());
        } else {
            this.setCommonTranslator(new EntityRefEncoder());
        }
        if ((n & 2) != 0) {
            this.linkTranslator.addSubstitute("s/(&quot;|&gt;|&lt;)/ $1/g");
            this.linkTranslator.addSubstitute("s!((https?|ftp|gopher|telnet|whois|news|mailto):(//)?[-_.\\!~*'\\(\\);:@&=+$\\,%/?#A-Za-z0-9]+)!<A href=\"$1\" target=\"_blank\">$1</A>!g");
            this.linkTranslator.addSubstitute("s/ (&quot;|&gt;|&lt;)/$1/g");
        }
    }

    public final void addTagProcessor(String string, TagProcessor tagProcessor) {
        this.tagProcessors.put(string.toLowerCase(), tagProcessor);
    }

    public final void setCommonTranslator(Translator translator) {
        this.commonTranslator = translator;
    }

    public void addLinkSubstitute(String string) {
        this.linkTranslator.addSubstitute(string);
    }

    public void addLinkSubstitute(Substitute substitute) {
        this.linkTranslator.addSubstitute(substitute);
    }

    public String translate(String string) {
        if (string == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            this.translate(new StringReader(string), stringWriter);
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
        return stringWriter.toString();
    }

    public void translate(Reader reader, final Writer writer) throws IOException {
        try {
            new HTMLLex(new HTMLHandler(){
                private boolean inA = false;

                public void text(String string) {
                    try {
                        if (TagReformatter.this.commonTranslator != null) {
                            string = TagReformatter.this.commonTranslator.translate(string);
                        }
                        if (!this.inA) {
                            string = TagReformatter.this.linkTranslator.translate(string);
                        }
                        writer.write(string);
                    }
                    catch (IOException iOException) {
                        throw new WrappedException(iOException);
                    }
                }

                public boolean enter(String string, AttributeMap attributeMap) {
                    string = string.toLowerCase();
                    try {
                        TagProcessor tagProcessor = (TagProcessor)TagReformatter.this.tagProcessors.get(string);
                        if (tagProcessor == null) {
                            return false;
                        }
                        boolean bl = tagProcessor.enter(attributeMap, writer);
                        if ("a".equals(string) && bl) {
                            this.inA = true;
                        }
                        return bl;
                    }
                    catch (IOException iOException) {
                        throw new WrappedException(iOException);
                    }
                }

                public boolean leave(String string) {
                    string = string.toLowerCase();
                    try {
                        TagProcessor tagProcessor = (TagProcessor)TagReformatter.this.tagProcessors.get(string);
                        if (tagProcessor == null) {
                            return false;
                        }
                        boolean bl = tagProcessor.leave(writer);
                        if ("a".equals(string) && bl) {
                            this.inA = false;
                        }
                        return bl;
                    }
                    catch (IOException iOException) {
                        throw new WrappedException(iOException);
                    }
                }
            }).parse(reader);
        }
        catch (WrappedException wrappedException) {
            throw (IOException)wrappedException.getException();
        }
        writer.flush();
    }

    public static void main(String[] stringArray) throws Exception {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        new TagReformatter().translate(new InputStreamReader(System.in, "JISAutoDetect"), printWriter);
        printWriter.flush();
    }

    static class WrappedException
    extends RuntimeException {
        private Exception e;

        public WrappedException(Exception exception) {
            this.e = exception;
        }

        public Exception getException() {
            return this.e;
        }
    }
}

