/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.util.wrapper;

import com.sk_jp.util.wrapper.NamedArray;
import com.sk_jp.util.wrapper.NamedDate;
import com.sk_jp.util.wrapper.NamedEnum;
import com.sk_jp.util.wrapper.NamedNumber;
import com.sk_jp.util.wrapper.NamedNumberRange;
import com.sk_jp.util.wrapper.NamedObject;
import com.sk_jp.util.wrapper.NamedObjectVisitor;
import com.sk_jp.util.wrapper.NamedString;
import java.util.HashMap;
import java.util.Map;

public class DefaultNamedObject
implements NamedObject {
    private String name_;
    private Object value_;
    private final Map attrs_ = new HashMap();

    public static NamedObject create(String string) {
        NamedObject namedObject;
        if ("String".equals(string)) {
            namedObject = new NamedString();
        } else if ("Array".equals(string)) {
            namedObject = new NamedArray();
        } else if ("Number".equals(string)) {
            namedObject = new NamedNumber();
        } else if ("Enum".equals(string)) {
            namedObject = new NamedEnum();
        } else if ("Date".equals(string)) {
            namedObject = new NamedDate();
        } else if ("NumberRange".equals(string)) {
            namedObject = new NamedNumberRange();
        } else {
            try {
                namedObject = (NamedObject)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                namedObject = new DefaultNamedObject("Unknown");
            }
        }
        return namedObject;
    }

    public DefaultNamedObject(String string) {
        this(null, string, null);
    }

    public DefaultNamedObject(String string, String string2) {
        this(string, string2, null);
    }

    public DefaultNamedObject(String string, String string2, Object object) {
        this.setName(string);
        this.setAttribute("type", string2);
        this.setValue(object);
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String string) {
        this.name_ = string;
        this.setAttribute("name", this.name_);
    }

    public void setAttribute(Object object, Object object2) {
        this.attrs_.put(object, object2);
    }

    public Object getAttribute(String string) {
        return this.attrs_.get(string);
    }

    public void removeAttribute(String string) {
        this.attrs_.remove(string);
    }

    public Map getAttributes() {
        return this.attrs_;
    }

    public Object getValue() {
        return this.value_;
    }

    public void setValue(Object object) {
        this.value_ = object;
    }

    public Object accept(NamedObjectVisitor namedObjectVisitor, Object object) {
        return namedObjectVisitor.visitObject(this, object);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

