/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.xml;

import com.sk_jp.io.CorrectOutputStreamWriter;
import com.sk_jp.xml.DOMUtility;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMPrint {
    public static String getString(Node node) {
        if (node == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter(2048);
        DOMPrint.printNodes(new PrintWriter(stringWriter), node, false, false, "utf-8", 0);
        return stringWriter.toString();
    }

    public static String getStringSubordinate(Node node) {
        if (node == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter(2048);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            DOMPrint.printNodes(printWriter, nodeList.item(i), false, false, null, 0);
        }
        return stringWriter.toString();
    }

    public static String getHTMLString(Node node) {
        if (node == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter(2048);
        DOMPrint.printHTMLNodes(new PrintWriter(stringWriter), node);
        return stringWriter.toString();
    }

    public static void write(Document document, String string, String string2) throws IOException {
        PrintWriter printWriter = new PrintWriter(new CorrectOutputStreamWriter((OutputStream)new FileOutputStream(string), string2));
        DOMPrint.print(printWriter, document, string2, 0);
        printWriter.close();
    }

    public static void print(PrintWriter printWriter, Node node, String string) {
        DOMPrint.printNodes(printWriter, node, false, false, string, 0);
    }

    public static void print(PrintWriter printWriter, Node node, String string, int n) {
        DOMPrint.printNodes(printWriter, node, false, false, string, n);
    }

    public static void print(PrintWriter printWriter, Node node, boolean bl, String string, int n) {
        DOMPrint.printNodes(printWriter, node, bl, false, string, n);
    }

    public static void printHTML(PrintWriter printWriter, Node node) {
        if (node.getNodeType() == 9) {
            // empty if block
        }
        DOMPrint.printNodes(printWriter, node, false, true, "utf8", 1);
    }

    public static void printNodes(PrintWriter printWriter, Node node, boolean bl, String string) {
        DOMPrint.printNodes(printWriter, node, bl, false, string, 0);
    }

    public static void printHTMLNodes(PrintWriter printWriter, Node node) {
        DOMPrint.printNodes(printWriter, node, false, true, "utf8", 0);
    }

    public static void printNodes(PrintWriter printWriter, Node node, boolean bl, boolean bl2, String string, int n) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                printWriter.print("<?xml version=\"1.0");
                if (string != null) {
                    printWriter.print("\" encoding=\"");
                    printWriter.print(string);
                }
                printWriter.println("\"?>");
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    DOMPrint.printNodes(printWriter, nodeList.item(i), bl, bl2, string, n);
                }
                break;
            }
            case 10: {
                break;
            }
            case 1: {
                int n2;
                for (int i = 1; i < n; ++i) {
                    printWriter.print("  ");
                }
                printWriter.print('<');
                printWriter.print(node.getNodeName());
                Attr[] attrArray = DOMPrint.sortAttributes(node.getAttributes());
                for (n2 = 0; n2 < attrArray.length; ++n2) {
                    Attr attr = attrArray[n2];
                    printWriter.print(' ');
                    printWriter.print(attr.getNodeName());
                    printWriter.print("=\"");
                    printWriter.print(DOMUtility.normalize(attr.getNodeValue(), bl));
                    printWriter.print('\"');
                }
                if (!node.hasChildNodes()) {
                    if (bl2) {
                        if (n == 0) {
                            printWriter.print('>');
                            break;
                        }
                        printWriter.println('>');
                        break;
                    }
                    if (n == 0) {
                        printWriter.print(" />");
                        break;
                    }
                    printWriter.println(" />");
                    break;
                }
                if (n == 0) {
                    printWriter.print('>');
                } else {
                    printWriter.println('>');
                }
                NodeList nodeList = node.getChildNodes();
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    DOMPrint.printNodes(printWriter, nodeList.item(n2), bl, bl2, string, n > 0 ? n + 1 : 0);
                }
                for (n2 = 1; n2 < n; ++n2) {
                    printWriter.print("  ");
                }
                printWriter.print("</");
                printWriter.print(node.getNodeName());
                if (n == 0) {
                    printWriter.print('>');
                    break;
                }
                printWriter.println('>');
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string2 = node.getNodeValue();
                if (string2 != null && string2.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string2);
                }
                printWriter.println("?>");
                printWriter.println(string2);
                break;
            }
            case 5: {
                if (bl) {
                    NodeList nodeList = node.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        DOMPrint.printNodes(printWriter, nodeList.item(i), bl, bl2, string, n > 0 ? n + 1 : 0);
                    }
                    break;
                }
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 3: {
                printWriter.print(DOMUtility.normalize(node.getNodeValue(), bl));
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                if (n == 0) {
                    printWriter.print("-->");
                    break;
                }
                printWriter.println("-->");
                break;
            }
            default: {
                printWriter.println("Other_NODE:" + node.getNodeName() + ":" + node.getNodeValue() + ":type=" + node.getNodeType());
            }
        }
        printWriter.flush();
    }

    private static Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n];
        for (int i = 0; i < n; ++i) {
            attrArray[i] = (Attr)namedNodeMap.item(i);
        }
        for (int i = 0; i < n - 1; ++i) {
            String string = attrArray[i].getNodeName();
            int n2 = i;
            for (int j = i + 1; j < n; ++j) {
                String string2 = attrArray[j].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n2 = j;
            }
            if (n2 == i) continue;
            Attr attr = attrArray[i];
            attrArray[i] = attrArray[n2];
            attrArray[n2] = attr;
        }
        return attrArray;
    }

    private DOMPrint() {
    }
}

