/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.daemon.impl;

import java.io.IOException;
import org.apache.jetspeed.cache.disk.DiskCacheUtils;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonConfig;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.urlmanager.URLFetcher;
import org.apache.jetspeed.services.urlmanager.URLManager;

public class BadURLManagerDaemon
implements Daemon {
    private int status = 1;
    private int result = 0;
    private DaemonConfig config = null;
    private DaemonEntry entry = null;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BadURLManagerDaemon.class.getName());

    public void run() {
        logger.info("Checking for valid URLs within the URLManager");
        this.setResult(3);
        for (String url : URLManager.list()) {
            if (URLManager.isOK(url)) continue;
            try {
                URLManager.unregister(url);
                logger.info("Removing " + url + " from BadURL list");
                this.save();
                URLFetcher.refresh(url);
            }
            catch (Throwable t) {
                logger.error("Invalid URL?", t);
                if (DiskCacheUtils.isCached(url)) {
                    try {
                        JetspeedDiskCache.getInstance().remove(url);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                logger.info("Failed to load: " + url + " from BadURL list");
            }
        }
        this.setResult(1);
    }

    public void init(DaemonConfig config, DaemonEntry entry) {
        this.config = config;
        this.entry = entry;
    }

    public DaemonConfig getDaemonConfig() {
        return this.config;
    }

    public DaemonEntry getDaemonEntry() {
        return this.entry;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getMessage() {
        return null;
    }

    public void save() {
    }

    public void restore() {
    }
}

