/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.daemon.impl;

import org.apache.jetspeed.cache.disk.DiskCacheEntry;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.daemon.Daemon;
import org.apache.jetspeed.daemon.DaemonConfig;
import org.apache.jetspeed.daemon.DaemonEntry;
import org.apache.jetspeed.daemon.impl.util.diskcachedaemon.URLRefresher;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.threadpool.ThreadPool;
import org.apache.turbine.util.RunData;

public class DiskCacheDaemon
implements Daemon {
    private int status = 1;
    private int result = 0;
    private DaemonConfig config = null;
    private DaemonEntry entry = null;
    private RunData rundata = null;
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(DiskCacheDaemon.class.getName());

    public void run() {
        logger.info("parsing out document store");
        this.setResult(3);
        DiskCacheEntry[] urls = JetspeedDiskCache.getInstance().getEntries();
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i].getSourceURL();
            if (urls[i].isLocal()) continue;
            ThreadPool.process(new URLRefresher(url));
        }
        this.setResult(1);
    }

    public void init(DaemonConfig config, DaemonEntry entry) {
        this.config = config;
        this.entry = entry;
    }

    public DaemonConfig getDaemonConfig() {
        return this.config;
    }

    public DaemonEntry getDaemonEntry() {
        return this.entry;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getMessage() {
        return null;
    }
}

