/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions;

import javax.servlet.http.Cookie;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.util.RunData;

public class JLogoutUser
extends ActionEvent {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JLogoutUser.class.getName());

    public void doPerform(RunData data) throws Exception {
        logger.info("Entering action JLogoutUser");
        if (JetspeedResources.getBoolean("automatic.logon.enable", false)) {
            Cookie userName = new Cookie("username", "");
            Cookie loginCookie = new Cookie("logincookie", "");
            String comment = JetspeedResources.getString("automatic.logon.cookie.comment", "");
            String domain = JetspeedResources.getString("automatic.logon.cookie.domain");
            String path = JetspeedResources.getString("automatic.logon.cookie.path", "/");
            if (domain == null) {
                String server = data.getServerName();
                domain = "." + server;
            }
            userName.setMaxAge(0);
            userName.setComment(comment);
            userName.setDomain(domain);
            userName.setPath(path);
            loginCookie.setMaxAge(0);
            loginCookie.setComment(comment);
            loginCookie.setDomain(domain);
            loginCookie.setPath(path);
            data.getResponse().addCookie(userName);
            data.getResponse().addCookie(loginCookie);
            if (data.getRequest().getCookies() != null) {
                data.getCookies().remove("logincookie");
                data.getCookies().remove("username");
            }
        }
        if (JetspeedResources.getBoolean("automatic.logout.save", false)) {
            JetspeedSecurity.saveUser((JetspeedUser)data.getUserFromSession());
        }
        JetspeedSecurity.logout();
        data.setMessage(JetspeedResources.getString("logout.message"));
        JetspeedLink jsLink = null;
        data.setScreen(JetspeedResources.getString("screen.homepage"));
        try {
            jsLink = JetspeedLinkFactory.getInstance(data);
        }
        catch (Exception e) {
            logger.error("Error getting jsLink", e);
        }
        data.setRedirectURI(jsLink.getHomePage().toString());
        JetspeedLinkFactory.putInstance(jsLink);
        jsLink = null;
    }
}

