/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.modules.actions.portlets.RegistryUpdateAction;
import org.apache.jetspeed.modules.actions.portlets.security.SecurityConstants;
import org.apache.jetspeed.om.registry.SecurityAccess;
import org.apache.jetspeed.om.registry.base.BaseSecurityAccess;
import org.apache.jetspeed.om.registry.base.BaseSecurityAllow;
import org.apache.jetspeed.om.registry.base.BaseSecurityAllowOwner;
import org.apache.jetspeed.om.registry.base.BaseSecurityEntry;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class SecurityUpdateAction
extends RegistryUpdateAction {
    private static final String SECURITY_UPDATE_PANE = "security-form";
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(SecurityUpdateAction.class.getName());

    public SecurityUpdateAction() {
        this.registryEntryName = "security_name";
        this.registry = Registry.SECURITY;
        this.pane = SECURITY_UPDATE_PANE;
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        int id;
        String mode = rundata.getParameters().getString("mode");
        context.put("mode", (Object)mode);
        String msgid = rundata.getParameters().getString("msgid");
        if (msgid != null && (id = Integer.parseInt(msgid)) < SecurityConstants.MESSAGES.length) {
            context.put("msg", (Object)SecurityConstants.MESSAGES[id]);
        }
        if (mode != null && (mode.equals("delete") || mode.equals("update"))) {
            String securityName = rundata.getParameters().getString("security_name");
            BaseSecurityEntry securityEntry = (BaseSecurityEntry)Registry.getEntry(Registry.SECURITY, securityName);
            String subMode = rundata.getParameters().getString("subMode");
            if (subMode != null) {
                context.put("subMode", (Object)subMode);
                int accessIndex = rundata.getParameters().getInt("access_index", -1);
                if (accessIndex != -1) {
                    context.put("accessIndex", (Object)new Integer(accessIndex));
                    BaseSecurityAccess securityAccess = (BaseSecurityAccess)securityEntry.getAccesses().get(--accessIndex);
                    context.put("securityAccess", (Object)securityAccess);
                }
            }
            Iterator permissionIter = JetspeedSecurity.getPermissions();
            Iterator userIter = JetspeedSecurity.getUsers();
            Iterator roleIter = JetspeedSecurity.getRoles();
            Iterator groupIter = JetspeedSecurity.getGroups();
            context.put("permissions", (Object)this.iteratorToCollection(permissionIter));
            context.put("users", (Object)this.iteratorToCollection(userIter));
            context.put("roles", (Object)this.iteratorToCollection(roleIter));
            context.put("groups", (Object)this.iteratorToCollection(groupIter));
            context.put("entry", (Object)securityEntry);
        }
        if (mode != null && mode.equals("insert")) {
            Iterator permissionIter = JetspeedSecurity.getPermissions();
            context.put("permissions", (Object)permissionIter);
        }
    }

    public void doAddaccess(RunData rundata, Context context) throws Exception {
        try {
            String securityName = rundata.getParameters().getString("security_name");
            BaseSecurityEntry securityEntry = (BaseSecurityEntry)Registry.getEntry(Registry.SECURITY, securityName);
            if (securityEntry != null) {
                String action = rundata.getParameters().getString("access_action");
                if (action != null && action.length() > 0) {
                    BaseSecurityAccess securityAccess = new BaseSecurityAccess();
                    securityAccess.setAction(action);
                    this.addAllow(rundata, securityAccess);
                    Vector accesses = securityEntry.getAccesses();
                    accesses.add(securityAccess);
                    securityEntry.setAccesses(accesses);
                    Registry.addEntry(Registry.SECURITY, securityEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error("Failed to find registry entry while trying to add accesses");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doUpdateaccess(RunData rundata, Context context) throws Exception {
        try {
            String securityName = rundata.getParameters().getString("security_name");
            BaseSecurityEntry securityEntry = (BaseSecurityEntry)Registry.getEntry(Registry.SECURITY, securityName);
            if (securityEntry != null) {
                int accessIndex = rundata.getParameters().getInt("access_index", -1);
                String action = rundata.getParameters().getString("access_action");
                if (--accessIndex >= 0 && accessIndex < securityEntry.getAccesses().size()) {
                    BaseSecurityAccess securityAccess = (BaseSecurityAccess)securityEntry.getAccesses().get(accessIndex);
                    securityAccess.setAction(action);
                    Registry.addEntry(Registry.SECURITY, securityEntry);
                    this.clearUserData(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error("Failed to find registry entry while trying to update accesses");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doRemoveaccess(RunData rundata, Context context) throws Exception {
        try {
            String securityName = rundata.getParameters().getString("security_name");
            BaseSecurityEntry securityEntry = (BaseSecurityEntry)Registry.getEntry(Registry.SECURITY, securityName);
            if (securityEntry != null) {
                int[] accessIndexes = rundata.getParameters().getInts("access_index");
                if (accessIndexes != null && accessIndexes.length > 0) {
                    ArrayList deleteList = new ArrayList();
                    for (int i = 0; i < accessIndexes.length; ++i) {
                        int accessIndex = accessIndexes[i];
                        if (--accessIndex >= 0 && accessIndex < securityEntry.getAccesses().size()) {
                            deleteList.add(securityEntry.getAccesses().get(accessIndex));
                            continue;
                        }
                        logger.error("Access Index: " + i + " is out of range");
                    }
                    Vector accesses = securityEntry.getAccesses();
                    for (SecurityAccess sa : deleteList) {
                        accesses.remove(sa);
                    }
                    securityEntry.setAccesses(accesses);
                    Registry.addEntry(Registry.SECURITY, securityEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error("Failed to find registry entry while trying to remove accesses");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 1);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doAddallow(RunData rundata, Context context) throws Exception {
        try {
            String securityName = rundata.getParameters().getString("security_name");
            BaseSecurityEntry securityEntry = (BaseSecurityEntry)Registry.getEntry(Registry.SECURITY, securityName);
            if (securityEntry != null) {
                int accessIndex = rundata.getParameters().getInt("access_index", -1);
                if (--accessIndex >= 0 && accessIndex < securityEntry.getAccesses().size()) {
                    BaseSecurityAccess securityAccess = (BaseSecurityAccess)securityEntry.getAccesses().get(accessIndex);
                    this.addAllow(rundata, securityAccess);
                    Registry.addEntry(Registry.SECURITY, securityEntry);
                    this.clearUserData(rundata);
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error("Failed to find registry entry while trying to add allow");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 0);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    public void doRemoveallow(RunData rundata, Context context) throws Exception {
        try {
            String securityName = rundata.getParameters().getString("security_name");
            BaseSecurityEntry securityEntry = (BaseSecurityEntry)Registry.getEntry(Registry.SECURITY, securityName);
            if (securityEntry != null) {
                int accessIndex = rundata.getParameters().getInt("access_index", -1);
                if (--accessIndex >= 0 && accessIndex < securityEntry.getAccesses().size()) {
                    BaseSecurityAccess securityAccess = (BaseSecurityAccess)securityEntry.getAccesses().get(accessIndex);
                    String allowType = rundata.getParameters().getString("allow_type", "allows");
                    int[] allowIndexes = rundata.getParameters().getInts("allow_index");
                    if (allowIndexes != null && allowIndexes.length > 0) {
                        for (int i = 0; i < allowIndexes.length; ++i) {
                            int allowIndex = allowIndexes[i];
                            if (--allowIndex >= 0) {
                                if (allowType.equals("owner")) {
                                    securityAccess.getOwnerAllows().remove(allowIndex);
                                } else {
                                    securityAccess.getAllows().remove(allowIndex);
                                }
                                Registry.addEntry(Registry.SECURITY, securityEntry);
                                this.clearUserData(rundata);
                                continue;
                            }
                            logger.error("Allow Index: " + allowIndex + " is out of range.");
                        }
                    } else {
                        DynamicURI duri = this.redirect(rundata, "update", 5);
                        rundata.setRedirectURI(duri.toString());
                        this.resetForm(rundata);
                    }
                } else {
                    DynamicURI duri = this.redirect(rundata, "update", 5);
                    rundata.setRedirectURI(duri.toString());
                    this.resetForm(rundata);
                }
            } else {
                DynamicURI duri = this.redirect(rundata, "update", 2);
                rundata.setRedirectURI(duri.toString());
                this.resetForm(rundata);
                logger.error("Failed to find registry entry while trying to remove allow");
            }
        }
        catch (Exception e) {
            DynamicURI duri = this.redirect(rundata, "update", 1);
            rundata.setRedirectURI(duri.toString());
            this.resetForm(rundata);
            logger.error("Exception", e);
        }
    }

    private void addAllow(RunData rundata, BaseSecurityAccess securityAccess) {
        String allowType = rundata.getParameters().getString("allow_type");
        String allowValue = rundata.getParameters().getString("allow_value");
        String allowValue2 = rundata.getParameters().getString("allow_value2");
        BaseSecurityAllow allow = null;
        if (allowType.equals("user")) {
            allow = new BaseSecurityAllow();
            allow.setUser(allowValue);
            securityAccess.getAllows().add(allow);
        } else if (allowType.equals("role")) {
            allow = new BaseSecurityAllow();
            allow.setRole(allowValue);
            securityAccess.getAllows().add(allow);
        } else if (allowType.equals("group")) {
            allow = new BaseSecurityAllow();
            allow.setGroup(allowValue);
            securityAccess.getAllows().add(allow);
        } else if (allowType.equals("groupRole")) {
            allow = new BaseSecurityAllow();
            allow.setGroup(allowValue);
            allow.setRole(allowValue2);
            securityAccess.getAllows().add(allow);
        } else if (allowType.equals("owner")) {
            allow = new BaseSecurityAllowOwner();
            allow.setOwner(true);
            securityAccess.getOwnerAllows().add(allow);
        }
    }

    protected void clearUserData(RunData rundata) {
        block2: {
            try {
                super.clearUserData(rundata);
                rundata.getUser().removeTemp("security_name");
                rundata.getUser().removeTemp("allow_type");
                rundata.getUser().removeTemp("allow_value");
                rundata.getUser().removeTemp("access_index");
                rundata.getUser().removeTemp("access_action");
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("SecurityUpdateAction: Failed to clear user data");
            }
        }
    }

    protected void resetForm(RunData rundata) {
        String securityName = rundata.getParameters().getString("security_name");
        String allowType = rundata.getParameters().getString("allow_type");
        String allowValue = rundata.getParameters().getString("allow_value");
        String accessIndex = rundata.getParameters().getString("access_index");
        String accessAction = rundata.getParameters().getString("access_action");
        rundata.getUser().setTemp("security_name", (Object)securityName);
        rundata.getUser().setTemp("allow_type", (Object)allowType);
        rundata.getUser().setTemp("allow_value", (Object)allowValue);
        rundata.getUser().setTemp("access_index", (Object)accessIndex);
        rundata.getUser().setTemp("access_action", (Object)accessAction);
    }
}

