/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.actions.portlets;

import java.util.StringTokenizer;
import org.apache.jetspeed.modules.actions.portlets.VelocityPortletAction;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.util.PortletConfigState;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class WeatherAction
extends VelocityPortletAction {
    public static final String WEATHER_CITY_INFO = "weather_city_info";
    public static final String WEATHER_STATE = "weather_state";
    public static final String WEATHER_CITY = "weather_city";
    public static final String WEATHER_STATION = "weather_station";
    public static final String WEATHER_STYLE = "weather_style";

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        this.buildNormalContext(portlet, context, rundata);
    }

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) {
        String cityInfo = PortletConfigState.getParameter(portlet, rundata, WEATHER_CITY_INFO, null);
        String city = portlet.getPortletConfig().getInitParameter(WEATHER_CITY);
        String state = portlet.getPortletConfig().getInitParameter(WEATHER_STATE);
        String station = portlet.getPortletConfig().getInitParameter(WEATHER_STATION);
        cityInfo = this.getCityInfo(city, state, station);
        context.put(WEATHER_CITY_INFO, (Object)cityInfo);
        String style = PortletConfigState.getParameter(portlet, rundata, WEATHER_STYLE, "infobox");
        context.put(WEATHER_STYLE, (Object)style);
    }

    private String getUSInfo(String city, String state) {
        if ((city = city.trim().toLowerCase() + " ").indexOf(" ") > 0) {
            String newCity = "";
            StringTokenizer st = new StringTokenizer(city, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                newCity = newCity + token.substring(0, 1).toUpperCase() + token.substring(1) + "_";
            }
            city = newCity.substring(0, newCity.length() - 1);
        }
        state = state.toUpperCase();
        return "US/" + state + "/" + city;
    }

    private String getCityInfo(String city, String state, String station) {
        String cityInfo = null;
        if (city != null && state != null && !city.equals("") && !state.equals("")) {
            cityInfo = this.getUSInfo(city, state);
        } else if (station != null && !station.equals("")) {
            cityInfo = "global/stations/" + station;
        }
        return cityInfo;
    }

    public void doCancel(RunData data, Context context) {
        VelocityPortlet portlet = (VelocityPortlet)context.get("portlet");
        this.buildNormalContext(portlet, context, data);
    }
}

