/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.modules.layouts;

import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.Layout;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.jsp.TurbineJspService;
import org.apache.turbine.util.RunData;

public class JetspeedJspLayout
extends Layout {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(JetspeedJspLayout.class.getName());

    public void doBuild(RunData data) throws Exception {
        String screenPath = null;
        TurbineJspService jsp = (TurbineJspService)TurbineServices.getInstance().getService("JspService");
        data.getResponse().setContentType(data.getContentType());
        if (logger.isInfoEnabled()) {
            logger.info("JetspeedJspLayout: set response content type to " + data.getContentType());
        }
        data.declareDirectResponse();
        String path = TemplateLocator.locateScreenTemplate(data, data.getScreenTemplate());
        if (path != null) {
            screenPath = jsp.getRelativeTemplateName("/screens" + path);
        }
        data.getRequest().setAttribute("screenJsp", screenPath);
        if (logger.isInfoEnabled()) {
            logger.info("JetspeedJspLayout: set 'screenJSP' to: " + screenPath);
        }
        String templateName = data.getLayoutTemplate();
        if (logger.isInfoEnabled()) {
            logger.info("JetspeedJspLayout: forward request to: /layouts" + templateName);
        }
        jsp.handleRequest(data, "/layouts" + templateName, false);
    }
}

