/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.jetspeed.om.registry.InvalidEntryException;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.base.BaseRegistryEntry;
import org.apache.jetspeed.om.registry.base.LocalRegistry;

public class BaseRegistry
implements LocalRegistry {
    protected static final boolean DEBUG = false;
    protected Map entries = new TreeMap();

    public int getEntryCount() {
        return this.entries.size();
    }

    public RegistryEntry getEntry(String name) throws InvalidEntryException {
        RegistryEntry entry = null;
        if (name != null) {
            entry = (RegistryEntry)this.entries.get(name);
        }
        if (entry == null) {
            throw new InvalidEntryException("The specified entry does not exist within the Registry " + name);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(RegistryEntry entry) throws InvalidEntryException {
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            if (!this.hasEntry(entry.getName())) {
                throw new InvalidEntryException("The specified entry does not exist within the Registry " + entry.getName());
            }
            this.entries.put(entry.getName(), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(RegistryEntry entry) throws InvalidEntryException {
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            if (this.hasEntry(entry.getName())) {
                throw new InvalidEntryException("The entry specified already exists within the Registry");
            }
            this.entries.put(entry.getName(), entry);
        }
    }

    public boolean hasEntry(String name) {
        return this.entries.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String name) {
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            this.entries.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RegistryEntry entry) {
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            this.entries.remove(entry.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getEntries() {
        Vector v = null;
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            v = new Vector(this.entries.values());
        }
        return v.elements();
    }

    public Iterator listEntryNames() {
        return this.entries.keySet().iterator();
    }

    public RegistryEntry[] toArray() {
        Enumeration enu = this.getEntries();
        Vector v = new Vector();
        while (enu.hasMoreElements()) {
            v.addElement(enu.nextElement());
        }
        Object[] entries = new RegistryEntry[v.size()];
        v.copyInto(entries);
        return entries;
    }

    public RegistryEntry createEntry() {
        return new BaseRegistryEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalEntry(RegistryEntry entry) throws InvalidEntryException {
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            if (!this.hasEntry(entry.getName())) {
                throw new InvalidEntryException("The specified entry does not exist within the Registry " + entry.getName());
            }
            this.entries.put(entry.getName(), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalEntry(RegistryEntry entry) throws InvalidEntryException {
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            if (this.hasEntry(entry.getName())) {
                throw new InvalidEntryException("The entry specified already exists within the Registry");
            }
            this.entries.put(entry.getName(), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEntry(String name) {
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            this.entries.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalEntry(RegistryEntry entry) {
        BaseRegistry baseRegistry = this;
        synchronized (baseRegistry) {
            this.entries.remove(entry.getName());
        }
    }
}

