/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.om.registry.base;

import org.apache.jetspeed.om.registry.InvalidEntryException;
import org.apache.jetspeed.om.registry.RegistryEntry;
import org.apache.jetspeed.om.registry.RegistryException;
import org.apache.jetspeed.om.registry.base.BaseRegistry;
import org.apache.jetspeed.om.registry.base.BaseSkinEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

public class BaseSkinRegistry
extends BaseRegistry {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(BaseSkinRegistry.class.getName());

    public void setEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.SKIN, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void addEntry(RegistryEntry entry) throws InvalidEntryException {
        try {
            Registry.addEntry(Registry.SKIN, entry);
        }
        catch (RegistryException e) {
            logger.error("Exception", e);
        }
    }

    public void removeEntry(String name) {
        Registry.removeEntry(Registry.SKIN, name);
    }

    public void removeEntry(RegistryEntry entry) {
        if (entry != null) {
            Registry.removeEntry(Registry.SKIN, entry.getName());
        }
    }

    public RegistryEntry createEntry() {
        return new BaseSkinEntry();
    }
}

