/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portal.controls;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.StringElement;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.om.registry.PortletControlEntry;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.portal.PortletControlConfig;
import org.apache.jetspeed.portal.PortletController;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.portal.PortletState;
import org.apache.jetspeed.portal.portlets.AbstractPortlet;
import org.apache.jetspeed.portal.security.portlets.PortletWrapper;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.MimeType;
import org.apache.turbine.util.RunData;

public abstract class AbstractPortletControl
extends AbstractPortlet
implements PortletControl {
    public static final String COLOR = "#CCCCCC";
    public static final String BACKGROUND_COLOR = "#FFFFFF";
    public static final String TITLE_COLOR = "#DDDDDD";
    public static final String WIDTH = "100%";
    private Portlet portlet = null;
    private PortletControlConfig conf = null;

    public PortletControlConfig getConfig() {
        return this.conf;
    }

    public void setConfig(PortletControlConfig conf) {
        this.conf = conf;
    }

    public void setPortlet(Portlet portlet) {
        this.portlet = portlet;
    }

    public Portlet getPortlet() {
        return this.portlet;
    }

    public void init(Portlet portlet) {
        this.setPortlet(portlet);
    }

    public String getColor() {
        return this.getPortlet().getPortletConfig().getPortletSkin().getTextColor();
    }

    public void setColor(String color) {
        this.getPortlet().getPortletConfig().getPortletSkin().setTextColor(color);
    }

    public String getBackgroundColor() {
        return this.getPortlet().getPortletConfig().getPortletSkin().getBackgroundColor();
    }

    public void setBackgroundColor(String backgroundColor) {
        this.getPortlet().getPortletConfig().getPortletSkin().setBackgroundColor(backgroundColor);
    }

    public String getTitleColor() {
        return this.getPortlet().getPortletConfig().getPortletSkin().getTitleBackgroundColor();
    }

    public void setTitleColor(String titleColor) {
        this.getPortlet().getPortletConfig().getPortletSkin().setTitleBackgroundColor(titleColor);
    }

    public String getWidth() {
        return this.getPortlet().getPortletConfig().getSkin("width", WIDTH);
    }

    public void setWidth(int width) {
        this.getPortlet().getPortletConfig().setSkin("width", String.valueOf(width));
    }

    public void setWidth(String width) {
        this.getPortlet().getPortletConfig().setSkin("width", width);
    }

    public PortletConfig getPortletConfig() {
        if (this.getPortlet() == null) {
            return null;
        }
        return this.getPortlet().getPortletConfig();
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        if (this.getPortlet() == null) {
            return;
        }
        this.getPortlet().setPortletConfig(portletConfig);
    }

    public String getName() {
        if (this.getPortlet() == null) {
            return null;
        }
        return this.getPortlet().getName();
    }

    public void setName(String name) {
        if (this.getPortlet() != null) {
            this.getPortlet().setName(name);
        }
    }

    public String getTitle() {
        if (this.getPortlet() == null) {
            return null;
        }
        return this.getPortlet().getTitle();
    }

    public void setTitle(String title) {
        if (this.getPortlet() != null) {
            this.getPortlet().setTitle(title);
        }
    }

    public String getDescription() {
        if (this.getPortlet() == null) {
            return null;
        }
        return this.getPortlet().getDescription();
    }

    public void setDescription(String description) {
        if (this.getPortlet() != null) {
            this.getPortlet().setDescription(description);
        }
    }

    public void init() throws PortletException {
        if (this.getPortlet() != null) {
            this.getPortlet().init();
        }
    }

    public ConcreteElement getContent(RunData rundata) {
        PortletWrapper wrapper;
        Portlet portlet = this.getPortlet();
        if (portlet == null) {
            return new ElementContainer();
        }
        if (portlet instanceof PortletWrapper && !(wrapper = (PortletWrapper)portlet).getAllowView(rundata) && JetspeedResources.getBoolean("defaultportletcontrol.hide.decorator", true)) {
            return new StringElement("");
        }
        return portlet.getContent(rundata);
    }

    public boolean supportsType(MimeType mimeType) {
        boolean allowed = true;
        if (this.getPortlet() != null) {
            allowed = this.getPortlet().supportsType(mimeType);
        }
        if (allowed) {
            PortletControlEntry entry = (PortletControlEntry)Registry.getEntry(Registry.PORTLET_CONTROL, this.getConfig().getName());
            String baseType = mimeType.toString();
            if (entry != null) {
                Iterator i = entry.listMediaTypes();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    MediaTypeEntry media = (MediaTypeEntry)Registry.getEntry(Registry.MEDIA_TYPE, name);
                    if (media == null || !baseType.equals(media.getMimeType())) continue;
                    allowed = true;
                    break;
                }
            }
        }
        return allowed;
    }

    public int size() {
        if (this.getPortlet() instanceof PortletSet) {
            return ((PortletSet)this.getPortlet()).size();
        }
        return this.getPortlet() == null ? 0 : 1;
    }

    public Portlet[] toArray() {
        if (this.getPortlet() instanceof PortletSet) {
            return ((PortletSet)this.getPortlet()).toArray();
        }
        Portlet[] p = new Portlet[]{this.getPortlet()};
        return p;
    }

    public Portlet getPortletAt(int pos) {
        if (this.getPortlet() instanceof PortletSet) {
            return ((PortletSet)this.getPortlet()).getPortletAt(pos);
        }
        if (pos == 0) {
            return this.getPortlet();
        }
        return null;
    }

    public Enumeration getPortlets() {
        if (this.getPortlet() instanceof PortletSet) {
            return ((PortletSet)this.getPortlet()).getPortlets();
        }
        Vector<Portlet> v = new Vector<Portlet>();
        if (this.getPortlet() != null) {
            v.addElement(this.getPortlet());
        }
        return v.elements();
    }

    public synchronized void addPortlet(Portlet portlet) {
        if (this.getPortlet() instanceof PortletSet) {
            ((PortletSet)this.getPortlet()).addPortlet(portlet);
        }
    }

    public synchronized void addPortlet(Portlet portlet, int position) {
        if (this.getPortlet() instanceof PortletSet) {
            ((PortletSet)this.getPortlet()).addPortlet(portlet, position);
        }
    }

    public synchronized void addPortlet(Portlet portlet, PortletSet.Constraints constraints) {
        if (this.getPortlet() instanceof PortletSet) {
            ((PortletSet)this.getPortlet()).addPortlet(portlet, constraints);
        }
    }

    public synchronized void addPortlet(Portlet portlet, PortletSet.Constraints constraint, int position) {
        if (this.getPortlet() instanceof PortletSet) {
            ((PortletSet)this.getPortlet()).addPortlet(portlet, constraint, position);
        }
    }

    public PortletController getController() {
        if (this.getPortlet() instanceof PortletSet) {
            return ((PortletSet)this.getPortlet()).getController();
        }
        return null;
    }

    public synchronized void setController(PortletController controller) {
        if (this.getPortlet() instanceof PortletSet) {
            ((PortletSet)this.getPortlet()).setController(controller);
        }
    }

    public boolean allowClose(RunData rundata) {
        Portlet p = this.getPortlet();
        if (p == null) {
            return false;
        }
        if ((p instanceof PortletSet || JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), p, "close")) && p instanceof PortletState) {
            return ((PortletState)((Object)p)).allowClose(rundata);
        }
        return false;
    }

    public boolean isClosed(RunData rundata) {
        Portlet p = this.getPortlet();
        if (p != null && p instanceof PortletState) {
            return ((PortletState)((Object)p)).isClosed(rundata);
        }
        return false;
    }

    public void setClosed(boolean close, RunData rundata) {
        Portlet p = this.getPortlet();
        if (p != null && p instanceof PortletState) {
            ((PortletState)((Object)p)).setClosed(close, rundata);
        }
    }

    public boolean allowInfo(RunData rundata) {
        Portlet p = this.getPortlet();
        if (p == null) {
            return false;
        }
        if ((p instanceof PortletSet || JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), p, "info")) && p instanceof PortletState) {
            return ((PortletState)((Object)p)).allowInfo(rundata);
        }
        return false;
    }

    public boolean allowCustomize(RunData rundata) {
        Portlet p = this.getPortlet();
        if (p == null) {
            return false;
        }
        if ((p instanceof PortletSet || JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), p, "customize")) && p instanceof PortletState) {
            return ((PortletState)((Object)p)).allowCustomize(rundata);
        }
        return false;
    }

    public boolean allowMaximize(RunData rundata) {
        Portlet p = this.getPortlet();
        if (p == null) {
            return false;
        }
        if ((p instanceof PortletSet || JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), p, "maximize")) && p instanceof PortletState) {
            return ((PortletState)((Object)p)).allowMaximize(rundata);
        }
        return false;
    }

    public boolean allowMinimize(RunData rundata) {
        Portlet p = this.getPortlet();
        if (p == null) {
            return false;
        }
        if ((p instanceof PortletSet || JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), p, "minimize")) && p instanceof PortletState) {
            return ((PortletState)((Object)p)).allowMinimize(rundata);
        }
        return false;
    }

    public boolean allowPrintFriendly(RunData rundata) {
        Portlet p = this.getPortlet();
        if (p == null) {
            return false;
        }
        if ((p instanceof PortletSet || JetspeedSecurity.checkPermission((JetspeedUser)rundata.getUser(), p, "print_friendly")) && p instanceof PortletState) {
            return ((PortletState)((Object)p)).allowPrintFriendly(rundata);
        }
        return false;
    }

    public boolean isMinimized(RunData rundata) {
        Portlet p = this.getPortlet();
        if (p != null && p instanceof PortletState) {
            return ((PortletState)((Object)p)).isMinimized(rundata);
        }
        return false;
    }

    public void setMinimized(boolean minimize, RunData rundata) {
        Portlet p = this.getPortlet();
        if (p != null && p instanceof PortletState) {
            ((PortletState)((Object)p)).setMinimized(minimize, rundata);
        }
    }

    public String getID() {
        return this.portlet.getID();
    }

    public void setID(String id) {
        this.portlet.setID(id);
    }

    public Portlet getPortletByID(String id) {
        Portlet p = this.getPortlet();
        if (null == p) {
            return null;
        }
        if (p instanceof PortletSet) {
            Enumeration e = ((PortletSet)p).getPortlets();
            Portlet portlet = null;
            while (e.hasMoreElements()) {
                portlet = (Portlet)e.nextElement();
                if (!portlet.getID().equals(id)) continue;
                return portlet;
            }
            return portlet;
        }
        return null;
    }

    public Portlet getPortletByName(String name) {
        Portlet p = this.getPortlet();
        if (null == p) {
            return null;
        }
        if (p instanceof PortletSet) {
            Enumeration e = ((PortletSet)p).getPortlets();
            Portlet portlet = null;
            while (e.hasMoreElements()) {
                portlet = (Portlet)e.nextElement();
                if (!portlet.getName().equals(name)) continue;
                return portlet;
            }
            return portlet;
        }
        return null;
    }
}

